/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.container.impl.threading.se;

import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import org.camunda.bpm.container.ExecutorService;
import org.camunda.bpm.container.impl.ContainerIntegrationLogger;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.jobexecutor.ExecuteJobsRunnable;

public class SeExecutorService
implements ExecutorService {
    private static final ContainerIntegrationLogger LOG = ProcessEngineLogger.CONTAINER_INTEGRATION_LOGGER;
    protected ThreadPoolExecutor threadPoolExecutor;

    public SeExecutorService(ThreadPoolExecutor threadPoolExecutor) {
        this.threadPoolExecutor = threadPoolExecutor;
    }

    @Override
    public boolean schedule(Runnable runnable, boolean isLongRunning) {
        if (isLongRunning) {
            return this.executeLongRunning(runnable);
        }
        return this.executeShortRunning(runnable);
    }

    protected boolean executeLongRunning(Runnable runnable) {
        new Thread(runnable).start();
        return true;
    }

    protected boolean executeShortRunning(Runnable runnable) {
        try {
            this.threadPoolExecutor.execute(runnable);
            return true;
        }
        catch (RejectedExecutionException e) {
            LOG.debugRejectedExecutionException(e);
            return false;
        }
    }

    @Override
    public Runnable getExecuteJobsRunnable(List<String> jobIds, ProcessEngineImpl processEngine) {
        return new ExecuteJobsRunnable(jobIds, processEngine);
    }
}

