/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.variable;

import org.camunda.bpm.engine.impl.variable.ValueFields;
import org.camunda.bpm.engine.impl.variable.VariableType;

public class DoubleType
implements VariableType {
    public static final String TYPE_NAME = "double";

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public Object getValue(ValueFields valueFields) {
        return valueFields.getDoubleValue();
    }

    @Override
    public void setValue(Object value, ValueFields valueFields) {
        valueFields.setDoubleValue((Double)value);
    }

    @Override
    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return true;
        }
        return Double.class.isAssignableFrom(value.getClass());
    }

    @Override
    public String getTypeNameForValue(Object value) {
        return Double.class.getSimpleName();
    }
}

