/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.pvm.runtime.operation;

import java.util.List;
import java.util.logging.Logger;
import org.camunda.bpm.engine.delegate.BaseDelegateExecution;
import org.camunda.bpm.engine.delegate.DelegateListener;
import org.camunda.bpm.engine.impl.pvm.PvmException;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.process.TransitionImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.operation.PvmAtomicOperation;

public class PvmAtomicOperationTransitionNotifyListenerTake
implements PvmAtomicOperation {
    private static Logger log = Logger.getLogger(PvmAtomicOperationTransitionNotifyListenerTake.class.getName());

    @Override
    public boolean isAsync(PvmExecutionImpl execution) {
        return false;
    }

    @Override
    public void execute(PvmExecutionImpl execution) {
        TransitionImpl transition = execution.getTransition();
        execution.setActivityInstanceId(null);
        List<DelegateListener<? extends BaseDelegateExecution>> executionListeners = transition.getListeners("take");
        int executionListenerIndex = execution.getListenerIndex();
        if (executionListeners.size() > executionListenerIndex) {
            execution.setEventName("take");
            execution.setEventSource(transition);
            DelegateListener<? extends BaseDelegateExecution> listener = executionListeners.get(executionListenerIndex);
            try {
                execution.invokeListener(listener);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PvmException("couldn't execute event listener : " + e.getMessage(), e);
            }
            execution.setListenerIndex(executionListenerIndex + 1);
            execution.performOperation(this);
        } else {
            log.fine(execution + " takes transition " + transition);
            execution.setListenerIndex(0);
            execution.setEventName(null);
            execution.setEventSource(null);
            ActivityImpl activity = execution.getActivity();
            ActivityImpl nextScope = PvmAtomicOperationTransitionNotifyListenerTake.findNextScope(activity.getFlowScope(), transition.getDestination());
            execution.setActivity(nextScope);
            if (nextScope.isCancelScope()) {
                execution.performOperation(TRANSITION_CANCEL_SCOPE);
            } else {
                execution.performOperation(TRANSITION_CREATE_SCOPE);
            }
        }
    }

    public static ActivityImpl findNextScope(ScopeImpl outerScopeElement, ActivityImpl destination) {
        ActivityImpl nextScope = destination;
        while (nextScope.getParent() instanceof ActivityImpl && nextScope.getParent() != outerScopeElement) {
            nextScope = (ActivityImpl)nextScope.getParent();
        }
        return nextScope;
    }

    @Override
    public String getCanonicalName() {
        return "transition-notify-listener-take";
    }
}

