/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.pvm.runtime.operation;

import org.camunda.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.delegate.CompositeActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.operation.PvmAtomicOperationActivityInstanceEnd;

public class PvmAtomicOperationActivityEnd
extends PvmAtomicOperationActivityInstanceEnd {
    @Override
    protected ScopeImpl getScope(PvmExecutionImpl execution) {
        return execution.getActivity();
    }

    @Override
    protected String getEventName() {
        return "end";
    }

    @Override
    protected void eventNotificationsCompleted(PvmExecutionImpl execution) {
        super.eventNotificationsCompleted(execution);
        ActivityImpl activity = execution.getActivity();
        ActivityImpl parentActivity = activity.getParentActivity();
        if (parentActivity != null && !parentActivity.isScope()) {
            execution.setActivity(parentActivity);
            execution.performOperation(ACTIVITY_END);
        } else if (execution.isProcessInstanceExecution()) {
            execution.performOperation(PROCESS_END);
        } else if (execution.isScope()) {
            ActivityBehavior parentActivityBehavior;
            ActivityBehavior activityBehavior = parentActivityBehavior = parentActivity != null ? parentActivity.getActivityBehavior() : null;
            if (parentActivityBehavior instanceof CompositeActivityBehavior) {
                CompositeActivityBehavior compositeActivityBehavior = (CompositeActivityBehavior)parentActivity.getActivityBehavior();
                if (activity.isScope() && activity.getOutgoingTransitions().isEmpty()) {
                    PvmExecutionImpl parentScopeExecution = execution.getParent();
                    execution.destroy();
                    execution.remove();
                    parentScopeExecution.setActivity(parentActivity);
                    compositeActivityBehavior.lastExecutionEnded(parentScopeExecution);
                } else {
                    execution.setActivity(parentActivity);
                    compositeActivityBehavior.lastExecutionEnded(execution);
                }
            } else {
                PvmExecutionImpl parentScopeExecution = execution.getParent();
                execution.destroy();
                execution.remove();
                if (activity.getParent() == activity.getProcessDefinition() && activity.getOutgoingTransitions().isEmpty()) {
                    parentScopeExecution.setActivity(activity);
                    parentScopeExecution.performOperation(PROCESS_END);
                } else {
                    parentScopeExecution.setActivity(parentActivity);
                    parentScopeExecution.performOperation(ACTIVITY_END);
                }
            }
        } else {
            execution.remove();
            PvmExecutionImpl concurrentRoot = execution.getParent();
            if (concurrentRoot.getExecutions().size() == 1) {
                PvmExecutionImpl lastConcurrent = concurrentRoot.getExecutions().get(0);
                if (!lastConcurrent.isScope()) {
                    concurrentRoot.setActivity(lastConcurrent.getActivity());
                    lastConcurrent.setReplacedBy(concurrentRoot);
                    if (lastConcurrent.getExecutions().size() > 0) {
                        concurrentRoot.getExecutions().clear();
                        for (PvmExecutionImpl pvmExecutionImpl : lastConcurrent.getExecutions()) {
                            concurrentRoot.getExecutions().add(pvmExecutionImpl);
                            pvmExecutionImpl.setParent(concurrentRoot);
                        }
                        lastConcurrent.getExecutions().clear();
                    }
                    concurrentRoot.setVariablesLocal(lastConcurrent.getVariablesLocal());
                    if (!concurrentRoot.isActive() && lastConcurrent.isActive()) {
                        concurrentRoot.setActive(true);
                    }
                    lastConcurrent.remove();
                } else {
                    lastConcurrent.setConcurrent(false);
                }
            }
        }
    }

    protected boolean isExecutionAloneInParent(PvmExecutionImpl execution) {
        ScopeImpl parentScope = execution.getActivity().getParent();
        for (PvmExecutionImpl pvmExecutionImpl : execution.getParent().getExecutions()) {
            if (pvmExecutionImpl == execution || !parentScope.contains(pvmExecutionImpl.getActivity())) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getCanonicalName() {
        return "activity-end";
    }
}

