/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.pvm.process;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.impl.core.model.CoreActivity;
import org.camunda.bpm.engine.impl.pvm.PvmException;
import org.camunda.bpm.engine.impl.pvm.PvmScope;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;

public abstract class ScopeImpl
extends CoreActivity
implements PvmScope {
    private static final long serialVersionUID = 1L;
    protected List<ActivityImpl> activities = new ArrayList<ActivityImpl>();
    protected Map<String, ActivityImpl> namedActivities = new HashMap<String, ActivityImpl>();
    protected ProcessDefinitionImpl processDefinition;

    public ScopeImpl(String id, ProcessDefinitionImpl processDefinition) {
        super(id);
        this.processDefinition = processDefinition;
    }

    @Override
    public ActivityImpl findActivity(String activityId) {
        return (ActivityImpl)super.findActivity(activityId);
    }

    @Override
    public ActivityImpl getChildActivity(String activityId) {
        return this.namedActivities.get(activityId);
    }

    @Override
    public ActivityImpl createActivity(String activityId) {
        ActivityImpl activity = new ActivityImpl(activityId, this.processDefinition);
        if (activityId != null) {
            if (this.processDefinition.findActivity(activityId) != null) {
                throw new PvmException("duplicate activity id '" + activityId + "'");
            }
            this.namedActivities.put(activityId, activity);
        }
        activity.setParent(this);
        this.activities.add(activity);
        return activity;
    }

    public boolean contains(ActivityImpl activity) {
        if (this.namedActivities.containsKey(activity.getId())) {
            return true;
        }
        for (ActivityImpl nestedActivity : this.activities) {
            if (!nestedActivity.contains(activity)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public List<ExecutionListener> getExecutionListeners(String eventName) {
        return super.getListeners(eventName);
    }

    @Deprecated
    public void addExecutionListener(String eventName, ExecutionListener executionListener) {
        super.addListener(eventName, executionListener);
    }

    @Deprecated
    public void addExecutionListener(String eventName, ExecutionListener executionListener, int index) {
        super.addListener(eventName, executionListener, index);
    }

    @Deprecated
    public Map<String, List<ExecutionListener>> getExecutionListeners() {
        return super.getListeners();
    }

    public List<ActivityImpl> getActivities() {
        return this.activities;
    }

    @Override
    public ProcessDefinitionImpl getProcessDefinition() {
        return this.processDefinition;
    }

    public abstract ScopeImpl getParentScope();
}

