/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity.util;

import java.util.Map;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.form.handler.StartFormHandler;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.impl.history.handler.HistoryEventHandler;
import org.camunda.bpm.engine.impl.history.producer.HistoryEventProducer;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoryAwareStartContext;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;

public class FormPropertyStartContext
extends HistoryAwareStartContext {
    protected Map<String, Object> formProperties;

    public FormPropertyStartContext(ActivityImpl selectedInitial) {
        super(selectedInitial);
    }

    public void setFormProperties(Map<String, Object> properties) {
        this.formProperties = properties;
    }

    @Override
    public void initialStarted(PvmExecutionImpl execution) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        int historyLevel = processEngineConfiguration.getHistoryLevel();
        if (historyLevel >= 1 && historyLevel >= 2) {
            HistoryEventProducer eventProducer = processEngineConfiguration.getHistoryEventProducer();
            HistoryEventHandler eventHandler = processEngineConfiguration.getHistoryEventHandler();
            for (String propertyId : this.formProperties.keySet()) {
                Object propertyValue = this.formProperties.get(propertyId);
                HistoryEvent evt = eventProducer.createFormPropertyUpdateEvt((ExecutionEntity)execution, propertyId, propertyValue, null);
                eventHandler.handleEvent(evt);
            }
        }
        ProcessDefinitionEntity pd = (ProcessDefinitionEntity)execution.getProcessDefinition();
        StartFormHandler startFormHandler = pd.getStartFormHandler();
        startFormHandler.submitFormProperties(this.formProperties, (ExecutionEntity)execution);
        super.initialStarted(execution);
    }
}

