/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.impl.persistence.AbstractHistoricManager;
import org.camunda.bpm.engine.impl.persistence.entity.AttachmentEntity;
import org.camunda.bpm.engine.task.Attachment;

public class AttachmentManager
extends AbstractHistoricManager {
    public List<Attachment> findAttachmentsByProcessInstanceId(String processInstanceId) {
        this.checkHistoryEnabled();
        return this.getDbSqlSession().selectList("selectAttachmentsByProcessInstanceId", processInstanceId);
    }

    public List<Attachment> findAttachmentsByTaskId(String taskId) {
        this.checkHistoryEnabled();
        return this.getDbSqlSession().selectList("selectAttachmentsByTaskId", taskId);
    }

    public void deleteAttachmentsByTaskId(String taskId) {
        this.checkHistoryEnabled();
        List attachments = this.getDbSqlSession().selectList("selectAttachmentsByTaskId", taskId);
        for (AttachmentEntity attachment : attachments) {
            String contentId = attachment.getContentId();
            if (contentId != null) {
                this.getByteArrayManager().deleteByteArrayById(contentId);
            }
            this.getDbSqlSession().delete(attachment);
        }
    }

    public Attachment findAttachmentByTaskIdAndAttachmentId(String taskId, String attachmentId) {
        this.checkHistoryEnabled();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("taskId", taskId);
        parameters.put("id", attachmentId);
        return (AttachmentEntity)this.getDbSqlSession().selectOne("selectAttachmentByTaskIdAndAttachmentId", parameters);
    }
}

