/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.mail;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Part;
import javax.mail.internet.MimeMultipart;
import org.camunda.bpm.engine.impl.persistence.entity.AttachmentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.util.IoUtil;
import org.camunda.bpm.engine.impl.util.json.JSONObject;

public class MailTransformer {
    private static Logger log = Logger.getLogger(MailTransformer.class.getName());
    public static int ATTACHMENT_SIZE_LIMIT = 0xA00000;
    protected Message message;
    protected boolean containsHtml = false;
    protected StringBuilder messageText = new StringBuilder();
    protected StringBuilder messageHtml = new StringBuilder();
    protected List<String> recipients = new ArrayList<String>();
    protected List<AttachmentEntity> attachments = new ArrayList<AttachmentEntity>();
    private static final String INDENT_WHITESPACE = "                                                                                ";

    public MailTransformer(Message message) throws Exception {
        this.message = message;
        this.processRecipients(message);
        this.processContentPart(0, (Part)message);
        AttachmentEntity attachment = new AttachmentEntity();
        attachment.setName(message.getSubject());
        attachment.setType("email");
        this.attachments.add(attachment);
        JSONObject jsonMail = new JSONObject();
        jsonMail.put("recipients", this.recipients);
        jsonMail.put("sentDate", message.getSentDate());
        jsonMail.put("receivedDate", message.getReceivedDate());
        jsonMail.put("subject", message.getSubject());
        jsonMail.put("htmlContent", this.getHtml());
        String jsonMailString = jsonMail.toString(2);
        byte[] bytes = jsonMailString.getBytes();
        attachment.setContent(new ByteArrayEntity(bytes));
        log.fine("=== json ==========================");
        log.fine(jsonMailString);
        log.fine("=== attachments ==========================");
        for (AttachmentEntity attachmentForLogging : this.attachments) {
            log.fine(attachmentForLogging.getName() + " | " + attachmentForLogging.getType() + " | " + attachmentForLogging.getContent().getBytes().length);
        }
    }

    public String getHtml() {
        return this.containsHtml ? this.messageHtml.toString() : this.messageText.toString();
    }

    public List<AttachmentEntity> getAttachments() {
        return this.attachments;
    }

    protected void processContentPart(int indent, Part part) throws Exception {
        if (part.getContent() instanceof MimeMultipart) {
            this.log(indent, "--- multipart " + this.getMimeType(part) + " ----------------------------------");
            MimeMultipart mimeMultipart = (MimeMultipart)part.getContent();
            for (int i = 0; i < mimeMultipart.getCount(); ++i) {
                BodyPart bodyPart = mimeMultipart.getBodyPart(i);
                this.processContentPart(indent + 1, (Part)bodyPart);
            }
        } else {
            this.log(indent, "--- part " + this.getMimeType(part) + " ----------------------------------");
            if (part.isMimeType("text/plain")) {
                String contentText = (String)part.getContent();
                this.log(indent, "adding plain text: " + contentText);
                this.messageText.append(contentText);
            } else if (part.isMimeType("text/html")) {
                String rawHtml = (String)part.getContent();
                this.log(indent, "raw html: " + rawHtml);
                String cleanedUpHtml = this.htmlExtractBodyContent(rawHtml);
                this.log(indent, "adding cleaned up html: " + cleanedUpHtml);
                this.containsHtml = true;
                this.messageHtml.append(cleanedUpHtml);
            } else {
                String fileName = part.getFileName();
                this.log(indent, "unknown content part | " + part.getContentType() + " | " + part.getDisposition() + " | " + Arrays.toString(part.getHeader("Content-ID")) + " | " + fileName + " | " + part.getContent().getClass().getName());
                if (part.getSize() != -1 && part.getSize() < ATTACHMENT_SIZE_LIMIT && part.getContent() instanceof InputStream) {
                    String attachmentName = null;
                    String attachmentType = null;
                    String[] contentIdArray = part.getHeader("Content-ID");
                    if (contentIdArray != null && contentIdArray.length > 0) {
                        attachmentName = contentIdArray[0].trim();
                        if (attachmentName.startsWith("<") && attachmentName.endsWith(">")) {
                            attachmentName = attachmentName.substring(1, attachmentName.length() - 2).trim();
                        }
                        attachmentType = this.getImageMimeType(attachmentName);
                    } else if ("inline".equalsIgnoreCase(part.getDisposition())) {
                        attachmentName = fileName;
                        attachmentType = this.getImageMimeType(attachmentName);
                        this.messageText.append("<img id=\"cid:" + fileName + "\" src=\"cid:" + fileName + "\" />");
                        this.messageHtml.append("<img id=\"cid:" + fileName + "\" src=\"cid:" + fileName + "\" />");
                    }
                    if (attachmentName == null) {
                        attachmentName = fileName;
                        attachmentType = "email-attachment";
                    }
                    AttachmentEntity attachment = new AttachmentEntity();
                    attachment.setName(attachmentName);
                    attachment.setType(attachmentType);
                    this.attachments.add(attachment);
                    byte[] bytes = IoUtil.readInputStream((InputStream)part.getContent(), "mail attachment " + attachmentName);
                    attachment.setContent(new ByteArrayEntity(bytes));
                }
            }
        }
    }

    protected String getImageMimeType(String attachmentName) {
        int lastDotIndex = attachmentName.lastIndexOf(46);
        if (lastDotIndex != -1) {
            String extension = attachmentName.substring(lastDotIndex + 1);
            if ("jpg".equals(extension)) {
                extension = "jpeg";
            }
            return "image/" + extension;
        }
        return "email-inline-image";
    }

    void log(int indent, String msg) {
        log.fine(INDENT_WHITESPACE.substring(0, indent * 2) + msg.replaceAll("\\s", " "));
    }

    protected void processRecipients(Message message) throws Exception {
        for (Address recipientAddress : message.getAllRecipients()) {
            String recipient = recipientAddress.toString();
            int ltIndex = recipient.indexOf(60);
            int atIndex = recipient.indexOf(64);
            int gtIndex = recipient.indexOf(62);
            if (ltIndex != -1 && atIndex != -1 && gtIndex != -1 && ltIndex < atIndex && atIndex < gtIndex) {
                recipient = recipient.substring(ltIndex + 1, gtIndex);
            }
            this.recipients.add(recipient);
        }
    }

    public String htmlExtractBodyContent(String rawHtml) {
        String html = rawHtml.trim();
        html = this.htmlRemoveOuterTag(html, "html");
        html = html.trim();
        html = this.htmlRemoveStartTag(html, "head");
        html = this.htmlRemoveOuterTag(html, "body");
        html = this.htmlRemoveStartTag(html, "head");
        return html;
    }

    protected String htmlRemoveStartTag(String html, String tagName) {
        int endIndex = -1;
        if (html.startsWith("<" + tagName)) {
            endIndex = html.indexOf("</" + tagName + ">");
        } else if (html.startsWith("<" + tagName.toUpperCase())) {
            endIndex = html.indexOf("</" + tagName.toUpperCase() + ">");
        }
        if (endIndex != -1) {
            html = html.substring(endIndex += tagName.length() + 3);
        }
        return html;
    }

    protected String htmlRemoveOuterTag(String html, String tagName) {
        if ((html = html.trim()).startsWith("<" + tagName) || html.startsWith("<" + tagName.toUpperCase())) {
            int endIndex = html.indexOf(62);
            html = html.substring(endIndex + 1, html.length() - (tagName.length() + 3));
        }
        return html;
    }

    public String getMimeType(Part part) throws Exception {
        String mimeType = part.getContentType();
        int semicolonIndex = mimeType.indexOf(59);
        if (semicolonIndex != -1) {
            mimeType = mimeType.substring(0, semicolonIndex);
        }
        mimeType = mimeType.trim();
        mimeType = mimeType.toLowerCase();
        return mimeType;
    }

    public List<String> getRecipients() {
        return this.recipients;
    }

    public void setRecipients(List<String> recipients) {
        this.recipients = recipients;
    }

    public Message getMessage() {
        return this.message;
    }
}

