/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.execution;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnCaseInstance;
import org.camunda.bpm.engine.impl.cmmn.execution.PlanItemState;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.camunda.bpm.engine.impl.cmmn.operation.CmmnAtomicOperation;
import org.camunda.bpm.engine.impl.core.instance.CoreExecution;
import org.camunda.bpm.engine.impl.core.variable.CoreVariableScope;

public abstract class CmmnExecution
extends CoreExecution
implements CmmnCaseInstance {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(CmmnExecution.class.getName());
    protected transient CmmnCaseDefinition caseDefinition;
    protected transient CmmnActivity activity;
    protected transient CmmnActivity nextActivity;
    protected String activityInstanceId;
    protected int previousState = -1;
    protected int state;

    public abstract List<? extends CmmnExecution> getPlanItems();

    @Override
    public CmmnExecution findPlanItem(String activityId) {
        if (this.getActivity() != null && this.getActivity().getId().equals(activityId)) {
            return this;
        }
        for (CmmnExecution cmmnExecution : this.getPlanItems()) {
            CmmnExecution result = cmmnExecution.findPlanItem(activityId);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public String getCaseBusinessKey() {
        return this.getCaseInstance().getBusinessKey();
    }

    public CmmnCaseDefinition getCaseDefinition() {
        return this.caseDefinition;
    }

    public void setCaseDefinition(CmmnCaseDefinition caseDefinition) {
        this.caseDefinition = caseDefinition;
    }

    public abstract CmmnExecution getCaseInstance();

    public abstract void setCaseInstance(CmmnExecution var1);

    public boolean isCaseInstance() {
        return this.getParent() == null;
    }

    @Override
    public String getCaseInstanceId() {
        return this.getCaseInstance().getId();
    }

    public abstract CmmnExecution getParent();

    public abstract void setParent(CmmnExecution var1);

    @Override
    public CmmnActivity getActivity() {
        return this.activity;
    }

    public void setActivity(CmmnActivity activity) {
        this.activity = activity;
    }

    @Override
    public String getActivityInstanceId() {
        return this.activityInstanceId;
    }

    public void setActivityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
    }

    protected abstract String generateActivityInstanceId(String var1);

    public CmmnActivity getNextActivity() {
        return this.nextActivity;
    }

    public void setNextActivity(CmmnActivity nextActivity) {
        this.nextActivity = nextActivity;
    }

    @Override
    public String getParentActivityInstanceId() {
        if (this.isCaseInstance()) {
            return this.id;
        }
        CmmnExecution parent = this.getParent();
        if (parent != null) {
            return parent.getActivityInstanceId();
        }
        return null;
    }

    @Override
    protected CoreVariableScope getParentVariableScope() {
        return this.getParent();
    }

    public int getState() {
        return this.state;
    }

    public void setState(PlanItemState state) {
        this.previousState = this.state;
        this.state = state.getStateCode();
    }

    public void setState(int state) {
        this.state = state;
    }

    @Override
    public boolean isAvailable() {
        return this.state == PlanItemState.AVAILABLE.getStateCode();
    }

    @Override
    public boolean isEnabled() {
        return this.state == PlanItemState.ENABLED.getStateCode();
    }

    @Override
    public boolean isDisabled() {
        return this.state == PlanItemState.DISABLED.getStateCode();
    }

    @Override
    public boolean isActive() {
        return this.state == PlanItemState.ACTIVE.getStateCode();
    }

    @Override
    public boolean isCompleted() {
        return this.state == PlanItemState.COMPLETED.getStateCode();
    }

    @Override
    public boolean isSuspended() {
        return this.state == PlanItemState.SUSPENDED.getStateCode();
    }

    @Override
    public boolean isTerminated() {
        return this.state == PlanItemState.TERMINATED.getStateCode();
    }

    @Override
    public boolean isFailed() {
        return this.state == PlanItemState.FAILED.getStateCode();
    }

    @Override
    public boolean isClosed() {
        return this.state == PlanItemState.CLOSED.getStateCode();
    }

    public int getPreviousState() {
        return this.previousState;
    }

    public void setPreviousState(int previousState) {
        this.previousState = this.state;
    }

    @Override
    public void create() {
        this.create(null, null);
    }

    @Override
    public void create(Map<String, Object> variables) {
        this.create(null, variables);
    }

    @Override
    public void create(String businessKey) {
        this.create(businessKey, null);
    }

    @Override
    public void create(String businessKey, Map<String, Object> variables) {
        if (variables != null) {
            this.setVariables(variables);
        }
        if (businessKey != null) {
            this.setBusinessKey(businessKey);
        }
        this.setState(PlanItemState.ACTIVE);
        this.performOperation(CmmnAtomicOperation.CASE_NOTIFY_LISTENER_CREATE);
    }

    @Override
    public void create(List<CmmnActivity> activities) {
        if (!this.isActive()) {
            throw new ProcessEngineException();
        }
        ArrayList<CmmnExecution> children = new ArrayList<CmmnExecution>();
        for (CmmnActivity currentActivity : activities) {
            CmmnExecution child = this.createPlanItem(currentActivity);
            children.add(child);
        }
        for (CmmnExecution child : children) {
            if (this.isActive()) {
                child.performOperation(CmmnAtomicOperation.PLAN_ITEM_NOTIFY_LISTENER_CREATE);
                continue;
            }
            log.fine("Not taking child '" + child + "', parent plan item has ended.");
        }
    }

    protected abstract CmmnExecution createPlanItem(CmmnActivity var1);

    protected abstract CmmnExecution newPlanItem();

    @Override
    public void enable() {
        this.transition(PlanItemState.AVAILABLE, PlanItemState.ENABLED, CmmnAtomicOperation.PLAN_ITEM_NOTIFY_LISTENER_ENABLE);
    }

    @Override
    public void disable() {
        this.transition(PlanItemState.ENABLED, PlanItemState.DISABLED, CmmnAtomicOperation.PLAN_ITEM_NOTIFY_LISTENER_DISABLE);
    }

    @Override
    public void reenable() {
        this.transition(PlanItemState.DISABLED, PlanItemState.ENABLED, CmmnAtomicOperation.PLAN_ITEM_NOTIFY_LISTENER_RE_ENABLE);
    }

    @Override
    public void manualStart() {
        this.transition(PlanItemState.ENABLED, PlanItemState.ACTIVE, CmmnAtomicOperation.PLAN_ITEM_NOTIFY_LISTENER_MANUAL_START);
    }

    @Override
    public void start() {
        this.transition(PlanItemState.AVAILABLE, PlanItemState.ACTIVE, CmmnAtomicOperation.PLAN_ITEM_NOTIFY_LISTENER_START);
    }

    @Override
    public void complete() {
        this.transition(PlanItemState.ACTIVE, PlanItemState.COMPLETED, CmmnAtomicOperation.PLAN_ITEM_NOTIFY_LISTENER_COMPLETE);
    }

    protected void transition(PlanItemState from, PlanItemState to, CmmnAtomicOperation nextOperation) {
        if (this.state != from.getStateCode()) {
            throw new ProcessEngineException();
        }
        this.setState(to);
        if (nextOperation != null) {
            this.performOperation(nextOperation);
        }
    }

    public String toString() {
        if (this.isCaseInstance()) {
            return "CaseInstance[" + this.getToStringIdentity() + "]";
        }
        return "CmmnExecution[" + this.getToStringIdentity() + "]";
    }

    protected String getToStringIdentity() {
        return this.id;
    }
}

