/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import org.camunda.bpm.engine.impl.db.DbSqlSession;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.AttachmentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;

public class GetAttachmentContentCmd
implements Command<InputStream>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String attachmentId;

    public GetAttachmentContentCmd(String attachmentId) {
        this.attachmentId = attachmentId;
    }

    @Override
    public InputStream execute(CommandContext commandContext) {
        DbSqlSession dbSqlSession = commandContext.getDbSqlSession();
        AttachmentEntity attachment = dbSqlSession.selectById(AttachmentEntity.class, this.attachmentId);
        String contentId = attachment.getContentId();
        if (contentId == null) {
            return null;
        }
        ByteArrayEntity byteArray = dbSqlSession.selectById(ByteArrayEntity.class, contentId);
        byte[] bytes = byteArray.getBytes();
        return new ByteArrayInputStream(bytes);
    }
}

