/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;

public class FindActiveActivityIdsCmd
implements Command<List<String>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String executionId;

    public FindActiveActivityIdsCmd(String executionId) {
        this.executionId = executionId;
    }

    @Override
    public List<String> execute(CommandContext commandContext) {
        if (this.executionId == null) {
            throw new ProcessEngineException("executionId is null");
        }
        ExecutionEntity execution = commandContext.getExecutionManager().findExecutionById(this.executionId);
        if (execution == null) {
            throw new ProcessEngineException("execution " + this.executionId + " doesn't exist");
        }
        return execution.findActiveActivityIds();
    }
}

