/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cfg.TransactionState;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.FailedJobListener;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutorContext;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;

public class ExecuteJobsCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(ExecuteJobsCmd.class.getName());
    protected String jobId;

    public ExecuteJobsCmd(String jobId) {
        this.jobId = jobId;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        if (this.jobId == null) {
            throw new ProcessEngineException("jobId is null");
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Executing job " + this.jobId);
        }
        JobEntity job = commandContext.getJobManager().findJobById(this.jobId);
        CommandExecutor commandExecutor = Context.getProcessEngineConfiguration().getCommandExecutorTxRequiresNew();
        JobExecutorContext jobExecutorContext = Context.getJobExecutorContext();
        if (job == null) {
            if (jobExecutorContext != null) {
                log.log(Level.FINE, "Job with Id " + this.jobId + " was acquired but cannot be found in database.");
                return null;
            }
            throw new ProcessEngineException("No job found with id '" + this.jobId + "'");
        }
        if (jobExecutorContext != null) {
            jobExecutorContext.setCurrentJob(job);
        }
        try {
            job.execute(commandContext);
            Object var5_5 = null;
            return var5_5;
        }
        catch (RuntimeException exception) {
            FailedJobListener failedJobListener = this.createFailedJobListener(exception, commandExecutor);
            try {
                commandContext.getTransactionContext().addTransactionListener(TransactionState.ROLLED_BACK, failedJobListener);
            }
            catch (Exception ex) {
                log.log(Level.FINE, "Could not register transaction synchronization. Probably the TX has already been rolled back by application code.", ex);
                this.executeCmdInNewTx(commandContext, failedJobListener);
            }
            throw exception;
        }
        finally {
            if (jobExecutorContext != null) {
                jobExecutorContext.setCurrentJob(null);
            }
        }
    }

    protected void executeCmdInNewTx(CommandContext commandContext, FailedJobListener failedJobListener) {
        try {
            failedJobListener.execute(commandContext);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Could not execute the FailedJobListener: " + ex.getMessage(), ex);
        }
    }

    protected FailedJobListener createFailedJobListener(RuntimeException exception, CommandExecutor commandExecutor) {
        return new FailedJobListener(commandExecutor, this.jobId, exception);
    }
}

