/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.application.ProcessApplicationRegistration;
import org.camunda.bpm.engine.impl.ProcessDefinitionQueryImpl;
import org.camunda.bpm.engine.impl.cfg.TransactionState;
import org.camunda.bpm.engine.impl.cmd.ActivateProcessDefinitionCmd;
import org.camunda.bpm.engine.impl.cmd.RegisterDeploymentCmd;
import org.camunda.bpm.engine.impl.cmd.RegisterProcessApplicationCmd;
import org.camunda.bpm.engine.impl.cmd.SuspendProcessDefinitionCmd;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentFailListener;
import org.camunda.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessApplicationDeploymentImpl;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ResourceEntity;
import org.camunda.bpm.engine.impl.repository.DeploymentBuilderImpl;
import org.camunda.bpm.engine.impl.repository.ProcessApplicationDeploymentBuilderImpl;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.ProcessApplicationDeploymentBuilder;
import org.camunda.bpm.engine.repository.ProcessDefinition;

public class DeployCmd<T>
implements Command<Deployment>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(DeployCmd.class.getName());
    protected DeploymentBuilderImpl deploymentBuilder;

    public DeployCmd(DeploymentBuilderImpl deploymentBuilder) {
        this.deploymentBuilder = deploymentBuilder;
    }

    @Override
    public Deployment execute(CommandContext commandContext) {
        if (Context.getProcessEngineConfiguration().isDeploymentLockUsed()) {
            commandContext.getPropertyManager().acquireExclusiveLock();
        }
        DeploymentEntity deployment = this.deploymentBuilder.getDeployment();
        deployment.setDeploymentTime(ClockUtil.getCurrentTime());
        DeploymentEntity existingDeployment = null;
        if (this.deploymentBuilder.isDuplicateFilterEnabled()) {
            existingDeployment = Context.getCommandContext().getDeploymentManager().findLatestDeploymentByName(deployment.getName());
            if (existingDeployment != null) {
                log.fine("Found existing deployment " + existingDeployment + " checking resources.");
                if (this.deploymentsDiffer(deployment, existingDeployment)) {
                    log.fine("Resources differ.");
                    existingDeployment = null;
                } else {
                    log.fine("Resources do not differ.");
                }
            } else {
                log.fine("No existing deployment for name " + deployment.getName() + ".");
            }
        }
        if (existingDeployment == null) {
            log.fine("Creating new deployment.");
            deployment.setNew(true);
            Context.getCommandContext().getDeploymentManager().insertDeployment(deployment);
        } else {
            log.fine("Using existing deployment.");
            deployment = existingDeployment;
        }
        if (this.deploymentBuilder.getProcessDefinitionsActivationDate() != null) {
            this.scheduleProcessDefinitionActivation(commandContext, deployment);
        }
        if (this.deploymentBuilder instanceof ProcessApplicationDeploymentBuilder) {
            ProcessApplicationRegistration registration = this.registerProcessApplication(commandContext, deployment);
            return new ProcessApplicationDeploymentImpl(deployment, registration);
        }
        this.registerWithJobExecutor(commandContext, deployment);
        return deployment;
    }

    protected ProcessApplicationRegistration registerProcessApplication(CommandContext commandContext, DeploymentEntity deployment) {
        ProcessApplicationDeploymentBuilderImpl appDeploymentBuilder = (ProcessApplicationDeploymentBuilderImpl)this.deploymentBuilder;
        ProcessApplicationReference appReference = appDeploymentBuilder.getProcessApplicationReference();
        boolean resumePreviousVersions = appDeploymentBuilder.isResumePreviousVersions();
        HashSet<String> deploymentsToRegister = new HashSet<String>(Collections.singleton(deployment.getId()));
        if (resumePreviousVersions) {
            this.resumePreviousVersions(commandContext, deployment, deploymentsToRegister);
        }
        return new RegisterProcessApplicationCmd(deploymentsToRegister, appReference).execute(commandContext);
    }

    protected void resumePreviousVersions(CommandContext commandContext, DeploymentEntity deployment, Set<String> deploymentsToRegister) {
        List<ProcessDefinitionEntity> deployedProcessDefinitions = deployment.getDeployedArtifacts(ProcessDefinitionEntity.class);
        if (deployedProcessDefinitions == null) {
            deployedProcessDefinitions = new ProcessDefinitionQueryImpl(Context.getCommandContext()).deploymentId(deployment.getId()).list();
        }
        for (ProcessDefinitionEntity processDefinitionEntity : deployedProcessDefinitions) {
            if (processDefinitionEntity.getVersion() <= 1) continue;
            List previousVersionDefinition = new ProcessDefinitionQueryImpl(commandContext).processDefinitionKey(processDefinitionEntity.getKey()).list();
            for (ProcessDefinition processDefinition : previousVersionDefinition) {
                deploymentsToRegister.add(processDefinition.getDeploymentId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerWithJobExecutor(CommandContext commandContext, DeploymentEntity deployment) {
        try {
            new RegisterDeploymentCmd(deployment.getId()).execute(commandContext);
        }
        finally {
            DeploymentFailListener listener = new DeploymentFailListener(deployment.getId());
            try {
                commandContext.getTransactionContext().addTransactionListener(TransactionState.ROLLED_BACK, listener);
            }
            catch (Exception e) {
                log.log(Level.FINE, "Could not register transaction synchronization. Probably the TX has already been rolled back by application code.", e);
                listener.execute(commandContext);
            }
        }
    }

    protected boolean deploymentsDiffer(DeploymentEntity deployment, DeploymentEntity saved) {
        if (deployment.getResources() == null || saved.getResources() == null) {
            return true;
        }
        Map<String, ResourceEntity> resources = deployment.getResources();
        Map<String, ResourceEntity> savedResources = saved.getResources();
        for (String resourceName : resources.keySet()) {
            byte[] savedBytes;
            ResourceEntity resource;
            byte[] bytes;
            ResourceEntity savedResource = savedResources.get(resourceName);
            if (savedResource == null) {
                return true;
            }
            if (savedResource.isGenerated() || Arrays.equals(bytes = (resource = resources.get(resourceName)).getBytes(), savedBytes = savedResource.getBytes())) continue;
            return true;
        }
        return false;
    }

    protected void scheduleProcessDefinitionActivation(CommandContext commandContext, DeploymentEntity deployment) {
        for (ProcessDefinitionEntity processDefinitionEntity : deployment.getDeployedArtifacts(ProcessDefinitionEntity.class)) {
            SuspendProcessDefinitionCmd suspendProcessDefinitionCmd = new SuspendProcessDefinitionCmd(processDefinitionEntity, false, null);
            suspendProcessDefinitionCmd.execute(commandContext);
            ActivateProcessDefinitionCmd activateProcessDefinitionCmd = new ActivateProcessDefinitionCmd(processDefinitionEntity, false, this.deploymentBuilder.getProcessDefinitionsActivationDate());
            activateProcessDefinitionCmd.execute(commandContext);
        }
    }
}

