/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.AttachmentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;

public class DeleteTaskAttachmentCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String attachmentId;
    protected String taskId;

    public DeleteTaskAttachmentCmd(String taskId, String attachmentId) {
        this.attachmentId = attachmentId;
        this.taskId = taskId;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        AttachmentEntity attachment = (AttachmentEntity)commandContext.getAttachmentManager().findAttachmentByTaskIdAndAttachmentId(this.taskId, this.attachmentId);
        if (attachment == null) {
            throw new ProcessEngineException("No attachment exist for task id '" + this.taskId + " and attachmentId '" + this.attachmentId + "'.");
        }
        commandContext.getDbSqlSession().delete(attachment);
        if (attachment.getContentId() != null) {
            commandContext.getByteArrayManager().deleteByteArrayById(attachment.getContentId());
        }
        if (attachment.getTaskId() != null) {
            TaskEntity task = commandContext.getTaskManager().findTaskById(attachment.getTaskId());
            PropertyChange propertyChange = new PropertyChange("name", null, attachment.getName());
            commandContext.getOperationLogManager().logAttachmentOperation("DeleteAttachment", task, propertyChange);
        }
        return null;
    }
}

