/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.AuthorizationQueryImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationEntity;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;

public class DeleteAuthorizationCmd
implements Command<Void> {
    protected String authorizationId;

    public DeleteAuthorizationCmd(String authorizationId) {
        this.authorizationId = authorizationId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        AuthorizationEntity authorization = (AuthorizationEntity)new AuthorizationQueryImpl(commandContext).authorizationId(this.authorizationId).singleResult();
        if (authorization == null) {
            throw new ProcessEngineException("Authorization for Id '" + this.authorizationId + "' does not exist.");
        }
        authorizationManager.delete(authorization);
        return null;
    }
}

