/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.io.Serializable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.impl.AbstractVariableQueryImpl;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.VariableInstanceQueryProperty;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.runtime.VariableInstanceQuery;

public class VariableInstanceQueryImpl
extends AbstractVariableQueryImpl<VariableInstanceQuery, VariableInstance>
implements VariableInstanceQuery,
Serializable {
    private static final Logger LOGGER = Logger.getLogger(VariableInstanceQuery.class.getName());
    private static final long serialVersionUID = 1L;
    protected String variableId;
    protected String variableName;
    protected String variableNameLike;
    protected String[] executionIds;
    protected String[] processInstanceIds;
    protected String[] taskIds;
    protected String[] activityInstanceIds;
    protected boolean isByteArrayFetchingEnabled = true;

    public VariableInstanceQueryImpl() {
    }

    public VariableInstanceQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public VariableInstanceQuery variableId(String id) {
        this.assertParamNotNull("id", id);
        this.variableId = id;
        return this;
    }

    @Override
    public VariableInstanceQuery variableName(String variableName) {
        this.variableName = variableName;
        return this;
    }

    @Override
    public VariableInstanceQuery variableNameLike(String variableNameLike) {
        this.variableNameLike = variableNameLike;
        return this;
    }

    @Override
    public VariableInstanceQuery executionIdIn(String ... executionIds) {
        this.executionIds = executionIds;
        return this;
    }

    @Override
    public VariableInstanceQuery processInstanceIdIn(String ... processInstanceIds) {
        this.processInstanceIds = processInstanceIds;
        return this;
    }

    @Override
    public VariableInstanceQuery taskIdIn(String ... taskIds) {
        this.taskIds = taskIds;
        return this;
    }

    @Override
    public VariableInstanceQuery activityInstanceIdIn(String ... activityInstanceIds) {
        this.activityInstanceIds = activityInstanceIds;
        return this;
    }

    @Override
    public VariableInstanceQuery disableBinaryFetching() {
        this.isByteArrayFetchingEnabled = false;
        return this;
    }

    @Override
    public VariableInstanceQuery orderByVariableName() {
        this.orderBy(VariableInstanceQueryProperty.VARIABLE_NAME);
        return this;
    }

    @Override
    public VariableInstanceQuery orderByVariableType() {
        this.orderBy(VariableInstanceQueryProperty.VARIABLE_TYPE);
        return this;
    }

    @Override
    public VariableInstanceQuery orderByActivityInstanceId() {
        this.orderBy(VariableInstanceQueryProperty.ACTIVITY_INSTANCE_ID);
        return this;
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        this.ensureVariablesInitialized();
        return commandContext.getVariableInstanceManager().findVariableInstanceCountByQueryCriteria(this);
    }

    @Override
    public List<VariableInstance> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        this.ensureVariablesInitialized();
        List<VariableInstance> result = commandContext.getVariableInstanceManager().findVariableInstanceByQueryCriteria(this, page);
        if (result == null) {
            return result;
        }
        for (VariableInstance variableInstance : result) {
            VariableInstanceEntity variableInstanceEntity = (VariableInstanceEntity)variableInstance;
            if (!this.isByteArrayFetchingEnabled && "bytes".equals(variableInstanceEntity.getType().getTypeName())) continue;
            try {
                variableInstanceEntity.getValue();
            }
            catch (Exception t) {
                LOGGER.log(Level.FINE, "Exception while getting value for variable", t);
            }
        }
        return result;
    }

    public String getVariableId() {
        return this.variableId;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public String getVariableNameLike() {
        return this.variableNameLike;
    }

    public String[] getExecutionIds() {
        return this.executionIds;
    }

    public String[] getProcessInstanceIds() {
        return this.processInstanceIds;
    }

    public String[] getTaskIds() {
        return this.taskIds;
    }

    public String[] getActivityInstanceIds() {
        return this.activityInstanceIds;
    }
}

