/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.history.HistoricIncident;
import org.camunda.bpm.engine.history.HistoricIncidentQuery;
import org.camunda.bpm.engine.history.IncidentState;
import org.camunda.bpm.engine.impl.AbstractVariableQueryImpl;
import org.camunda.bpm.engine.impl.HistoricIncidentQueryProperty;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;

public class HistoricIncidentQueryImpl
extends AbstractVariableQueryImpl<HistoricIncidentQuery, HistoricIncident>
implements HistoricIncidentQuery {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String incidentType;
    protected String incidentMessage;
    protected String executionId;
    protected String activityId;
    protected String processInstanceId;
    protected String processDefinitionId;
    protected String causeIncidentId;
    protected String rootCauseIncidentId;
    protected String configuration;
    protected IncidentState incidentState;

    public HistoricIncidentQueryImpl() {
    }

    public HistoricIncidentQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public HistoricIncidentQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public HistoricIncidentQuery incidentId(String incidentId) {
        this.assertParamNotNull("incidentId", incidentId);
        this.id = incidentId;
        return this;
    }

    @Override
    public HistoricIncidentQuery incidentType(String incidentType) {
        this.assertParamNotNull("incidentType", incidentType);
        this.incidentType = incidentType;
        return this;
    }

    @Override
    public HistoricIncidentQuery incidentMessage(String incidentMessage) {
        this.assertParamNotNull("incidentMessage", incidentMessage);
        this.incidentMessage = incidentMessage;
        return this;
    }

    @Override
    public HistoricIncidentQuery executionId(String executionId) {
        this.assertParamNotNull("executionId", executionId);
        this.executionId = executionId;
        return this;
    }

    @Override
    public HistoricIncidentQuery activityId(String activityId) {
        this.assertParamNotNull("activityId", activityId);
        this.activityId = activityId;
        return this;
    }

    @Override
    public HistoricIncidentQuery processInstanceId(String processInstanceId) {
        this.assertParamNotNull("processInstanceId", processInstanceId);
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Override
    public HistoricIncidentQuery processDefinitionId(String processDefinitionId) {
        this.assertParamNotNull("processDefinitionId", processDefinitionId);
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Override
    public HistoricIncidentQuery causeIncidentId(String causeIncidentId) {
        this.assertParamNotNull("causeIncidentId", causeIncidentId);
        this.causeIncidentId = causeIncidentId;
        return this;
    }

    @Override
    public HistoricIncidentQuery rootCauseIncidentId(String rootCauseIncidentId) {
        this.assertParamNotNull("rootCauseIncidentId", rootCauseIncidentId);
        this.rootCauseIncidentId = rootCauseIncidentId;
        return this;
    }

    @Override
    public HistoricIncidentQuery configuration(String configuration) {
        this.assertParamNotNull("configuration", configuration);
        this.configuration = configuration;
        return this;
    }

    @Override
    public HistoricIncidentQuery open() {
        if (this.incidentState != null) {
            throw new ProcessEngineException("Already querying for incident state <" + this.incidentState + ">");
        }
        this.incidentState = IncidentState.DEFAULT;
        return this;
    }

    @Override
    public HistoricIncidentQuery resolved() {
        if (this.incidentState != null) {
            throw new ProcessEngineException("Already querying for incident state <" + this.incidentState + ">");
        }
        this.incidentState = IncidentState.RESOLVED;
        return this;
    }

    @Override
    public HistoricIncidentQuery deleted() {
        if (this.incidentState != null) {
            throw new ProcessEngineException("Already querying for incident state <" + this.incidentState + ">");
        }
        this.incidentState = IncidentState.DELETED;
        return this;
    }

    @Override
    public HistoricIncidentQuery orderByIncidentId() {
        this.orderProperty = HistoricIncidentQueryProperty.INCIDENT_ID;
        return this;
    }

    @Override
    public HistoricIncidentQuery orderByCreateTime() {
        this.orderProperty = HistoricIncidentQueryProperty.INCIDENT_CREATE_TIME;
        return this;
    }

    @Override
    public HistoricIncidentQuery orderByEndTime() {
        this.orderProperty = HistoricIncidentQueryProperty.INCIDENT_END_TIME;
        return this;
    }

    @Override
    public HistoricIncidentQuery orderByIncidentType() {
        this.orderProperty = HistoricIncidentQueryProperty.INCIDENT_TYPE;
        return this;
    }

    @Override
    public HistoricIncidentQuery orderByExecutionId() {
        this.orderProperty = HistoricIncidentQueryProperty.EXECUTION_ID;
        return this;
    }

    @Override
    public HistoricIncidentQuery orderByActivityId() {
        this.orderProperty = HistoricIncidentQueryProperty.ACTIVITY_ID;
        return this;
    }

    @Override
    public HistoricIncidentQuery orderByProcessInstanceId() {
        this.orderProperty = HistoricIncidentQueryProperty.PROCESS_INSTANCE_ID;
        return this;
    }

    @Override
    public HistoricIncidentQuery orderByProcessDefinitionId() {
        this.orderProperty = HistoricIncidentQueryProperty.PROCESS_DEFINITION_ID;
        return this;
    }

    @Override
    public HistoricIncidentQuery orderByCauseIncidentId() {
        this.orderProperty = HistoricIncidentQueryProperty.CAUSE_INCIDENT_ID;
        return this;
    }

    @Override
    public HistoricIncidentQuery orderByRootCauseIncidentId() {
        this.orderProperty = HistoricIncidentQueryProperty.ROOT_CAUSE_INCIDENT_ID;
        return this;
    }

    @Override
    public HistoricIncidentQuery orderByConfiguration() {
        this.orderProperty = HistoricIncidentQueryProperty.CONFIGURATION;
        return this;
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getHistoricIncidentManager().findHistoricIncidentCountByQueryCriteria(this);
    }

    @Override
    public List<HistoricIncident> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        return commandContext.getHistoricIncidentManager().findHistoricIncidentByQueryCriteria(this, page);
    }

    public String getId() {
        return this.id;
    }

    public String getIncidentType() {
        return this.incidentType;
    }

    public String getIncidentMessage() {
        return this.incidentMessage;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getCauseIncidentId() {
        return this.causeIncidentId;
    }

    public String getRootCauseIncidentId() {
        return this.rootCauseIncidentId;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public IncidentState getIncidentState() {
        return this.incidentState;
    }
}

