/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.container.impl.jmx.deployment.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.application.AbstractProcessApplication;
import org.camunda.bpm.application.ProcessApplicationDeploymentInfo;
import org.camunda.bpm.application.ProcessApplicationInfo;
import org.camunda.bpm.container.impl.jmx.JmxRuntimeContainerDelegate;
import org.camunda.bpm.container.impl.jmx.kernel.MBeanDeploymentOperation;
import org.camunda.bpm.container.impl.jmx.kernel.MBeanServiceContainer;
import org.camunda.bpm.container.impl.jmx.services.JmxManagedProcessApplication;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineException;

public class InjectionUtil {
    public static Method detectAnnotatedMethod(Class<?> clazz, Class<? extends Annotation> annotationType) {
        Method[] methods;
        for (Method method : methods = clazz.getMethods()) {
            for (Annotation annotaiton : method.getAnnotations()) {
                if (!annotationType.equals(annotaiton.annotationType())) continue;
                return method;
            }
        }
        return null;
    }

    public static Object[] resolveInjections(MBeanDeploymentOperation operationContext, Method lifecycleMethod) {
        Type[] parameterTypes = lifecycleMethod.getGenericParameterTypes();
        ArrayList<Object> parameters = new ArrayList<Object>();
        for (Type parameterType : parameterTypes) {
            ParameterizedType parameterizedType;
            Type[] actualTypeArguments;
            boolean injectionResolved = false;
            if (parameterType instanceof Class) {
                Class parameterClass = (Class)parameterType;
                if (ProcessEngine.class.isAssignableFrom(parameterClass)) {
                    parameters.add(InjectionUtil.getDefaultProcessEngine(operationContext));
                    injectionResolved = true;
                } else if (ProcessApplicationInfo.class.isAssignableFrom(parameterClass)) {
                    parameters.add(InjectionUtil.getProcessApplicationInfo(operationContext));
                    injectionResolved = true;
                }
            } else if (parameterType instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)parameterType).getActualTypeArguments()).length == 1 && ProcessEngine.class.isAssignableFrom((Class)actualTypeArguments[0])) {
                parameters.add(InjectionUtil.getProcessEngines(operationContext));
                injectionResolved = true;
            }
            if (injectionResolved) continue;
            throw new ProcessEngineException("Unsupported parametertype " + parameterType);
        }
        return parameters.toArray();
    }

    public static ProcessApplicationInfo getProcessApplicationInfo(MBeanDeploymentOperation operationContext) {
        MBeanServiceContainer serviceContainer = operationContext.getServiceContainer();
        AbstractProcessApplication processApplication = (AbstractProcessApplication)operationContext.getAttachment("processApplication");
        JmxManagedProcessApplication managedPa = (JmxManagedProcessApplication)serviceContainer.getServiceValue(JmxRuntimeContainerDelegate.ServiceTypes.PROCESS_APPLICATION, processApplication.getName());
        return managedPa.getProcessApplicationInfo();
    }

    public static List<ProcessEngine> getProcessEngines(MBeanDeploymentOperation operationContext) {
        MBeanServiceContainer serviceContainer = operationContext.getServiceContainer();
        ProcessApplicationInfo processApplicationInfo = InjectionUtil.getProcessApplicationInfo(operationContext);
        ArrayList<ProcessEngine> processEngines = new ArrayList<ProcessEngine>();
        for (ProcessApplicationDeploymentInfo deploymentInfo : processApplicationInfo.getDeploymentInfo()) {
            String processEngineName = deploymentInfo.getProcessEngineName();
            processEngines.add((ProcessEngine)serviceContainer.getServiceValue(JmxRuntimeContainerDelegate.ServiceTypes.PROCESS_ENGINE, processEngineName));
        }
        return processEngines;
    }

    public static ProcessEngine getDefaultProcessEngine(MBeanDeploymentOperation operationContext) {
        MBeanServiceContainer serviceContainer = operationContext.getServiceContainer();
        return (ProcessEngine)serviceContainer.getServiceValue(JmxRuntimeContainerDelegate.ServiceTypes.PROCESS_ENGINE, "default");
    }
}

