/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.container.impl.jmx.deployment.jobexecutor;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.camunda.bpm.container.impl.jmx.JmxRuntimeContainerDelegate;
import org.camunda.bpm.container.impl.jmx.kernel.MBeanDeploymentOperation;
import org.camunda.bpm.container.impl.jmx.kernel.MBeanDeploymentOperationStep;
import org.camunda.bpm.container.impl.jmx.kernel.MBeanServiceContainer;
import org.camunda.bpm.container.impl.jmx.services.JmxManagedThreadPool;

public class StartManagedThreadPoolStep
extends MBeanDeploymentOperationStep {
    @Override
    public String getName() {
        return "Deploy Job Executor Thread Pool";
    }

    @Override
    public void performOperationStep(MBeanDeploymentOperation operationContext) {
        MBeanServiceContainer serviceContainer = operationContext.getServiceContainer();
        int queueSize = 3;
        int corePoolSize = 3;
        int maxPoolSize = 10;
        ArrayBlockingQueue<Runnable> threadPoolQueue = new ArrayBlockingQueue<Runnable>(queueSize);
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(corePoolSize, maxPoolSize, 0L, TimeUnit.MILLISECONDS, threadPoolQueue);
        threadPoolExecutor.setRejectedExecutionHandler(new ThreadPoolExecutor.AbortPolicy());
        JmxManagedThreadPool managedThreadPool = new JmxManagedThreadPool(threadPoolQueue, threadPoolExecutor);
        serviceContainer.startService(JmxRuntimeContainerDelegate.ServiceTypes.BPM_PLATFORM, "executor-service", managedThreadPool);
    }
}

