/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.container.impl.jmx.deployment;

import java.util.ArrayList;
import java.util.Map;
import org.camunda.bpm.application.AbstractProcessApplication;
import org.camunda.bpm.application.ProcessApplicationDeploymentInfo;
import org.camunda.bpm.application.impl.ProcessApplicationDeploymentInfoImpl;
import org.camunda.bpm.application.impl.ProcessApplicationInfoImpl;
import org.camunda.bpm.application.impl.metadata.spi.ProcessesXml;
import org.camunda.bpm.container.impl.jmx.JmxRuntimeContainerDelegate;
import org.camunda.bpm.container.impl.jmx.deployment.util.DeployedProcessArchive;
import org.camunda.bpm.container.impl.jmx.kernel.MBeanDeploymentOperation;
import org.camunda.bpm.container.impl.jmx.kernel.MBeanDeploymentOperationStep;
import org.camunda.bpm.container.impl.jmx.kernel.MBeanServiceContainer;
import org.camunda.bpm.container.impl.jmx.services.JmxManagedProcessApplication;

public class StartProcessApplicationServiceStep
extends MBeanDeploymentOperationStep {
    @Override
    public String getName() {
        return "Start Process Application Service";
    }

    @Override
    public void performOperationStep(MBeanDeploymentOperation operationContext) {
        AbstractProcessApplication processApplication = (AbstractProcessApplication)operationContext.getAttachment("processApplication");
        Map processesXmls = (Map)operationContext.getAttachment("processesXmlList");
        Map processArchiveDeploymentMap = (Map)operationContext.getAttachment("processArchiveDeploymentMap");
        MBeanServiceContainer serviceContainer = operationContext.getServiceContainer();
        ProcessApplicationInfoImpl processApplicationInfo = this.createProcessApplicationInfo(processApplication, processArchiveDeploymentMap);
        JmxManagedProcessApplication mbean = new JmxManagedProcessApplication(processApplicationInfo, processApplication.getReference());
        mbean.setProcessesXmls(new ArrayList<ProcessesXml>(processesXmls.values()));
        mbean.setDeploymentMap(processArchiveDeploymentMap);
        serviceContainer.startService(JmxRuntimeContainerDelegate.ServiceTypes.PROCESS_APPLICATION, processApplication.getName(), mbean);
    }

    protected ProcessApplicationInfoImpl createProcessApplicationInfo(AbstractProcessApplication processApplication, Map<String, DeployedProcessArchive> processArchiveDeploymentMap) {
        ProcessApplicationInfoImpl processApplicationInfo = new ProcessApplicationInfoImpl();
        processApplicationInfo.setName(processApplication.getName());
        processApplicationInfo.setProperties(processApplication.getProperties());
        ArrayList<ProcessApplicationDeploymentInfo> deploymentInfoList = new ArrayList<ProcessApplicationDeploymentInfo>();
        if (processArchiveDeploymentMap != null) {
            for (Map.Entry<String, DeployedProcessArchive> deployment : processArchiveDeploymentMap.entrySet()) {
                DeployedProcessArchive deployedProcessArchive = deployment.getValue();
                for (String deploymentId : deployedProcessArchive.getAllDeploymentIds()) {
                    ProcessApplicationDeploymentInfoImpl deploymentInfo = new ProcessApplicationDeploymentInfoImpl();
                    deploymentInfo.setDeploymentId(deploymentId);
                    deploymentInfo.setProcessEngineName(deployedProcessArchive.getProcessEngineName());
                    deploymentInfoList.add(deploymentInfo);
                }
            }
        }
        processApplicationInfo.setDeploymentInfo(deploymentInfoList);
        return processApplicationInfo;
    }
}

