/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.pvm.runtime;

import java.util.List;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.AtomicOperationActivityInstanceStart;
import org.camunda.bpm.engine.impl.pvm.runtime.InterpretableExecution;
import org.camunda.bpm.engine.impl.pvm.runtime.ProcessInstanceStartContext;

public class AtomicOperationProcessStartInitial
extends AtomicOperationActivityInstanceStart {
    @Override
    protected ScopeImpl getScope(InterpretableExecution execution) {
        return (ScopeImpl)((Object)execution.getActivity());
    }

    @Override
    protected String getEventName() {
        return "start";
    }

    @Override
    protected void eventNotificationsCompleted(InterpretableExecution execution) {
        super.eventNotificationsCompleted(execution);
        ActivityImpl activity = (ActivityImpl)execution.getActivity();
        ProcessDefinitionImpl processDefinition = execution.getProcessDefinition();
        ProcessInstanceStartContext processInstanceStartContext = execution.getProcessInstanceStartContext();
        if (activity == processInstanceStartContext.getInitial()) {
            processInstanceStartContext.initialStarted(execution);
            execution.disposeProcessInstanceStartContext();
            execution.performOperation(ACTIVITY_EXECUTE);
        } else {
            List<ActivityImpl> initialActivityStack = processDefinition.getInitialActivityStack(processInstanceStartContext.getInitial());
            int index = initialActivityStack.indexOf(activity);
            activity = initialActivityStack.get(index + 1);
            InterpretableExecution executionToUse = null;
            executionToUse = activity.isScope() ? (InterpretableExecution)execution.getExecutions().get(0) : execution;
            executionToUse.setActivity(activity);
            executionToUse.performOperation(PROCESS_START_INITIAL);
        }
    }

    @Override
    public String getCanonicalName() {
        return "process-start-initial";
    }
}

