/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.impl.JobDefinitionQueryImpl;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.persistence.AbstractManager;
import org.camunda.bpm.engine.impl.persistence.entity.JobDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.management.JobDefinition;

public class JobDefinitionManager
extends AbstractManager {
    public JobDefinitionEntity findById(String jobDefinitionId) {
        return this.getDbSqlSession().selectById(JobDefinitionEntity.class, jobDefinitionId);
    }

    public List<JobDefinitionEntity> findByProcessDefinitionId(String processDefinitionId) {
        return this.getDbSqlSession().selectList("selectJobDefinitionsByProcessDefinitionId", processDefinitionId);
    }

    public void deleteJobDefinitionsByProcessDefinitionId(String id) {
        this.getDbSqlSession().delete("deleteJobDefinitionsByProcessDefinitionId", id);
    }

    public List<JobDefinition> findJobDefnitionByQueryCriteria(JobDefinitionQueryImpl jobDefinitionQuery, Page page) {
        return this.getDbSqlSession().selectList("selectJobDefinitionByQueryCriteria", jobDefinitionQuery, page);
    }

    public long findJobDefinitionCountByQueryCriteria(JobDefinitionQueryImpl jobDefinitionQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectJobDefinitionCountByQueryCriteria", jobDefinitionQuery);
    }

    public void updateJobDefinitionSuspensionStateById(String jobDefinitionId, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("jobDefinitionId", jobDefinitionId);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbSqlSession().update("updateJobDefinitionSuspensionStateByParameters", parameters);
    }

    public void updateJobDefinitionSuspensionStateByProcessDefinitionId(String processDefinitionId, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processDefinitionId", processDefinitionId);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbSqlSession().update("updateJobDefinitionSuspensionStateByParameters", parameters);
    }

    public void updateJobDefinitionSuspensionStateByProcessDefinitionKey(String processDefinitionKey, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processDefinitionKey", processDefinitionKey);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbSqlSession().update("updateJobDefinitionSuspensionStateByParameters", parameters);
    }
}

