/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.PersistentObject;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.Incident;

public class IncidentEntity
implements Incident,
PersistentObject {
    protected String id;
    protected Date incidentTimestamp;
    protected String incidentType;
    protected String executionId;
    protected String activityId;
    protected String processInstanceId;
    protected String processDefinitionId;
    protected String causeIncidentId;
    protected String rootCauseIncidentId;
    protected String configuration;
    protected String incidentMessage;

    public List<IncidentEntity> createRecursiveIncidents() {
        ArrayList<IncidentEntity> createdIncidents = new ArrayList<IncidentEntity>();
        this.createRecursiveIncidents(this.id, createdIncidents);
        return createdIncidents;
    }

    protected void createRecursiveIncidents(String rootCauseIncidentId, List<IncidentEntity> createdIncidents) {
        String superExecutionId;
        ExecutionEntity execution = this.getExecution();
        if (execution != null && (superExecutionId = execution.getProcessInstance().getSuperExecutionId()) != null && !superExecutionId.isEmpty()) {
            IncidentEntity newIncident = IncidentEntity.createAndInsertIncident(this.incidentType, superExecutionId, null, null);
            newIncident.setCauseIncidentId(this.id);
            newIncident.setRootCauseIncidentId(rootCauseIncidentId);
            createdIncidents.add(newIncident);
            newIncident.createRecursiveIncidents(rootCauseIncidentId, createdIncidents);
        }
    }

    public static IncidentEntity createAndInsertIncident(String incidentType, String configuration, String message) {
        String incidentId = Context.getProcessEngineConfiguration().getDbSqlSessionFactory().getIdGenerator().getNextId();
        IncidentEntity newIncident = new IncidentEntity();
        newIncident.setId(incidentId);
        newIncident.setIncidentTimestamp(ClockUtil.getCurrentTime());
        newIncident.setIncidentMessage(message);
        newIncident.setConfiguration(configuration);
        newIncident.setIncidentType(incidentType);
        newIncident.setCauseIncidentId(incidentId);
        newIncident.setRootCauseIncidentId(incidentId);
        Context.getCommandContext().getDbSqlSession().insert(newIncident);
        return newIncident;
    }

    public static IncidentEntity createAndInsertIncident(String incidentType, String executionId, String configuration, String message) {
        ExecutionEntity execution = Context.getCommandContext().getExecutionManager().findExecutionById(executionId);
        IncidentEntity newIncident = IncidentEntity.createAndInsertIncident(incidentType, configuration, message);
        newIncident.setExecution(execution);
        return newIncident;
    }

    public static IncidentEntity createAndInsertIncident(String incidentType, String processDefinitionId, String activityId, String configuration, String message) {
        IncidentEntity newIncident = IncidentEntity.createAndInsertIncident(incidentType, configuration, message);
        newIncident.setActivityId(activityId);
        newIncident.setProcessDefinitionId(processDefinitionId);
        return newIncident;
    }

    public void delete() {
        ExecutionEntity execution = this.getExecution();
        if (execution != null) {
            IncidentEntity parentIncident;
            ExecutionEntity superExecution = null;
            superExecution = execution.getId().equals(execution.getProcessInstanceId()) ? execution.getSuperExecution() : execution.getProcessInstance().getSuperExecution();
            if (superExecution != null && (parentIncident = superExecution.getIncidentByCauseIncidentId(this.getId())) != null) {
                parentIncident.delete();
            }
            execution.removeIncident(this);
        }
        Context.getCommandContext().getDbSqlSession().delete(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public Date getIncidentTimestamp() {
        return this.incidentTimestamp;
    }

    public void setIncidentTimestamp(Date incidentTimestamp) {
        this.incidentTimestamp = incidentTimestamp;
    }

    @Override
    public String getIncidentType() {
        return this.incidentType;
    }

    public void setIncidentType(String incidentType) {
        this.incidentType = incidentType;
    }

    @Override
    public String getIncidentMessage() {
        return this.incidentMessage;
    }

    public void setIncidentMessage(String incidentMessage) {
        this.incidentMessage = incidentMessage;
    }

    @Override
    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    @Override
    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public String getCauseIncidentId() {
        return this.causeIncidentId;
    }

    public void setCauseIncidentId(String causeIncidentId) {
        this.causeIncidentId = causeIncidentId;
    }

    @Override
    public String getRootCauseIncidentId() {
        return this.rootCauseIncidentId;
    }

    public void setRootCauseIncidentId(String rootCauseIncidentId) {
        this.rootCauseIncidentId = rootCauseIncidentId;
    }

    @Override
    public String getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    public void setExecution(ExecutionEntity execution) {
        this.executionId = execution.getId();
        this.activityId = execution.getActivityId();
        this.processInstanceId = execution.getProcessInstanceId();
        this.processDefinitionId = execution.getProcessDefinitionId();
        execution.addIncident(this);
    }

    public ExecutionEntity getExecution() {
        if (this.executionId != null) {
            return Context.getCommandContext().getExecutionManager().findExecutionById(this.executionId);
        }
        return null;
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        persistentState.put("incidentTimestamp", this.incidentTimestamp);
        persistentState.put("incidentType", this.incidentType);
        persistentState.put("incidentMessage", this.incidentMessage);
        persistentState.put("executionId", this.executionId);
        persistentState.put("activityId", this.activityId);
        persistentState.put("processInstanceId", this.processInstanceId);
        persistentState.put("processDefinitionId", this.processDefinitionId);
        persistentState.put("causeId", this.causeIncidentId);
        persistentState.put("rootCauseId", this.rootCauseIncidentId);
        persistentState.put("configuration", this.configuration);
        return persistentState;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.id + ", incidentTimestamp=" + this.incidentTimestamp + ", incidentType=" + this.incidentType + ", executionId=" + this.executionId + ", activityId=" + this.activityId + ", processInstanceId=" + this.processInstanceId + ", processDefinitionId=" + this.processDefinitionId + ", causeIncidentId=" + this.causeIncidentId + ", rootCauseIncidentId=" + this.rootCauseIncidentId + ", configuration=" + this.configuration + ", incidentMessage=" + this.incidentMessage + "]";
    }
}

