/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.mail;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.mail.CreateMailScanCmd;
import org.camunda.bpm.engine.impl.mail.MailScanCmd;
import org.camunda.bpm.engine.impl.mail.MailScanner;

public class MailScanSchedulerThread
extends Thread {
    private static Logger log = Logger.getLogger(MailScanSchedulerThread.class.getName());
    protected boolean isActive = false;
    protected int idleWaitInMillis = 10000;
    protected MailScanner mailScanner;
    protected CommandExecutor commandExecutor;
    protected Map<String, MailScanCmd> allMailScansCmds = Collections.synchronizedMap(new HashMap());
    protected List<MailScanCmd> nextMailScanCmds = Collections.synchronizedList(new ArrayList());

    public MailScanSchedulerThread(MailScanner mailScanner) {
        this.mailScanner = mailScanner;
        this.commandExecutor = mailScanner.getCommandExecutor();
    }

    public synchronized void addUser(String userId, String userPassword) {
        MailScanCmd mailScanCmd = this.commandExecutor.execute(new CreateMailScanCmd(userId, userPassword));
        if (mailScanCmd != null) {
            this.allMailScansCmds.put(userId, mailScanCmd);
        }
        this.nextMailScanCmds.add(0, mailScanCmd);
    }

    public synchronized void removeUser(String userId) {
        this.allMailScansCmds.remove(userId);
    }

    @Override
    public void run() {
        this.isActive = true;
        log.fine(this.getClass().getName() + " is started");
        while (this.isActive) {
            MailScanCmd mailScanCmd = this.getNextMailScanCmd();
            if (mailScanCmd != null) {
                try {
                    this.commandExecutor.execute(mailScanCmd);
                }
                catch (Exception e) {
                    String userId = mailScanCmd.getUserId();
                    log.log(Level.SEVERE, "couldn't check todo mail for " + userId + ": " + e.getMessage(), e);
                }
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
        }
        log.fine(this.getClass().getName() + " is stopping");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MailScanCmd getNextMailScanCmd() {
        MailScanCmd nextMailScanCmd = null;
        while (nextMailScanCmd == null) {
            while (this.allMailScansCmds.isEmpty() && this.nextMailScanCmds.isEmpty()) {
                try {
                    log.fine("sleeping for " + this.idleWaitInMillis + " millis");
                    Thread.sleep(this.idleWaitInMillis);
                }
                catch (InterruptedException e) {
                    log.fine("sleep got interrupted");
                    return null;
                }
            }
            if (this.nextMailScanCmds.isEmpty()) {
                log.fine("scheduling mailscans for users " + this.allMailScansCmds.keySet());
                this.nextMailScanCmds.addAll(this.allMailScansCmds.values());
            }
            MailScanSchedulerThread mailScanSchedulerThread = this;
            synchronized (mailScanSchedulerThread) {
                if (!this.nextMailScanCmds.isEmpty()) {
                    nextMailScanCmd = this.nextMailScanCmds.remove(0);
                }
            }
        }
        return nextMailScanCmd;
    }

    public void shutdown() {
        if (this.isActive) {
            log.info(this.getName() + " is shutting down");
            this.isActive = false;
            this.interrupt();
            try {
                this.join();
            }
            catch (InterruptedException e) {
                log.log(Level.WARNING, "Interruption while shutting down " + this.getClass().getName(), e);
            }
        }
    }
}

