/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.jobexecutor;

import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.jobexecutor.ExecuteJobsRunnable;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;

public class ThreadPoolJobExecutor
extends JobExecutor {
    protected ThreadPoolExecutor threadPoolExecutor;

    @Override
    protected void startExecutingJobs() {
        this.startJobAcquisitionThread();
    }

    @Override
    protected void stopExecutingJobs() {
        this.stopJobAcquisitionThread();
    }

    @Override
    public void executeJobs(List<String> jobIds, ProcessEngineImpl processEngine) {
        try {
            this.threadPoolExecutor.execute(new ExecuteJobsRunnable(jobIds, processEngine));
        }
        catch (RejectedExecutionException e) {
            this.rejectedJobsHandler.jobsRejected(jobIds, processEngine);
        }
    }

    public ThreadPoolExecutor getThreadPoolExecutor() {
        return this.threadPoolExecutor;
    }

    public void setThreadPoolExecutor(ThreadPoolExecutor threadPoolExecutor) {
        this.threadPoolExecutor = threadPoolExecutor;
    }
}

