/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.history.handler;

import java.util.List;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.DbSqlSession;
import org.camunda.bpm.engine.impl.history.event.HistoricScopeInstanceEvent;
import org.camunda.bpm.engine.impl.history.event.HistoricVariableUpdateEventEntity;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.impl.history.handler.HistoryEventHandler;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricVariableInstanceEntity;

public class DbHistoryEventHandler
implements HistoryEventHandler {
    @Override
    public void handleEvent(HistoryEvent historyEvent) {
        if (historyEvent instanceof HistoricVariableUpdateEventEntity) {
            this.insertHistoricVariableUpdateEntity((HistoricVariableUpdateEventEntity)historyEvent);
        } else {
            this.insertOrUpdate(historyEvent);
        }
    }

    @Override
    public void handleEvents(List<HistoryEvent> historyEvents) {
        for (HistoryEvent historyEvent : historyEvents) {
            this.handleEvent(historyEvent);
        }
    }

    protected void insertOrUpdate(HistoryEvent historyEvent) {
        DbSqlSession dbSqlSession = this.getDbSqlSession();
        String eventType = historyEvent.getEventType();
        if (eventType == null || this.isInitialEvent(eventType)) {
            dbSqlSession.insert(historyEvent);
        } else if (dbSqlSession.findInCache(historyEvent.getClass(), historyEvent.getId()) == null) {
            HistoricScopeInstanceEvent existingEvent;
            if (historyEvent instanceof HistoricScopeInstanceEvent && (existingEvent = (HistoricScopeInstanceEvent)dbSqlSession.selectById(historyEvent.getClass(), historyEvent.getId())) != null) {
                HistoricScopeInstanceEvent historicScopeInstanceEvent = (HistoricScopeInstanceEvent)historyEvent;
                historicScopeInstanceEvent.setStartTime(existingEvent.getStartTime());
            }
            dbSqlSession.update(historyEvent);
        }
    }

    protected void insertHistoricVariableUpdateEntity(HistoricVariableUpdateEventEntity historyEvent) {
        HistoricVariableInstanceEntity historicVariableInstanceEntity;
        DbSqlSession dbSqlSession = this.getDbSqlSession();
        int historyLevel = Context.getProcessEngineConfiguration().getHistoryLevel();
        if (historyLevel == 3) {
            byte[] byteValue = historyEvent.getByteValue();
            if (byteValue != null) {
                ByteArrayEntity byteArrayEntity = new ByteArrayEntity(historyEvent.getVariableName(), byteValue);
                Context.getCommandContext().getDbSqlSession().insert(byteArrayEntity);
                historyEvent.setByteArrayId(byteArrayEntity.getId());
            }
            dbSqlSession.insert(historyEvent);
        }
        if ("create".equals(historyEvent.getEventType())) {
            HistoricVariableInstanceEntity persistentObject = new HistoricVariableInstanceEntity(historyEvent);
            dbSqlSession.insert(persistentObject);
        } else if ("update".equals(historyEvent.getEventType())) {
            historicVariableInstanceEntity = dbSqlSession.selectById(HistoricVariableInstanceEntity.class, historyEvent.getVariableInstanceId());
            if (historicVariableInstanceEntity != null) {
                historicVariableInstanceEntity.updateFromEvent(historyEvent);
            } else {
                HistoricVariableInstanceEntity persistentObject = new HistoricVariableInstanceEntity(historyEvent);
                dbSqlSession.insert(persistentObject);
            }
        } else if ("delete".equals(historyEvent.getEventType()) && (historicVariableInstanceEntity = dbSqlSession.selectById(HistoricVariableInstanceEntity.class, historyEvent.getVariableInstanceId())) != null) {
            historicVariableInstanceEntity.delete();
        }
    }

    protected boolean isInitialEvent(String eventType) {
        return "start".equals(eventType) || "create".equals(eventType) || "form-property-update".equals(eventType);
    }

    protected DbSqlSession getDbSqlSession() {
        return Context.getCommandContext().getDbSqlSession();
    }
}

