/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.event;

import java.util.Map;
import java.util.logging.Logger;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.bpmn.behavior.BoundaryEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.EventSubProcessStartEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.IntermediateCatchEventActivityBehavior;
import org.camunda.bpm.engine.impl.event.EventHandler;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;

public abstract class AbstractEventHandler
implements EventHandler {
    private static Logger log = Logger.getLogger(AbstractEventHandler.class.getName());

    @Override
    public void handleEvent(EventSubscriptionEntity eventSubscription, Object payload, CommandContext commandContext) {
        ActivityBehavior activityBehavior;
        ExecutionEntity execution = eventSubscription.getExecution();
        ActivityImpl activity = eventSubscription.getActivity();
        if (activity == null) {
            throw new ProcessEngineException("Error while sending signal for event subscription '" + eventSubscription.getId() + "': " + "no activity associated with event subscription");
        }
        if (payload instanceof Map) {
            Map processVariables = (Map)payload;
            execution.setVariables(processVariables);
        }
        if ((activityBehavior = activity.getActivityBehavior()) instanceof BoundaryEventActivityBehavior || activityBehavior instanceof EventSubProcessStartEventActivityBehavior) {
            try {
                execution.executeActivity(activity);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ProcessEngineException("exception while sending signal for event subscription '" + eventSubscription + "':" + e.getMessage(), e);
            }
        } else {
            IntermediateCatchEventActivityBehavior catchBehavior;
            if (activityBehavior instanceof IntermediateCatchEventActivityBehavior && (catchBehavior = (IntermediateCatchEventActivityBehavior)activityBehavior).isAfterEventBasedGateway()) {
                execution.executeActivity(activity);
                return;
            }
            if (!activity.equals(execution.getActivity())) {
                execution.setActivity(activity);
            }
            execution.signal("signal", null);
        }
    }
}

