/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;

public class SignalCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String executionId;
    protected String signalName;
    protected Object signalData;
    protected final Map<String, Object> processVariables;

    public SignalCmd(String executionId, String signalName, Object signalData, Map<String, Object> processVariables) {
        this.executionId = executionId;
        this.signalName = signalName;
        this.signalData = signalData;
        this.processVariables = processVariables;
    }

    protected Object execute(CommandContext commandContext, ExecutionEntity execution) {
        if (this.processVariables != null) {
            execution.setVariables(this.processVariables);
        }
        execution.signal(this.signalName, this.signalData);
        return null;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        if (this.executionId == null) {
            throw new ProcessEngineException("executionId is null");
        }
        ExecutionEntity execution = commandContext.getExecutionManager().findExecutionById(this.executionId);
        if (execution == null) {
            throw new ProcessEngineException("execution " + this.executionId + " doesn't exist");
        }
        if (this.processVariables != null) {
            execution.setVariables(this.processVariables);
        }
        execution.signal(this.signalName, this.signalData);
        return null;
    }
}

