/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;

public class SetTaskVariablesCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Map<String, ? extends Object> variables;
    protected boolean isLocal;
    protected String taskId;

    public SetTaskVariablesCmd(String taskId, Map<String, ? extends Object> variables, boolean isLocal) {
        this.taskId = taskId;
        this.variables = variables;
        this.isLocal = isLocal;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        if (this.taskId == null) {
            throw new ProcessEngineException("taskId is null");
        }
        TaskEntity task = commandContext.getTaskManager().findTaskById(this.taskId);
        if (task == null) {
            throw new ProcessEngineException("Cannot find task with id " + this.taskId);
        }
        if (this.isLocal) {
            task.setVariablesLocal(this.variables);
        } else {
            task.setVariables(this.variables);
        }
        return null;
    }
}

