/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.TaskAlreadyClaimedException;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;

public class ClaimTaskCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected String userId;

    public ClaimTaskCmd(String taskId, String userId) {
        this.taskId = taskId;
        this.userId = userId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.taskId == null) {
            throw new ProcessEngineException("taskId is null");
        }
        TaskEntity task = commandContext.getTaskManager().findTaskById(this.taskId);
        if (task == null) {
            throw new ProcessEngineException("Cannot find task with id " + this.taskId);
        }
        if (this.userId != null) {
            if (task.getAssignee() != null) {
                if (!task.getAssignee().equals(this.userId)) {
                    throw new TaskAlreadyClaimedException(task.getId(), task.getAssignee());
                }
            } else {
                task.setAssignee(this.userId);
            }
        } else {
            task.setAssignee(null);
        }
        task.createHistoricTaskDetails("Claim");
        return null;
    }
}

