/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cfg.standalone;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.camunda.bpm.engine.impl.cfg.TransactionContext;
import org.camunda.bpm.engine.impl.cfg.TransactionListener;
import org.camunda.bpm.engine.impl.cfg.TransactionState;
import org.camunda.bpm.engine.impl.db.DbSqlSession;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;

public class StandaloneMybatisTransactionContext
implements TransactionContext {
    private static Logger log = Logger.getLogger(StandaloneMybatisTransactionContext.class.getName());
    protected CommandContext commandContext;
    protected Map<TransactionState, List<TransactionListener>> stateTransactionListeners = null;

    public StandaloneMybatisTransactionContext(CommandContext commandContext) {
        this.commandContext = commandContext;
    }

    @Override
    public void addTransactionListener(TransactionState transactionState, TransactionListener transactionListener) {
        List<TransactionListener> transactionListeners;
        if (this.stateTransactionListeners == null) {
            this.stateTransactionListeners = new HashMap<TransactionState, List<TransactionListener>>();
        }
        if ((transactionListeners = this.stateTransactionListeners.get((Object)transactionState)) == null) {
            transactionListeners = new ArrayList<TransactionListener>();
            this.stateTransactionListeners.put(transactionState, transactionListeners);
        }
        transactionListeners.add(transactionListener);
    }

    @Override
    public void commit() {
        log.fine("firing event committing...");
        this.fireTransactionEvent(TransactionState.COMMITTING);
        log.fine("committing the ibatis sql session...");
        this.getDbSqlSession().commit();
        log.fine("firing event committed...");
        this.fireTransactionEvent(TransactionState.COMMITTED);
    }

    protected void fireTransactionEvent(TransactionState transactionState) {
        if (this.stateTransactionListeners == null) {
            return;
        }
        List<TransactionListener> transactionListeners = this.stateTransactionListeners.get((Object)transactionState);
        if (transactionListeners == null) {
            return;
        }
        for (TransactionListener transactionListener : transactionListeners) {
            transactionListener.execute(this.commandContext);
        }
    }

    private DbSqlSession getDbSqlSession() {
        return this.commandContext.getSession(DbSqlSession.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() {
        try {
            try {
                log.fine("firing event rolling back...");
                this.fireTransactionEvent(TransactionState.ROLLINGBACK);
                log.fine("rolling back ibatis sql session...");
                this.getDbSqlSession().rollback();
            }
            catch (Throwable exception) {
                try {
                    log.info("Exception during transaction: " + exception.getMessage());
                    this.commandContext.exception(exception);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    log.fine("rolling back ibatis sql session...");
                    this.getDbSqlSession().rollback();
                }
            }
        }
        catch (Throwable exception) {
            log.info("Exception during transaction: " + exception.getMessage());
            this.commandContext.exception(exception);
        }
        finally {
            log.fine("firing event rolled back...");
            this.fireTransactionEvent(TransactionState.ROLLED_BACK);
        }
    }
}

