/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.sql.Connection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.application.ProcessApplicationRegistration;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.impl.ActivityStatisticsQueryImpl;
import org.camunda.bpm.engine.impl.DeploymentStatisticsQueryImpl;
import org.camunda.bpm.engine.impl.JobDefinitionQueryImpl;
import org.camunda.bpm.engine.impl.JobQueryImpl;
import org.camunda.bpm.engine.impl.ProcessDefinitionStatisticsQueryImpl;
import org.camunda.bpm.engine.impl.ServiceImpl;
import org.camunda.bpm.engine.impl.TablePageQueryImpl;
import org.camunda.bpm.engine.impl.cmd.ActivateJobCmd;
import org.camunda.bpm.engine.impl.cmd.ActivateJobDefinitionCmd;
import org.camunda.bpm.engine.impl.cmd.DeleteJobCmd;
import org.camunda.bpm.engine.impl.cmd.ExecuteJobsCmd;
import org.camunda.bpm.engine.impl.cmd.GetJobExceptionStacktraceCmd;
import org.camunda.bpm.engine.impl.cmd.GetProcessApplicationForDeploymentCmd;
import org.camunda.bpm.engine.impl.cmd.GetPropertiesCmd;
import org.camunda.bpm.engine.impl.cmd.GetTableCountCmd;
import org.camunda.bpm.engine.impl.cmd.GetTableMetaDataCmd;
import org.camunda.bpm.engine.impl.cmd.GetTableNameCmd;
import org.camunda.bpm.engine.impl.cmd.RegisterDeploymentCmd;
import org.camunda.bpm.engine.impl.cmd.RegisterProcessApplicationCmd;
import org.camunda.bpm.engine.impl.cmd.SetJobDuedateCmd;
import org.camunda.bpm.engine.impl.cmd.SetJobRetriesCmd;
import org.camunda.bpm.engine.impl.cmd.SetPropertyCmd;
import org.camunda.bpm.engine.impl.cmd.SuspendJobCmd;
import org.camunda.bpm.engine.impl.cmd.SuspendJobDefinitionCmd;
import org.camunda.bpm.engine.impl.cmd.UnregisterDeploymentCmd;
import org.camunda.bpm.engine.impl.cmd.UnregisterProcessApplicationCmd;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.DbSqlSession;
import org.camunda.bpm.engine.impl.db.DbSqlSessionFactory;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.management.ActivityStatisticsQuery;
import org.camunda.bpm.engine.management.DeploymentStatisticsQuery;
import org.camunda.bpm.engine.management.JobDefinitionQuery;
import org.camunda.bpm.engine.management.ProcessDefinitionStatisticsQuery;
import org.camunda.bpm.engine.management.TableMetaData;
import org.camunda.bpm.engine.management.TablePageQuery;
import org.camunda.bpm.engine.runtime.JobQuery;

public class ManagementServiceImpl
extends ServiceImpl
implements ManagementService {
    @Override
    public ProcessApplicationRegistration registerProcessApplication(String deploymentId, ProcessApplicationReference reference) {
        return this.commandExecutor.execute(new RegisterProcessApplicationCmd(deploymentId, reference));
    }

    @Override
    public void unregisterProcessApplication(String deploymentId, boolean removeProcessesFromCache) {
        this.commandExecutor.execute(new UnregisterProcessApplicationCmd(deploymentId, removeProcessesFromCache));
    }

    @Override
    public void unregisterProcessApplication(Set<String> deploymentIds, boolean removeProcessesFromCache) {
        this.commandExecutor.execute(new UnregisterProcessApplicationCmd(deploymentIds, removeProcessesFromCache));
    }

    @Override
    public String getProcessApplicationForDeployment(String deploymentId) {
        return this.commandExecutor.execute(new GetProcessApplicationForDeploymentCmd(deploymentId));
    }

    @Override
    public Map<String, Long> getTableCount() {
        return this.commandExecutor.execute(new GetTableCountCmd());
    }

    @Override
    public String getTableName(Class<?> activitiEntityClass) {
        return this.commandExecutor.execute(new GetTableNameCmd(activitiEntityClass));
    }

    @Override
    public TableMetaData getTableMetaData(String tableName) {
        return this.commandExecutor.execute(new GetTableMetaDataCmd(tableName));
    }

    @Override
    public void executeJob(String jobId) {
        this.commandExecutor.execute(new ExecuteJobsCmd(jobId));
    }

    @Override
    public void deleteJob(String jobId) {
        this.commandExecutor.execute(new DeleteJobCmd(jobId));
    }

    @Override
    public void setJobRetries(String jobId, int retries) {
        this.commandExecutor.execute(new SetJobRetriesCmd(jobId, retries));
    }

    @Override
    public void setJobDuedate(String jobId, Date newDuedate) {
        this.commandExecutor.execute(new SetJobDuedateCmd(jobId, newDuedate));
    }

    @Override
    public TablePageQuery createTablePageQuery() {
        return new TablePageQueryImpl(this.commandExecutor);
    }

    @Override
    public JobQuery createJobQuery() {
        return new JobQueryImpl(this.commandExecutor);
    }

    @Override
    public JobDefinitionQuery createJobDefinitionQuery() {
        return new JobDefinitionQueryImpl(this.commandExecutor);
    }

    @Override
    public String getJobExceptionStacktrace(String jobId) {
        return this.commandExecutor.execute(new GetJobExceptionStacktraceCmd(jobId));
    }

    @Override
    public Map<String, String> getProperties() {
        return this.commandExecutor.execute(new GetPropertiesCmd());
    }

    @Override
    public void setProperty(String name, String value) {
        this.commandExecutor.execute(new SetPropertyCmd(name, value));
    }

    @Override
    public String databaseSchemaUpgrade(final Connection connection, final String catalog, final String schema) {
        return this.commandExecutor.execute(new Command<String>(){

            @Override
            public String execute(CommandContext commandContext) {
                DbSqlSessionFactory dbSqlSessionFactory = (DbSqlSessionFactory)commandContext.getSessionFactories().get(DbSqlSession.class);
                DbSqlSession dbSqlSession = new DbSqlSession(dbSqlSessionFactory, connection, catalog, schema);
                commandContext.getSessions().put(DbSqlSession.class, dbSqlSession);
                return dbSqlSession.dbSchemaUpdate();
            }
        });
    }

    @Override
    public ProcessDefinitionStatisticsQuery createProcessDefinitionStatisticsQuery() {
        return new ProcessDefinitionStatisticsQueryImpl(this.commandExecutor);
    }

    @Override
    public ActivityStatisticsQuery createActivityStatisticsQuery(String processDefinitionId) {
        return new ActivityStatisticsQueryImpl(processDefinitionId, this.commandExecutor);
    }

    @Override
    public DeploymentStatisticsQuery createDeploymentStatisticsQuery() {
        return new DeploymentStatisticsQueryImpl(this.commandExecutor);
    }

    @Override
    public Set<String> getRegisteredDeployments() {
        return this.commandExecutor.execute(new Command<Set<String>>(){

            @Override
            public Set<String> execute(CommandContext commandContext) {
                Set<String> registeredDeployments = Context.getProcessEngineConfiguration().getRegisteredDeployments();
                return new HashSet<String>(registeredDeployments);
            }
        });
    }

    @Override
    public void registerDeploymentForJobExecutor(String deploymentId) {
        this.commandExecutor.execute(new RegisterDeploymentCmd(deploymentId));
    }

    @Override
    public void unregisterDeploymentForJobExecutor(String deploymentId) {
        this.commandExecutor.execute(new UnregisterDeploymentCmd(deploymentId));
    }

    @Override
    public void activateJobDefinitionById(String jobDefinitionId) {
        this.activateJobDefinitionById(jobDefinitionId, false);
    }

    @Override
    public void activateJobDefinitionById(String jobDefinitionId, boolean activateJobs) {
        this.activateJobDefinitionById(jobDefinitionId, activateJobs, null);
    }

    @Override
    public void activateJobDefinitionById(String jobDefinitionId, boolean activateJobs, Date activationDate) {
        this.commandExecutor.execute(new ActivateJobDefinitionCmd(jobDefinitionId, null, null, activateJobs, activationDate));
    }

    @Override
    public void suspendJobDefinitionById(String jobDefinitionId) {
        this.suspendJobDefinitionById(jobDefinitionId, false);
    }

    @Override
    public void suspendJobDefinitionById(String jobDefinitionId, boolean suspendJobs) {
        this.suspendJobDefinitionById(jobDefinitionId, suspendJobs, null);
    }

    @Override
    public void suspendJobDefinitionById(String jobDefinitionId, boolean suspendJobs, Date suspensionDate) {
        this.commandExecutor.execute(new SuspendJobDefinitionCmd(jobDefinitionId, null, null, suspendJobs, suspensionDate));
    }

    @Override
    public void activateJobDefinitionByProcessDefinitionId(String processDefinitionId) {
        this.activateJobDefinitionByProcessDefinitionId(processDefinitionId, false);
    }

    @Override
    public void activateJobDefinitionByProcessDefinitionId(String processDefinitionId, boolean activateJobs) {
        this.activateJobDefinitionByProcessDefinitionId(processDefinitionId, activateJobs, null);
    }

    @Override
    public void activateJobDefinitionByProcessDefinitionId(String processDefinitionId, boolean activateJobs, Date activationDate) {
        this.commandExecutor.execute(new ActivateJobDefinitionCmd(null, processDefinitionId, null, activateJobs, activationDate));
    }

    @Override
    public void suspendJobDefinitionByProcessDefinitionId(String processDefinitionId) {
        this.suspendJobDefinitionByProcessDefinitionId(processDefinitionId, false);
    }

    @Override
    public void suspendJobDefinitionByProcessDefinitionId(String processDefinitionId, boolean suspendJobs) {
        this.suspendJobDefinitionByProcessDefinitionId(processDefinitionId, suspendJobs, null);
    }

    @Override
    public void suspendJobDefinitionByProcessDefinitionId(String processDefinitionId, boolean suspendJobs, Date suspensionDate) {
        this.commandExecutor.execute(new SuspendJobDefinitionCmd(null, processDefinitionId, null, suspendJobs, suspensionDate));
    }

    @Override
    public void activateJobDefinitionByProcessDefinitionKey(String processDefinitionKey) {
        this.activateJobDefinitionByProcessDefinitionKey(processDefinitionKey, false);
    }

    @Override
    public void activateJobDefinitionByProcessDefinitionKey(String processDefinitionKey, boolean activateJobs) {
        this.activateJobDefinitionByProcessDefinitionKey(processDefinitionKey, activateJobs, null);
    }

    @Override
    public void activateJobDefinitionByProcessDefinitionKey(String processDefinitionKey, boolean activateJobs, Date activationDate) {
        this.commandExecutor.execute(new ActivateJobDefinitionCmd(null, null, processDefinitionKey, activateJobs, activationDate));
    }

    @Override
    public void suspendJobDefinitionByProcessDefinitionKey(String processDefinitionKey) {
        this.suspendJobDefinitionByProcessDefinitionKey(processDefinitionKey, false);
    }

    @Override
    public void suspendJobDefinitionByProcessDefinitionKey(String processDefinitionKey, boolean suspendJobs) {
        this.suspendJobDefinitionByProcessDefinitionKey(processDefinitionKey, suspendJobs, null);
    }

    @Override
    public void suspendJobDefinitionByProcessDefinitionKey(String processDefinitionKey, boolean suspendJobs, Date suspensionDate) {
        this.commandExecutor.execute(new SuspendJobDefinitionCmd(null, null, processDefinitionKey, suspendJobs, suspensionDate));
    }

    @Override
    public void activateJobById(String jobId) {
        this.commandExecutor.execute(new ActivateJobCmd(jobId, null, null, null, null));
    }

    @Override
    public void activateJobByProcessInstanceId(String processInstanceId) {
        this.commandExecutor.execute(new ActivateJobCmd(null, null, processInstanceId, null, null));
    }

    @Override
    public void activateJobByJobDefinitionId(String jobDefinitionId) {
        this.commandExecutor.execute(new ActivateJobCmd(null, jobDefinitionId, null, null, null));
    }

    @Override
    public void activateJobByProcessDefinitionId(String processDefinitionId) {
        this.commandExecutor.execute(new ActivateJobCmd(null, null, null, processDefinitionId, null));
    }

    @Override
    public void activateJobByProcessDefinitionKey(String processDefinitionKey) {
        this.commandExecutor.execute(new ActivateJobCmd(null, null, null, null, processDefinitionKey));
    }

    @Override
    public void suspendJobById(String jobId) {
        this.commandExecutor.execute(new SuspendJobCmd(jobId, null, null, null, null));
    }

    @Override
    public void suspendJobByJobDefinitionId(String jobDefinitionId) {
        this.commandExecutor.execute(new SuspendJobCmd(null, jobDefinitionId, null, null, null));
    }

    @Override
    public void suspendJobByProcessInstanceId(String processInstanceId) {
        this.commandExecutor.execute(new SuspendJobCmd(null, null, processInstanceId, null, null));
    }

    @Override
    public void suspendJobByProcessDefinitionId(String processDefinitionId) {
        this.commandExecutor.execute(new SuspendJobCmd(null, null, null, processDefinitionId, null));
    }

    @Override
    public void suspendJobByProcessDefinitionKey(String processDefinitionKey) {
        this.commandExecutor.execute(new SuspendJobCmd(null, null, null, null, processDefinitionKey));
    }
}

