/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.JobQueryProperty;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;

public class JobQueryImpl
extends AbstractQuery<JobQuery, Job>
implements JobQuery,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String jobDefinitionId;
    protected String processInstanceId;
    protected String executionId;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected boolean retriesLeft;
    protected boolean executable;
    protected boolean onlyTimers;
    protected boolean onlyMessages;
    protected Date duedateHigherThan;
    protected Date duedateLowerThan;
    protected Date duedateHigherThanOrEqual;
    protected Date duedateLowerThanOrEqual;
    protected boolean withException;
    protected String exceptionMessage;
    protected boolean noRetriesLeft;
    protected SuspensionState suspensionState;

    public JobQueryImpl() {
    }

    public JobQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public JobQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public JobQuery jobId(String jobId) {
        if (jobId == null) {
            throw new ProcessEngineException("Provided job id is null");
        }
        this.id = jobId;
        return this;
    }

    @Override
    public JobQuery jobDefinitionId(String jobDefinitionId) {
        if (jobDefinitionId == null) {
            throw new ProcessEngineException("Provided job definition id is null");
        }
        this.jobDefinitionId = jobDefinitionId;
        return this;
    }

    @Override
    public JobQueryImpl processInstanceId(String processInstanceId) {
        if (processInstanceId == null) {
            throw new ProcessEngineException("Provided process instance id is null");
        }
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Override
    public JobQueryImpl executionId(String executionId) {
        if (executionId == null) {
            throw new ProcessEngineException("Provided execution id is null");
        }
        this.executionId = executionId;
        return this;
    }

    @Override
    public JobQuery processDefinitionId(String processDefinitionId) {
        if (processDefinitionId == null) {
            throw new ProcessEngineException("Provided process definition id is null");
        }
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Override
    public JobQuery processDefinitionKey(String processDefinitionKey) {
        if (processDefinitionKey == null) {
            throw new ProcessEngineException("Provided process instance key is null");
        }
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Override
    public JobQuery withRetriesLeft() {
        this.retriesLeft = true;
        return this;
    }

    @Override
    public JobQuery executable() {
        this.executable = true;
        return this;
    }

    @Override
    public JobQuery timers() {
        if (this.onlyMessages) {
            throw new ProcessEngineException("Cannot combine onlyTimers() with onlyMessages() in the same query");
        }
        this.onlyTimers = true;
        return this;
    }

    @Override
    public JobQuery messages() {
        if (this.onlyTimers) {
            throw new ProcessEngineException("Cannot combine onlyTimers() with onlyMessages() in the same query");
        }
        this.onlyMessages = true;
        return this;
    }

    @Override
    public JobQuery duedateHigherThan(Date date) {
        if (date == null) {
            throw new ProcessEngineException("Provided date is null");
        }
        this.duedateHigherThan = date;
        return this;
    }

    @Override
    public JobQuery duedateLowerThan(Date date) {
        if (date == null) {
            throw new ProcessEngineException("Provided date is null");
        }
        this.duedateLowerThan = date;
        return this;
    }

    @Override
    public JobQuery duedateHigherThen(Date date) {
        return this.duedateHigherThan(date);
    }

    @Override
    public JobQuery duedateHigherThenOrEquals(Date date) {
        if (date == null) {
            throw new ProcessEngineException("Provided date is null");
        }
        this.duedateHigherThanOrEqual = date;
        return this;
    }

    @Override
    public JobQuery duedateLowerThen(Date date) {
        return this.duedateLowerThan(date);
    }

    @Override
    public JobQuery duedateLowerThenOrEquals(Date date) {
        if (date == null) {
            throw new ProcessEngineException("Provided date is null");
        }
        this.duedateLowerThanOrEqual = date;
        return this;
    }

    @Override
    public JobQuery withException() {
        this.withException = true;
        return this;
    }

    @Override
    public JobQuery exceptionMessage(String exceptionMessage) {
        if (exceptionMessage == null) {
            throw new ProcessEngineException("Provided exception message is null");
        }
        this.exceptionMessage = exceptionMessage;
        return this;
    }

    @Override
    public JobQuery noRetriesLeft() {
        this.noRetriesLeft = true;
        return this;
    }

    @Override
    public JobQuery active() {
        this.suspensionState = SuspensionState.ACTIVE;
        return this;
    }

    @Override
    public JobQuery suspended() {
        this.suspensionState = SuspensionState.SUSPENDED;
        return this;
    }

    @Override
    public JobQuery orderByJobDuedate() {
        return (JobQuery)this.orderBy(JobQueryProperty.DUEDATE);
    }

    @Override
    public JobQuery orderByExecutionId() {
        return (JobQuery)this.orderBy(JobQueryProperty.EXECUTION_ID);
    }

    @Override
    public JobQuery orderByJobId() {
        return (JobQuery)this.orderBy(JobQueryProperty.JOB_ID);
    }

    @Override
    public JobQuery orderByProcessInstanceId() {
        return (JobQuery)this.orderBy(JobQueryProperty.PROCESS_INSTANCE_ID);
    }

    @Override
    public JobQuery orderByProcessDefinitionId() {
        return (JobQuery)this.orderBy(JobQueryProperty.PROCESS_DEFINITION_ID);
    }

    @Override
    public JobQuery orderByProcessDefinitionKey() {
        return (JobQuery)this.orderBy(JobQueryProperty.PROCESS_DEFINITION_KEY);
    }

    @Override
    public JobQuery orderByJobRetries() {
        return (JobQuery)this.orderBy(JobQueryProperty.RETRIES);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getJobManager().findJobCountByQueryCriteria(this);
    }

    @Override
    public List<Job> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        return commandContext.getJobManager().findJobsByQueryCriteria(this, page);
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public boolean getRetriesLeft() {
        return this.retriesLeft;
    }

    public boolean getExecutable() {
        return this.executable;
    }

    public Date getNow() {
        return ClockUtil.getCurrentTime();
    }

    public boolean isWithException() {
        return this.withException;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }
}

