/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.util.List;
import org.camunda.bpm.engine.history.HistoricDetail;
import org.camunda.bpm.engine.history.HistoricDetailQuery;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.HistoricDetailQueryProperty;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricDetailVariableInstanceUpdateEntity;

public class HistoricDetailQueryImpl
extends AbstractQuery<HistoricDetailQuery, HistoricDetail>
implements HistoricDetailQuery {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected String processInstanceId;
    protected String executionId;
    protected String activityId;
    protected String activityInstanceId;
    protected String type;
    protected String variableInstanceId;
    protected boolean excludeTaskRelated = false;

    public HistoricDetailQueryImpl() {
    }

    public HistoricDetailQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public HistoricDetailQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public HistoricDetailQuery variableInstanceId(String variableInstanceId) {
        this.assertParamNotNull("variableInstanceId", variableInstanceId);
        this.variableInstanceId = variableInstanceId;
        return this;
    }

    @Override
    public HistoricDetailQuery processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Override
    public HistoricDetailQuery executionId(String executionId) {
        this.executionId = executionId;
        return this;
    }

    @Override
    public HistoricDetailQuery activityId(String activityId) {
        this.activityId = activityId;
        return this;
    }

    @Override
    public HistoricDetailQuery activityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
        return this;
    }

    @Override
    public HistoricDetailQuery taskId(String taskId) {
        this.taskId = taskId;
        return this;
    }

    @Override
    public HistoricDetailQuery formProperties() {
        this.type = "FormProperty";
        return this;
    }

    @Override
    public HistoricDetailQuery formFields() {
        this.type = "FormProperty";
        return this;
    }

    @Override
    public HistoricDetailQuery variableUpdates() {
        this.type = "VariableUpdate";
        return this;
    }

    @Override
    public HistoricDetailQuery excludeTaskDetails() {
        this.excludeTaskRelated = true;
        return this;
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getHistoricDetailManager().findHistoricDetailCountByQueryCriteria(this);
    }

    @Override
    public List<HistoricDetail> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        List<HistoricDetail> historicDetails = commandContext.getHistoricDetailManager().findHistoricDetailsByQueryCriteria(this, page);
        if (historicDetails != null) {
            for (HistoricDetail historicDetail : historicDetails) {
                if (!(historicDetail instanceof HistoricDetailVariableInstanceUpdateEntity)) continue;
                ((HistoricDetailVariableInstanceUpdateEntity)historicDetail).getByteArrayValue();
            }
        }
        return historicDetails;
    }

    @Override
    public HistoricDetailQuery orderByProcessInstanceId() {
        this.orderBy(HistoricDetailQueryProperty.PROCESS_INSTANCE_ID);
        return this;
    }

    @Override
    public HistoricDetailQuery orderByTime() {
        this.orderBy(HistoricDetailQueryProperty.TIME);
        return this;
    }

    @Override
    public HistoricDetailQuery orderByVariableName() {
        this.orderBy(HistoricDetailQueryProperty.VARIABLE_NAME);
        return this;
    }

    @Override
    public HistoricDetailQuery orderByFormPropertyId() {
        this.orderBy(HistoricDetailQueryProperty.VARIABLE_NAME);
        return this;
    }

    @Override
    public HistoricDetailQuery orderByVariableRevision() {
        this.orderBy(HistoricDetailQueryProperty.VARIABLE_REVISION);
        return this;
    }

    @Override
    public HistoricDetailQuery orderByVariableType() {
        this.orderBy(HistoricDetailQueryProperty.VARIABLE_TYPE);
        return this;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public String getType() {
        return this.type;
    }

    public boolean getExcludeTaskRelated() {
        return this.excludeTaskRelated;
    }
}

