/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.container.impl.jmx.deployment;

import java.util.Map;
import org.camunda.bpm.application.impl.metadata.spi.ProcessArchiveXml;
import org.camunda.bpm.container.impl.jmx.JmxRuntimeContainerDelegate;
import org.camunda.bpm.container.impl.jmx.deployment.util.DeployedProcessArchive;
import org.camunda.bpm.container.impl.jmx.kernel.MBeanDeploymentOperation;
import org.camunda.bpm.container.impl.jmx.kernel.MBeanDeploymentOperationStep;
import org.camunda.bpm.container.impl.jmx.kernel.MBeanServiceContainer;
import org.camunda.bpm.container.impl.jmx.services.JmxManagedProcessApplication;
import org.camunda.bpm.container.impl.metadata.PropertyHelper;
import org.camunda.bpm.engine.ProcessEngine;

public class UndeployProcessArchiveStep
extends MBeanDeploymentOperationStep {
    protected String processArchvieName;
    protected JmxManagedProcessApplication deployedProcessApplication;
    protected ProcessArchiveXml processArchive;
    protected String processEngineName;

    public UndeployProcessArchiveStep(JmxManagedProcessApplication deployedProcessApplication, ProcessArchiveXml processArchive, String processEngineName) {
        this.deployedProcessApplication = deployedProcessApplication;
        this.processArchive = processArchive;
        this.processEngineName = processEngineName;
    }

    @Override
    public String getName() {
        return "Undeploying process archvie " + this.processArchvieName;
    }

    @Override
    public void performOperationStep(MBeanDeploymentOperation operationContext) {
        MBeanServiceContainer serviceContainer = operationContext.getServiceContainer();
        Map<String, DeployedProcessArchive> processArchiveDeploymentMap = this.deployedProcessApplication.getProcessArchiveDeploymentMap();
        DeployedProcessArchive deployedProcessArchive = processArchiveDeploymentMap.get(this.processArchive.getName());
        ProcessEngine processEngine = (ProcessEngine)serviceContainer.getServiceValue(JmxRuntimeContainerDelegate.ServiceTypes.PROCESS_ENGINE, this.processEngineName);
        processEngine.getManagementService().unregisterProcessApplication(deployedProcessArchive.getAllDeploymentIds(), true);
        if (PropertyHelper.getBooleanProperty(this.processArchive.getProperties(), "isDeleteUponUndeploy", false) && processEngine != null) {
            processEngine.getRepositoryService().deleteDeployment(deployedProcessArchive.getPrimaryDeploymentId(), true);
        }
    }
}

