/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.container.impl.jmx.deployment;

import java.util.Set;
import java.util.logging.Level;
import javax.management.ObjectName;
import org.camunda.bpm.container.impl.jmx.JmxRuntimeContainerDelegate;
import org.camunda.bpm.container.impl.jmx.kernel.MBeanDeploymentOperation;
import org.camunda.bpm.container.impl.jmx.kernel.MBeanDeploymentOperationStep;
import org.camunda.bpm.container.impl.jmx.kernel.MBeanServiceContainer;

public class StopProcessEnginesStep
extends MBeanDeploymentOperationStep {
    @Override
    public String getName() {
        return "Stopping process engines";
    }

    @Override
    public void performOperationStep(MBeanDeploymentOperation operationContext) {
        MBeanServiceContainer serviceContainer = operationContext.getServiceContainer();
        Set<ObjectName> serviceNames = serviceContainer.getServiceNames(JmxRuntimeContainerDelegate.ServiceTypes.PROCESS_ENGINE);
        for (ObjectName serviceName : serviceNames) {
            this.stopProcessEngine(serviceName, serviceContainer);
        }
    }

    private void stopProcessEngine(ObjectName serviceName, MBeanServiceContainer serviceContainer) {
        try {
            serviceContainer.stopService(serviceName);
        }
        catch (Exception e) {
            this.LOGGER.log(Level.FINE, "Could not stop managed process engine " + serviceName.toString(), e);
        }
    }
}

