/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.container.impl.jmx.deployment;

import java.util.List;
import java.util.logging.Level;
import org.camunda.bpm.application.ProcessApplicationInterface;
import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.container.impl.jmx.JmxRuntimeContainerDelegate;
import org.camunda.bpm.container.impl.jmx.kernel.MBeanDeploymentOperation;
import org.camunda.bpm.container.impl.jmx.kernel.MBeanDeploymentOperationStep;
import org.camunda.bpm.container.impl.jmx.kernel.MBeanServiceContainer;
import org.camunda.bpm.container.impl.jmx.services.JmxManagedProcessApplication;

public class StopProcessApplicationsStep
extends MBeanDeploymentOperationStep {
    @Override
    public String getName() {
        return "Stopping process applications";
    }

    @Override
    public void performOperationStep(MBeanDeploymentOperation operationContext) {
        MBeanServiceContainer serviceContainer = operationContext.getServiceContainer();
        List processApplicationsReferences = serviceContainer.getServiceValuesByType(JmxRuntimeContainerDelegate.ServiceTypes.PROCESS_APPLICATION);
        for (JmxManagedProcessApplication processApplication : processApplicationsReferences) {
            this.stopProcessApplication(processApplication.getProcessApplicationReference());
        }
    }

    protected void stopProcessApplication(ProcessApplicationReference processApplicationReference) {
        try {
            ProcessApplicationInterface processApplication = processApplicationReference.getProcessApplication();
            processApplication.undeploy();
        }
        catch (Throwable t) {
            this.LOGGER.log(Level.WARNING, "Exception while stopping ProcessApplication ", t);
        }
    }
}

