/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.container.impl.jmx.deployment;

import java.util.List;
import java.util.logging.Level;
import org.camunda.bpm.application.AbstractProcessApplication;
import org.camunda.bpm.application.impl.metadata.spi.ProcessesXml;
import org.camunda.bpm.container.impl.jmx.JmxRuntimeContainerDelegate;
import org.camunda.bpm.container.impl.jmx.kernel.MBeanDeploymentOperation;
import org.camunda.bpm.container.impl.jmx.kernel.MBeanDeploymentOperationStep;
import org.camunda.bpm.container.impl.jmx.kernel.MBeanServiceContainer;
import org.camunda.bpm.container.impl.jmx.services.JmxManagedProcessApplication;
import org.camunda.bpm.container.impl.metadata.spi.ProcessEngineXml;
import org.camunda.bpm.engine.ProcessEngineException;

public class ProcessesXmlStopProcessEnginesStep
extends MBeanDeploymentOperationStep {
    @Override
    public String getName() {
        return "Stopping process engines";
    }

    @Override
    public void performOperationStep(MBeanDeploymentOperation operationContext) {
        AbstractProcessApplication processApplication;
        MBeanServiceContainer serviceContainer = operationContext.getServiceContainer();
        JmxManagedProcessApplication deployedProcessApplication = (JmxManagedProcessApplication)serviceContainer.getService(JmxRuntimeContainerDelegate.ServiceTypes.PROCESS_APPLICATION, (processApplication = (AbstractProcessApplication)operationContext.getAttachment("processApplication")).getName());
        if (deployedProcessApplication == null) {
            throw new ProcessEngineException("Cannot find process application with name " + processApplication.getName() + ".");
        }
        List<ProcessesXml> processesXmls = deployedProcessApplication.getProcessesXmls();
        for (ProcessesXml processesXml : processesXmls) {
            this.stopProcessEngines(processesXml.getProcessEngines(), operationContext);
        }
    }

    protected void stopProcessEngines(List<ProcessEngineXml> processEngine, MBeanDeploymentOperation operationContext) {
        for (ProcessEngineXml parsedProcessEngine : processEngine) {
            this.stopProcessEngine(parsedProcessEngine.getName(), operationContext);
        }
    }

    protected void stopProcessEngine(String processEngineName, MBeanDeploymentOperation operationContext) {
        MBeanServiceContainer serviceContainer = operationContext.getServiceContainer();
        try {
            serviceContainer.stopService(JmxRuntimeContainerDelegate.ServiceTypes.PROCESS_ENGINE.getServiceName(processEngineName));
        }
        catch (Exception e) {
            this.LOGGER.log(Level.WARNING, "Could not stop managed process engine: " + e.getMessage(), e);
        }
    }
}

