/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.22.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.openapitools.client.model.HistoricJobLogQueryDtoSorting;

/**
 * A Historic Job Log instance query which defines a list of Historic Job Log instances
 */
@ApiModel(description = "A Historic Job Log instance query which defines a list of Historic Job Log instances")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-09-30T07:31:15.229408535Z[Etc/UTC]")
public class HistoricJobLogQueryDto {
  public static final String SERIALIZED_NAME_LOG_ID = "logId";
  @SerializedName(SERIALIZED_NAME_LOG_ID)
  private String logId;

  public static final String SERIALIZED_NAME_JOB_ID = "jobId";
  @SerializedName(SERIALIZED_NAME_JOB_ID)
  private String jobId;

  public static final String SERIALIZED_NAME_JOB_EXCEPTION_MESSAGE = "jobExceptionMessage";
  @SerializedName(SERIALIZED_NAME_JOB_EXCEPTION_MESSAGE)
  private String jobExceptionMessage;

  public static final String SERIALIZED_NAME_JOB_DEFINITION_ID = "jobDefinitionId";
  @SerializedName(SERIALIZED_NAME_JOB_DEFINITION_ID)
  private String jobDefinitionId;

  public static final String SERIALIZED_NAME_JOB_DEFINITION_TYPE = "jobDefinitionType";
  @SerializedName(SERIALIZED_NAME_JOB_DEFINITION_TYPE)
  private String jobDefinitionType;

  public static final String SERIALIZED_NAME_JOB_DEFINITION_CONFIGURATION = "jobDefinitionConfiguration";
  @SerializedName(SERIALIZED_NAME_JOB_DEFINITION_CONFIGURATION)
  private String jobDefinitionConfiguration;

  public static final String SERIALIZED_NAME_ACTIVITY_ID_IN = "activityIdIn";
  @SerializedName(SERIALIZED_NAME_ACTIVITY_ID_IN)
  private List<String> activityIdIn = null;

  public static final String SERIALIZED_NAME_FAILED_ACTIVITY_ID_IN = "failedActivityIdIn";
  @SerializedName(SERIALIZED_NAME_FAILED_ACTIVITY_ID_IN)
  private List<String> failedActivityIdIn = null;

  public static final String SERIALIZED_NAME_EXECUTION_ID_IN = "executionIdIn";
  @SerializedName(SERIALIZED_NAME_EXECUTION_ID_IN)
  private List<String> executionIdIn = null;

  public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID = "processInstanceId";
  @SerializedName(SERIALIZED_NAME_PROCESS_INSTANCE_ID)
  private String processInstanceId;

  public static final String SERIALIZED_NAME_PROCESS_DEFINITION_ID = "processDefinitionId";
  @SerializedName(SERIALIZED_NAME_PROCESS_DEFINITION_ID)
  private String processDefinitionId;

  public static final String SERIALIZED_NAME_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  @SerializedName(SERIALIZED_NAME_PROCESS_DEFINITION_KEY)
  private String processDefinitionKey;

  public static final String SERIALIZED_NAME_DEPLOYMENT_ID = "deploymentId";
  @SerializedName(SERIALIZED_NAME_DEPLOYMENT_ID)
  private String deploymentId;

  public static final String SERIALIZED_NAME_TENANT_ID_IN = "tenantIdIn";
  @SerializedName(SERIALIZED_NAME_TENANT_ID_IN)
  private List<String> tenantIdIn = null;

  public static final String SERIALIZED_NAME_WITHOUT_TENANT_ID = "withoutTenantId";
  @SerializedName(SERIALIZED_NAME_WITHOUT_TENANT_ID)
  private Boolean withoutTenantId;

  public static final String SERIALIZED_NAME_HOSTNAME = "hostname";
  @SerializedName(SERIALIZED_NAME_HOSTNAME)
  private String hostname;

  public static final String SERIALIZED_NAME_JOB_PRIORITY_LOWER_THAN_OR_EQUALS = "jobPriorityLowerThanOrEquals";
  @SerializedName(SERIALIZED_NAME_JOB_PRIORITY_LOWER_THAN_OR_EQUALS)
  private Long jobPriorityLowerThanOrEquals;

  public static final String SERIALIZED_NAME_JOB_PRIORITY_HIGHER_THAN_OR_EQUALS = "jobPriorityHigherThanOrEquals";
  @SerializedName(SERIALIZED_NAME_JOB_PRIORITY_HIGHER_THAN_OR_EQUALS)
  private Long jobPriorityHigherThanOrEquals;

  public static final String SERIALIZED_NAME_CREATION_LOG = "creationLog";
  @SerializedName(SERIALIZED_NAME_CREATION_LOG)
  private Boolean creationLog;

  public static final String SERIALIZED_NAME_FAILURE_LOG = "failureLog";
  @SerializedName(SERIALIZED_NAME_FAILURE_LOG)
  private Boolean failureLog;

  public static final String SERIALIZED_NAME_SUCCESS_LOG = "successLog";
  @SerializedName(SERIALIZED_NAME_SUCCESS_LOG)
  private Boolean successLog;

  public static final String SERIALIZED_NAME_DELETION_LOG = "deletionLog";
  @SerializedName(SERIALIZED_NAME_DELETION_LOG)
  private Boolean deletionLog;

  public static final String SERIALIZED_NAME_SORTING = "sorting";
  @SerializedName(SERIALIZED_NAME_SORTING)
  private List<HistoricJobLogQueryDtoSorting> sorting = null;


  public HistoricJobLogQueryDto logId(String logId) {
    
    this.logId = logId;
    return this;
  }

   /**
   * Filter by historic job log id.
   * @return logId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by historic job log id.")

  public String getLogId() {
    return logId;
  }


  public void setLogId(String logId) {
    this.logId = logId;
  }


  public HistoricJobLogQueryDto jobId(String jobId) {
    
    this.jobId = jobId;
    return this;
  }

   /**
   * Filter by job id.
   * @return jobId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by job id.")

  public String getJobId() {
    return jobId;
  }


  public void setJobId(String jobId) {
    this.jobId = jobId;
  }


  public HistoricJobLogQueryDto jobExceptionMessage(String jobExceptionMessage) {
    
    this.jobExceptionMessage = jobExceptionMessage;
    return this;
  }

   /**
   * Filter by job exception message.
   * @return jobExceptionMessage
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by job exception message.")

  public String getJobExceptionMessage() {
    return jobExceptionMessage;
  }


  public void setJobExceptionMessage(String jobExceptionMessage) {
    this.jobExceptionMessage = jobExceptionMessage;
  }


  public HistoricJobLogQueryDto jobDefinitionId(String jobDefinitionId) {
    
    this.jobDefinitionId = jobDefinitionId;
    return this;
  }

   /**
   * Filter by job definition id.
   * @return jobDefinitionId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by job definition id.")

  public String getJobDefinitionId() {
    return jobDefinitionId;
  }


  public void setJobDefinitionId(String jobDefinitionId) {
    this.jobDefinitionId = jobDefinitionId;
  }


  public HistoricJobLogQueryDto jobDefinitionType(String jobDefinitionType) {
    
    this.jobDefinitionType = jobDefinitionType;
    return this;
  }

   /**
   * Filter by job definition type. See the [User Guide](https://docs.camunda.org/manual/7.22/user-guide/process-engine/the-job-executor/#job-creation) for more information about job definition types.
   * @return jobDefinitionType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by job definition type. See the [User Guide](https://docs.camunda.org/manual/7.22/user-guide/process-engine/the-job-executor/#job-creation) for more information about job definition types.")

  public String getJobDefinitionType() {
    return jobDefinitionType;
  }


  public void setJobDefinitionType(String jobDefinitionType) {
    this.jobDefinitionType = jobDefinitionType;
  }


  public HistoricJobLogQueryDto jobDefinitionConfiguration(String jobDefinitionConfiguration) {
    
    this.jobDefinitionConfiguration = jobDefinitionConfiguration;
    return this;
  }

   /**
   * Filter by job definition configuration.
   * @return jobDefinitionConfiguration
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by job definition configuration.")

  public String getJobDefinitionConfiguration() {
    return jobDefinitionConfiguration;
  }


  public void setJobDefinitionConfiguration(String jobDefinitionConfiguration) {
    this.jobDefinitionConfiguration = jobDefinitionConfiguration;
  }


  public HistoricJobLogQueryDto activityIdIn(List<String> activityIdIn) {
    
    this.activityIdIn = activityIdIn;
    return this;
  }

  public HistoricJobLogQueryDto addActivityIdInItem(String activityIdInItem) {
    if (this.activityIdIn == null) {
      this.activityIdIn = new ArrayList<String>();
    }
    this.activityIdIn.add(activityIdInItem);
    return this;
  }

   /**
   * Only include historic job logs which belong to one of the passed activity ids.
   * @return activityIdIn
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Only include historic job logs which belong to one of the passed activity ids.")

  public List<String> getActivityIdIn() {
    return activityIdIn;
  }


  public void setActivityIdIn(List<String> activityIdIn) {
    this.activityIdIn = activityIdIn;
  }


  public HistoricJobLogQueryDto failedActivityIdIn(List<String> failedActivityIdIn) {
    
    this.failedActivityIdIn = failedActivityIdIn;
    return this;
  }

  public HistoricJobLogQueryDto addFailedActivityIdInItem(String failedActivityIdInItem) {
    if (this.failedActivityIdIn == null) {
      this.failedActivityIdIn = new ArrayList<String>();
    }
    this.failedActivityIdIn.add(failedActivityIdInItem);
    return this;
  }

   /**
   * Only include historic job logs which belong to failures of one of the passed activity ids.
   * @return failedActivityIdIn
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Only include historic job logs which belong to failures of one of the passed activity ids.")

  public List<String> getFailedActivityIdIn() {
    return failedActivityIdIn;
  }


  public void setFailedActivityIdIn(List<String> failedActivityIdIn) {
    this.failedActivityIdIn = failedActivityIdIn;
  }


  public HistoricJobLogQueryDto executionIdIn(List<String> executionIdIn) {
    
    this.executionIdIn = executionIdIn;
    return this;
  }

  public HistoricJobLogQueryDto addExecutionIdInItem(String executionIdInItem) {
    if (this.executionIdIn == null) {
      this.executionIdIn = new ArrayList<String>();
    }
    this.executionIdIn.add(executionIdInItem);
    return this;
  }

   /**
   * Only include historic job logs which belong to one of the passed execution ids.
   * @return executionIdIn
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Only include historic job logs which belong to one of the passed execution ids.")

  public List<String> getExecutionIdIn() {
    return executionIdIn;
  }


  public void setExecutionIdIn(List<String> executionIdIn) {
    this.executionIdIn = executionIdIn;
  }


  public HistoricJobLogQueryDto processInstanceId(String processInstanceId) {
    
    this.processInstanceId = processInstanceId;
    return this;
  }

   /**
   * Filter by process instance id.
   * @return processInstanceId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by process instance id.")

  public String getProcessInstanceId() {
    return processInstanceId;
  }


  public void setProcessInstanceId(String processInstanceId) {
    this.processInstanceId = processInstanceId;
  }


  public HistoricJobLogQueryDto processDefinitionId(String processDefinitionId) {
    
    this.processDefinitionId = processDefinitionId;
    return this;
  }

   /**
   * Filter by process definition id.
   * @return processDefinitionId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by process definition id.")

  public String getProcessDefinitionId() {
    return processDefinitionId;
  }


  public void setProcessDefinitionId(String processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }


  public HistoricJobLogQueryDto processDefinitionKey(String processDefinitionKey) {
    
    this.processDefinitionKey = processDefinitionKey;
    return this;
  }

   /**
   * Filter by process definition key.
   * @return processDefinitionKey
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by process definition key.")

  public String getProcessDefinitionKey() {
    return processDefinitionKey;
  }


  public void setProcessDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }


  public HistoricJobLogQueryDto deploymentId(String deploymentId) {
    
    this.deploymentId = deploymentId;
    return this;
  }

   /**
   * Filter by deployment id.
   * @return deploymentId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by deployment id.")

  public String getDeploymentId() {
    return deploymentId;
  }


  public void setDeploymentId(String deploymentId) {
    this.deploymentId = deploymentId;
  }


  public HistoricJobLogQueryDto tenantIdIn(List<String> tenantIdIn) {
    
    this.tenantIdIn = tenantIdIn;
    return this;
  }

  public HistoricJobLogQueryDto addTenantIdInItem(String tenantIdInItem) {
    if (this.tenantIdIn == null) {
      this.tenantIdIn = new ArrayList<String>();
    }
    this.tenantIdIn.add(tenantIdInItem);
    return this;
  }

   /**
   * Only include historic job log entries which belong to one of the passed and comma- separated tenant ids.
   * @return tenantIdIn
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Only include historic job log entries which belong to one of the passed and comma- separated tenant ids.")

  public List<String> getTenantIdIn() {
    return tenantIdIn;
  }


  public void setTenantIdIn(List<String> tenantIdIn) {
    this.tenantIdIn = tenantIdIn;
  }


  public HistoricJobLogQueryDto withoutTenantId(Boolean withoutTenantId) {
    
    this.withoutTenantId = withoutTenantId;
    return this;
  }

   /**
   * Only include historic job log entries that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return withoutTenantId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Only include historic job log entries that belong to no tenant. Value may only be `true`, as `false` is the default behavior.")

  public Boolean getWithoutTenantId() {
    return withoutTenantId;
  }


  public void setWithoutTenantId(Boolean withoutTenantId) {
    this.withoutTenantId = withoutTenantId;
  }


  public HistoricJobLogQueryDto hostname(String hostname) {
    
    this.hostname = hostname;
    return this;
  }

   /**
   * Filter by hostname.
   * @return hostname
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by hostname.")

  public String getHostname() {
    return hostname;
  }


  public void setHostname(String hostname) {
    this.hostname = hostname;
  }


  public HistoricJobLogQueryDto jobPriorityLowerThanOrEquals(Long jobPriorityLowerThanOrEquals) {
    
    this.jobPriorityLowerThanOrEquals = jobPriorityLowerThanOrEquals;
    return this;
  }

   /**
   * Only include logs for which the associated job had a priority lower than or equal to the given value. Value must be a valid &#x60;long&#x60; value.
   * @return jobPriorityLowerThanOrEquals
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Only include logs for which the associated job had a priority lower than or equal to the given value. Value must be a valid `long` value.")

  public Long getJobPriorityLowerThanOrEquals() {
    return jobPriorityLowerThanOrEquals;
  }


  public void setJobPriorityLowerThanOrEquals(Long jobPriorityLowerThanOrEquals) {
    this.jobPriorityLowerThanOrEquals = jobPriorityLowerThanOrEquals;
  }


  public HistoricJobLogQueryDto jobPriorityHigherThanOrEquals(Long jobPriorityHigherThanOrEquals) {
    
    this.jobPriorityHigherThanOrEquals = jobPriorityHigherThanOrEquals;
    return this;
  }

   /**
   * Only include logs for which the associated job had a priority higher than or equal to the given value. Value must be a valid &#x60;long&#x60; value.
   * @return jobPriorityHigherThanOrEquals
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Only include logs for which the associated job had a priority higher than or equal to the given value. Value must be a valid `long` value.")

  public Long getJobPriorityHigherThanOrEquals() {
    return jobPriorityHigherThanOrEquals;
  }


  public void setJobPriorityHigherThanOrEquals(Long jobPriorityHigherThanOrEquals) {
    this.jobPriorityHigherThanOrEquals = jobPriorityHigherThanOrEquals;
  }


  public HistoricJobLogQueryDto creationLog(Boolean creationLog) {
    
    this.creationLog = creationLog;
    return this;
  }

   /**
   * Only include creation logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return creationLog
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Only include creation logs. Value may only be `true`, as `false` is the default behavior.")

  public Boolean getCreationLog() {
    return creationLog;
  }


  public void setCreationLog(Boolean creationLog) {
    this.creationLog = creationLog;
  }


  public HistoricJobLogQueryDto failureLog(Boolean failureLog) {
    
    this.failureLog = failureLog;
    return this;
  }

   /**
   * Only include failure logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return failureLog
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Only include failure logs. Value may only be `true`, as `false` is the default behavior.")

  public Boolean getFailureLog() {
    return failureLog;
  }


  public void setFailureLog(Boolean failureLog) {
    this.failureLog = failureLog;
  }


  public HistoricJobLogQueryDto successLog(Boolean successLog) {
    
    this.successLog = successLog;
    return this;
  }

   /**
   * Only include success logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return successLog
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Only include success logs. Value may only be `true`, as `false` is the default behavior.")

  public Boolean getSuccessLog() {
    return successLog;
  }


  public void setSuccessLog(Boolean successLog) {
    this.successLog = successLog;
  }


  public HistoricJobLogQueryDto deletionLog(Boolean deletionLog) {
    
    this.deletionLog = deletionLog;
    return this;
  }

   /**
   * Only include deletion logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return deletionLog
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Only include deletion logs. Value may only be `true`, as `false` is the default behavior.")

  public Boolean getDeletionLog() {
    return deletionLog;
  }


  public void setDeletionLog(Boolean deletionLog) {
    this.deletionLog = deletionLog;
  }


  public HistoricJobLogQueryDto sorting(List<HistoricJobLogQueryDtoSorting> sorting) {
    
    this.sorting = sorting;
    return this;
  }

  public HistoricJobLogQueryDto addSortingItem(HistoricJobLogQueryDtoSorting sortingItem) {
    if (this.sorting == null) {
      this.sorting = new ArrayList<HistoricJobLogQueryDtoSorting>();
    }
    this.sorting.add(sortingItem);
    return this;
  }

   /**
   * An array of criteria to sort the result by. Each element of the array is                        an object that specifies one ordering. The position in the array                        identifies the rank of an ordering, i.e., whether it is primary, secondary,                        etc. Sorting has no effect for &#x60;count&#x60; endpoints
   * @return sorting
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "An array of criteria to sort the result by. Each element of the array is                        an object that specifies one ordering. The position in the array                        identifies the rank of an ordering, i.e., whether it is primary, secondary,                        etc. Sorting has no effect for `count` endpoints")

  public List<HistoricJobLogQueryDtoSorting> getSorting() {
    return sorting;
  }


  public void setSorting(List<HistoricJobLogQueryDtoSorting> sorting) {
    this.sorting = sorting;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HistoricJobLogQueryDto historicJobLogQueryDto = (HistoricJobLogQueryDto) o;
    return Objects.equals(this.logId, historicJobLogQueryDto.logId) &&
        Objects.equals(this.jobId, historicJobLogQueryDto.jobId) &&
        Objects.equals(this.jobExceptionMessage, historicJobLogQueryDto.jobExceptionMessage) &&
        Objects.equals(this.jobDefinitionId, historicJobLogQueryDto.jobDefinitionId) &&
        Objects.equals(this.jobDefinitionType, historicJobLogQueryDto.jobDefinitionType) &&
        Objects.equals(this.jobDefinitionConfiguration, historicJobLogQueryDto.jobDefinitionConfiguration) &&
        Objects.equals(this.activityIdIn, historicJobLogQueryDto.activityIdIn) &&
        Objects.equals(this.failedActivityIdIn, historicJobLogQueryDto.failedActivityIdIn) &&
        Objects.equals(this.executionIdIn, historicJobLogQueryDto.executionIdIn) &&
        Objects.equals(this.processInstanceId, historicJobLogQueryDto.processInstanceId) &&
        Objects.equals(this.processDefinitionId, historicJobLogQueryDto.processDefinitionId) &&
        Objects.equals(this.processDefinitionKey, historicJobLogQueryDto.processDefinitionKey) &&
        Objects.equals(this.deploymentId, historicJobLogQueryDto.deploymentId) &&
        Objects.equals(this.tenantIdIn, historicJobLogQueryDto.tenantIdIn) &&
        Objects.equals(this.withoutTenantId, historicJobLogQueryDto.withoutTenantId) &&
        Objects.equals(this.hostname, historicJobLogQueryDto.hostname) &&
        Objects.equals(this.jobPriorityLowerThanOrEquals, historicJobLogQueryDto.jobPriorityLowerThanOrEquals) &&
        Objects.equals(this.jobPriorityHigherThanOrEquals, historicJobLogQueryDto.jobPriorityHigherThanOrEquals) &&
        Objects.equals(this.creationLog, historicJobLogQueryDto.creationLog) &&
        Objects.equals(this.failureLog, historicJobLogQueryDto.failureLog) &&
        Objects.equals(this.successLog, historicJobLogQueryDto.successLog) &&
        Objects.equals(this.deletionLog, historicJobLogQueryDto.deletionLog) &&
        Objects.equals(this.sorting, historicJobLogQueryDto.sorting);
  }

  @Override
  public int hashCode() {
    return Objects.hash(logId, jobId, jobExceptionMessage, jobDefinitionId, jobDefinitionType, jobDefinitionConfiguration, activityIdIn, failedActivityIdIn, executionIdIn, processInstanceId, processDefinitionId, processDefinitionKey, deploymentId, tenantIdIn, withoutTenantId, hostname, jobPriorityLowerThanOrEquals, jobPriorityHigherThanOrEquals, creationLog, failureLog, successLog, deletionLog, sorting);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HistoricJobLogQueryDto {\n");
    sb.append("    logId: ").append(toIndentedString(logId)).append("\n");
    sb.append("    jobId: ").append(toIndentedString(jobId)).append("\n");
    sb.append("    jobExceptionMessage: ").append(toIndentedString(jobExceptionMessage)).append("\n");
    sb.append("    jobDefinitionId: ").append(toIndentedString(jobDefinitionId)).append("\n");
    sb.append("    jobDefinitionType: ").append(toIndentedString(jobDefinitionType)).append("\n");
    sb.append("    jobDefinitionConfiguration: ").append(toIndentedString(jobDefinitionConfiguration)).append("\n");
    sb.append("    activityIdIn: ").append(toIndentedString(activityIdIn)).append("\n");
    sb.append("    failedActivityIdIn: ").append(toIndentedString(failedActivityIdIn)).append("\n");
    sb.append("    executionIdIn: ").append(toIndentedString(executionIdIn)).append("\n");
    sb.append("    processInstanceId: ").append(toIndentedString(processInstanceId)).append("\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    deploymentId: ").append(toIndentedString(deploymentId)).append("\n");
    sb.append("    tenantIdIn: ").append(toIndentedString(tenantIdIn)).append("\n");
    sb.append("    withoutTenantId: ").append(toIndentedString(withoutTenantId)).append("\n");
    sb.append("    hostname: ").append(toIndentedString(hostname)).append("\n");
    sb.append("    jobPriorityLowerThanOrEquals: ").append(toIndentedString(jobPriorityLowerThanOrEquals)).append("\n");
    sb.append("    jobPriorityHigherThanOrEquals: ").append(toIndentedString(jobPriorityHigherThanOrEquals)).append("\n");
    sb.append("    creationLog: ").append(toIndentedString(creationLog)).append("\n");
    sb.append("    failureLog: ").append(toIndentedString(failureLog)).append("\n");
    sb.append("    successLog: ").append(toIndentedString(successLog)).append("\n");
    sb.append("    deletionLog: ").append(toIndentedString(deletionLog)).append("\n");
    sb.append("    sorting: ").append(toIndentedString(sorting)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

