/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.22.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openapitools.client.api;

import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.ProgressRequestBody;
import org.openapitools.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import org.openapitools.client.model.ExceptionDto;
import org.openapitools.client.model.TelemetryConfigurationDto;
import org.openapitools.client.model.TelemetryDataDto;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TelemetryApi {
    private ApiClient localVarApiClient;

    public TelemetryApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TelemetryApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for configureTelemetry
     * @param telemetryConfigurationDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> If the user who perform the operation is not a &lt;b&gt;camunda-admin&lt;/b&gt; user. </td><td>  -  </td></tr>
     </table>
     * @deprecated
     */
    @Deprecated
    public okhttp3.Call configureTelemetryCall(TelemetryConfigurationDto telemetryConfigurationDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = telemetryConfigurationDto;

        // create path and map variables
        String localVarPath = "/telemetry/configuration";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @Deprecated
    @SuppressWarnings("rawtypes")
    private okhttp3.Call configureTelemetryValidateBeforeCall(TelemetryConfigurationDto telemetryConfigurationDto, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = configureTelemetryCall(telemetryConfigurationDto, _callback);
        return localVarCall;

    }

    /**
     * Configure Telemetry
     * Deprecated: The sending telemetry feature is removed. Please remove the endpoint usages as they are no longer needed.
     * @param telemetryConfigurationDto  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> If the user who perform the operation is not a &lt;b&gt;camunda-admin&lt;/b&gt; user. </td><td>  -  </td></tr>
     </table>
     * @deprecated
     */
    @Deprecated
    public void configureTelemetry(TelemetryConfigurationDto telemetryConfigurationDto) throws ApiException {
        configureTelemetryWithHttpInfo(telemetryConfigurationDto);
    }

    /**
     * Configure Telemetry
     * Deprecated: The sending telemetry feature is removed. Please remove the endpoint usages as they are no longer needed.
     * @param telemetryConfigurationDto  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> If the user who perform the operation is not a &lt;b&gt;camunda-admin&lt;/b&gt; user. </td><td>  -  </td></tr>
     </table>
     * @deprecated
     */
    @Deprecated
    public ApiResponse<Void> configureTelemetryWithHttpInfo(TelemetryConfigurationDto telemetryConfigurationDto) throws ApiException {
        okhttp3.Call localVarCall = configureTelemetryValidateBeforeCall(telemetryConfigurationDto, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Configure Telemetry (asynchronously)
     * Deprecated: The sending telemetry feature is removed. Please remove the endpoint usages as they are no longer needed.
     * @param telemetryConfigurationDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> If the user who perform the operation is not a &lt;b&gt;camunda-admin&lt;/b&gt; user. </td><td>  -  </td></tr>
     </table>
     * @deprecated
     */
    @Deprecated
    public okhttp3.Call configureTelemetryAsync(TelemetryConfigurationDto telemetryConfigurationDto, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = configureTelemetryValidateBeforeCall(telemetryConfigurationDto, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for getTelemetryConfiguration
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> If the user who perform the operation is not a &lt;b&gt;camunda-admin&lt;/b&gt; user. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getTelemetryConfigurationCall(final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/telemetry/configuration";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getTelemetryConfigurationValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getTelemetryConfigurationCall(_callback);
        return localVarCall;

    }

    /**
     * Fetch Telemetry Configuration
     * Fetches Telemetry Configuration.
     * @return TelemetryConfigurationDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> If the user who perform the operation is not a &lt;b&gt;camunda-admin&lt;/b&gt; user. </td><td>  -  </td></tr>
     </table>
     */
    public TelemetryConfigurationDto getTelemetryConfiguration() throws ApiException {
        ApiResponse<TelemetryConfigurationDto> localVarResp = getTelemetryConfigurationWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * Fetch Telemetry Configuration
     * Fetches Telemetry Configuration.
     * @return ApiResponse&lt;TelemetryConfigurationDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> If the user who perform the operation is not a &lt;b&gt;camunda-admin&lt;/b&gt; user. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TelemetryConfigurationDto> getTelemetryConfigurationWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = getTelemetryConfigurationValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<TelemetryConfigurationDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Fetch Telemetry Configuration (asynchronously)
     * Fetches Telemetry Configuration.
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> If the user who perform the operation is not a &lt;b&gt;camunda-admin&lt;/b&gt; user. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getTelemetryConfigurationAsync(final ApiCallback<TelemetryConfigurationDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getTelemetryConfigurationValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<TelemetryConfigurationDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getTelemetryData
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
     </table>
     * @deprecated
     */
    @Deprecated
    public okhttp3.Call getTelemetryDataCall(final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/telemetry/data";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @Deprecated
    @SuppressWarnings("rawtypes")
    private okhttp3.Call getTelemetryDataValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getTelemetryDataCall(_callback);
        return localVarCall;

    }

    /**
     * Fetch Telemetry Data
     * Deprecated: Always returns false. The sending telemetry feature is removed. Please remove the endpoint usages as they are no longer needed.
     * @return TelemetryDataDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
     </table>
     * @deprecated
     */
    @Deprecated
    public TelemetryDataDto getTelemetryData() throws ApiException {
        ApiResponse<TelemetryDataDto> localVarResp = getTelemetryDataWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * Fetch Telemetry Data
     * Deprecated: Always returns false. The sending telemetry feature is removed. Please remove the endpoint usages as they are no longer needed.
     * @return ApiResponse&lt;TelemetryDataDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
     </table>
     * @deprecated
     */
    @Deprecated
    public ApiResponse<TelemetryDataDto> getTelemetryDataWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = getTelemetryDataValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<TelemetryDataDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Fetch Telemetry Data (asynchronously)
     * Deprecated: Always returns false. The sending telemetry feature is removed. Please remove the endpoint usages as they are no longer needed.
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
     </table>
     * @deprecated
     */
    @Deprecated
    public okhttp3.Call getTelemetryDataAsync(final ApiCallback<TelemetryDataDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getTelemetryDataValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<TelemetryDataDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
