/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.22.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openapitools.client.api;

import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.ProgressRequestBody;
import org.openapitools.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import org.openapitools.client.model.CountResultDto;
import java.util.Date;
import org.openapitools.client.model.ExceptionDto;
import org.openapitools.client.model.HistoricTaskInstanceDto;
import org.openapitools.client.model.HistoricTaskInstanceQueryDto;
import org.openapitools.client.model.HistoricTaskInstanceReportResultDto;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HistoricTaskInstanceApi {
    private ApiClient localVarApiClient;

    public HistoricTaskInstanceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public HistoricTaskInstanceApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for getHistoricTaskInstanceReport
     * @param reportType **Mandatory.** Specifies the kind of the report to execute. To retrieve a report about the duration of process instances the value must be set to &#x60;duration&#x60;. For a report of the completed tasks in a specific timespan the value must be set to &#x60;count&#x60;. (optional)
     * @param periodUnit When the report type is set to &#x60;duration&#x60;, this parameter is **mandatory**. Specifies the granularity of the report. Valid values are &#x60;month&#x60; and &#x60;quarter&#x60;. (optional)
     * @param completedBefore Restrict to tasks that were completed before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param completedAfter Restrict to tasks that were completed after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param groupBy When the report type is set to &#x60;count&#x60;, this parameter is **mandatory**. Groups the tasks report by a given criterion. Valid values are &#x60;taskName&#x60; and &#x60;processDefinition&#x60;. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;completedAfter&#x60; parameter is supplied, but the date format is wrong. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricTaskInstanceReportCall(String reportType, String periodUnit, Date completedBefore, Date completedAfter, String groupBy, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/history/task/report";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (reportType != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("reportType", reportType));
        }

        if (periodUnit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("periodUnit", periodUnit));
        }

        if (completedBefore != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("completedBefore", completedBefore));
        }

        if (completedAfter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("completedAfter", completedAfter));
        }

        if (groupBy != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("groupBy", groupBy));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getHistoricTaskInstanceReportValidateBeforeCall(String reportType, String periodUnit, Date completedBefore, Date completedAfter, String groupBy, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getHistoricTaskInstanceReportCall(reportType, periodUnit, completedBefore, completedAfter, groupBy, _callback);
        return localVarCall;

    }

    /**
     * Get Task Report (Historic)
     * Retrieves a report of completed tasks. When the report type is set to &#x60;count&#x60;, the report contains a list of completed task counts where an entry contains the task name, the definition key of the task, the process definition id, the process definition key, the process definition name and the count of how many tasks were completed for the specified key in a given period. When the report type is set to &#x60;duration&#x60;, the report contains a minimum, maximum and average duration value of all completed task instances in a given period.
     * @param reportType **Mandatory.** Specifies the kind of the report to execute. To retrieve a report about the duration of process instances the value must be set to &#x60;duration&#x60;. For a report of the completed tasks in a specific timespan the value must be set to &#x60;count&#x60;. (optional)
     * @param periodUnit When the report type is set to &#x60;duration&#x60;, this parameter is **mandatory**. Specifies the granularity of the report. Valid values are &#x60;month&#x60; and &#x60;quarter&#x60;. (optional)
     * @param completedBefore Restrict to tasks that were completed before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param completedAfter Restrict to tasks that were completed after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param groupBy When the report type is set to &#x60;count&#x60;, this parameter is **mandatory**. Groups the tasks report by a given criterion. Valid values are &#x60;taskName&#x60; and &#x60;processDefinition&#x60;. (optional)
     * @return List&lt;HistoricTaskInstanceReportResultDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;completedAfter&#x60; parameter is supplied, but the date format is wrong. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public List<HistoricTaskInstanceReportResultDto> getHistoricTaskInstanceReport(String reportType, String periodUnit, Date completedBefore, Date completedAfter, String groupBy) throws ApiException {
        ApiResponse<List<HistoricTaskInstanceReportResultDto>> localVarResp = getHistoricTaskInstanceReportWithHttpInfo(reportType, periodUnit, completedBefore, completedAfter, groupBy);
        return localVarResp.getData();
    }

    /**
     * Get Task Report (Historic)
     * Retrieves a report of completed tasks. When the report type is set to &#x60;count&#x60;, the report contains a list of completed task counts where an entry contains the task name, the definition key of the task, the process definition id, the process definition key, the process definition name and the count of how many tasks were completed for the specified key in a given period. When the report type is set to &#x60;duration&#x60;, the report contains a minimum, maximum and average duration value of all completed task instances in a given period.
     * @param reportType **Mandatory.** Specifies the kind of the report to execute. To retrieve a report about the duration of process instances the value must be set to &#x60;duration&#x60;. For a report of the completed tasks in a specific timespan the value must be set to &#x60;count&#x60;. (optional)
     * @param periodUnit When the report type is set to &#x60;duration&#x60;, this parameter is **mandatory**. Specifies the granularity of the report. Valid values are &#x60;month&#x60; and &#x60;quarter&#x60;. (optional)
     * @param completedBefore Restrict to tasks that were completed before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param completedAfter Restrict to tasks that were completed after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param groupBy When the report type is set to &#x60;count&#x60;, this parameter is **mandatory**. Groups the tasks report by a given criterion. Valid values are &#x60;taskName&#x60; and &#x60;processDefinition&#x60;. (optional)
     * @return ApiResponse&lt;List&lt;HistoricTaskInstanceReportResultDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;completedAfter&#x60; parameter is supplied, but the date format is wrong. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<HistoricTaskInstanceReportResultDto>> getHistoricTaskInstanceReportWithHttpInfo(String reportType, String periodUnit, Date completedBefore, Date completedAfter, String groupBy) throws ApiException {
        okhttp3.Call localVarCall = getHistoricTaskInstanceReportValidateBeforeCall(reportType, periodUnit, completedBefore, completedAfter, groupBy, null);
        Type localVarReturnType = new TypeToken<List<HistoricTaskInstanceReportResultDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Task Report (Historic) (asynchronously)
     * Retrieves a report of completed tasks. When the report type is set to &#x60;count&#x60;, the report contains a list of completed task counts where an entry contains the task name, the definition key of the task, the process definition id, the process definition key, the process definition name and the count of how many tasks were completed for the specified key in a given period. When the report type is set to &#x60;duration&#x60;, the report contains a minimum, maximum and average duration value of all completed task instances in a given period.
     * @param reportType **Mandatory.** Specifies the kind of the report to execute. To retrieve a report about the duration of process instances the value must be set to &#x60;duration&#x60;. For a report of the completed tasks in a specific timespan the value must be set to &#x60;count&#x60;. (optional)
     * @param periodUnit When the report type is set to &#x60;duration&#x60;, this parameter is **mandatory**. Specifies the granularity of the report. Valid values are &#x60;month&#x60; and &#x60;quarter&#x60;. (optional)
     * @param completedBefore Restrict to tasks that were completed before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param completedAfter Restrict to tasks that were completed after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param groupBy When the report type is set to &#x60;count&#x60;, this parameter is **mandatory**. Groups the tasks report by a given criterion. Valid values are &#x60;taskName&#x60; and &#x60;processDefinition&#x60;. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;completedAfter&#x60; parameter is supplied, but the date format is wrong. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricTaskInstanceReportAsync(String reportType, String periodUnit, Date completedBefore, Date completedAfter, String groupBy, final ApiCallback<List<HistoricTaskInstanceReportResultDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getHistoricTaskInstanceReportValidateBeforeCall(reportType, periodUnit, completedBefore, completedAfter, groupBy, _callback);
        Type localVarReturnType = new TypeToken<List<HistoricTaskInstanceReportResultDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getHistoricTaskInstances
     * @param taskId Filter by task id. (optional)
     * @param taskParentTaskId Filter by parent task id. (optional)
     * @param processInstanceId Filter by process instance id. (optional)
     * @param rootProcessInstanceId Filter by root process instance id. (optional)
     * @param processInstanceBusinessKey Filter by process instance business key. (optional)
     * @param processInstanceBusinessKeyIn Filter by process instances with one of the give business keys. The keys need to be in a comma-separated list. (optional)
     * @param processInstanceBusinessKeyLike Filter by  process instance business key that has the parameter value as a substring. (optional)
     * @param executionId Filter by the id of the execution that executed the task. (optional)
     * @param processDefinitionId Filter by process definition id. (optional)
     * @param processDefinitionKey Restrict to tasks that belong to a process definition with the given key. (optional)
     * @param processDefinitionName Restrict to tasks that belong to a process definition with the given name. (optional)
     * @param caseInstanceId Filter by case instance id. (optional)
     * @param caseExecutionId Filter by the id of the case execution that executed the task. (optional)
     * @param caseDefinitionId Filter by case definition id. (optional)
     * @param caseDefinitionKey Restrict to tasks that belong to a case definition with the given key. (optional)
     * @param caseDefinitionName Restrict to tasks that belong to a case definition with the given name. (optional)
     * @param activityInstanceIdIn Only include tasks which belong to one of the passed comma-separated activity instance ids. (optional)
     * @param taskName Restrict to tasks that have the given name. (optional)
     * @param taskNameLike Restrict to tasks that have a name with the given parameter value as substring. (optional)
     * @param taskDescription Restrict to tasks that have the given description. (optional)
     * @param taskDescriptionLike Restrict to tasks that have a description that has the parameter value as a substring. (optional)
     * @param taskDefinitionKey Restrict to tasks that have the given key. (optional)
     * @param taskDefinitionKeyIn Restrict to tasks that have one of the passed comma-separated task definition keys. (optional)
     * @param taskDeleteReason Restrict to tasks that have the given delete reason. (optional)
     * @param taskDeleteReasonLike Restrict to tasks that have a delete reason that has the parameter value as a substring. (optional)
     * @param taskAssignee Restrict to tasks that the given user is assigned to. (optional)
     * @param taskAssigneeLike Restrict to tasks that are assigned to users with the parameter value as a substring. (optional)
     * @param taskOwner Restrict to tasks that the given user owns. (optional)
     * @param taskOwnerLike Restrict to tasks that are owned by users with the parameter value as a substring. (optional)
     * @param taskPriority Restrict to tasks that have the given priority. (optional)
     * @param assigned If set to &#x60;true&#x60;, restricts the query to all tasks that are assigned. (optional)
     * @param unassigned If set to &#x60;true&#x60;, restricts the query to all tasks that are unassigned. (optional)
     * @param finished Only include finished tasks. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param unfinished Only include unfinished tasks. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param processFinished Only include tasks of finished processes. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param processUnfinished Only include tasks of unfinished processes. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param taskDueDate Restrict to tasks that are due on the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param taskDueDateBefore Restrict to tasks that are due before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param taskDueDateAfter Restrict to tasks that are due after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param withoutTaskDueDate Only include tasks which have no due date. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param taskFollowUpDate Restrict to tasks that have a followUp date on the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param taskFollowUpDateBefore Restrict to tasks that have a followUp date before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param taskFollowUpDateAfter Restrict to tasks that have a followUp date after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedBefore Restrict to tasks that were started before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedAfter Restrict to tasks that were started after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param finishedBefore Restrict to tasks that were finished before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param finishedAfter Restrict to tasks that were finished after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A task instance must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include historic task instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param taskVariables Only include tasks that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value. **Note:** Values are always treated as &#x60;String&#x60; objects on server side.   Valid operator values are: * &#x60;eq&#x60; - equal to; * &#x60;neq&#x60; - not equal to; * &#x60;gt&#x60; - greater than; * &#x60;gteq&#x60; - greater than or equal to; * &#x60;lt&#x60; - lower than; * &#x60;lteq&#x60; - lower than or equal to; * &#x60;like&#x60;.  &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
     * @param processVariables Only include tasks that belong to process instances that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value. **Note:** Values are always treated as &#x60;String&#x60; objects on server side.   Valid operator values are: * &#x60;eq&#x60; - equal to; * &#x60;neq&#x60; - not equal to; * &#x60;gt&#x60; - greater than; * &#x60;gteq&#x60; - greater than or equal to; * &#x60;lt&#x60; - lower than; * &#x60;lteq&#x60; - lower than or equal to; * &#x60;like&#x60;; * &#x60;notLike&#x60;.  &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
     * @param variableNamesIgnoreCase Match the variable name provided in &#x60;taskVariables&#x60; and &#x60;processVariables&#x60; case- insensitively. If set to &#x60;true&#x60; **variableName** and **variablename** are treated as equal. (optional)
     * @param variableValuesIgnoreCase Match the variable value provided in &#x60;taskVariables&#x60; and &#x60;processVariables&#x60; case- insensitively. If set to &#x60;true&#x60; **variableValue** and **variablevalue** are treated as equal. (optional)
     * @param taskInvolvedUser Restrict to tasks with a historic identity link to the given user. (optional)
     * @param taskInvolvedGroup Restrict to tasks with a historic identity link to the given group. (optional)
     * @param taskHadCandidateUser Restrict to tasks with a historic identity link to the given candidate user. (optional)
     * @param taskHadCandidateGroup Restrict to tasks with a historic identity link to the given candidate group. (optional)
     * @param withCandidateGroups Only include tasks which have a candidate group. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param withoutCandidateGroups Only include tasks which have no candidate group. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricTaskInstancesCall(String taskId, String taskParentTaskId, String processInstanceId, String rootProcessInstanceId, String processInstanceBusinessKey, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, String executionId, String processDefinitionId, String processDefinitionKey, String processDefinitionName, String caseInstanceId, String caseExecutionId, String caseDefinitionId, String caseDefinitionKey, String caseDefinitionName, String activityInstanceIdIn, String taskName, String taskNameLike, String taskDescription, String taskDescriptionLike, String taskDefinitionKey, String taskDefinitionKeyIn, String taskDeleteReason, String taskDeleteReasonLike, String taskAssignee, String taskAssigneeLike, String taskOwner, String taskOwnerLike, Integer taskPriority, Boolean assigned, Boolean unassigned, Boolean finished, Boolean unfinished, Boolean processFinished, Boolean processUnfinished, Date taskDueDate, Date taskDueDateBefore, Date taskDueDateAfter, Boolean withoutTaskDueDate, Date taskFollowUpDate, Date taskFollowUpDateBefore, Date taskFollowUpDateAfter, Date startedBefore, Date startedAfter, Date finishedBefore, Date finishedAfter, String tenantIdIn, Boolean withoutTenantId, String taskVariables, String processVariables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String taskInvolvedUser, String taskInvolvedGroup, String taskHadCandidateUser, String taskHadCandidateGroup, Boolean withCandidateGroups, Boolean withoutCandidateGroups, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/history/task";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (taskId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskId", taskId));
        }

        if (taskParentTaskId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskParentTaskId", taskParentTaskId));
        }

        if (processInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processInstanceId", processInstanceId));
        }

        if (rootProcessInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("rootProcessInstanceId", rootProcessInstanceId));
        }

        if (processInstanceBusinessKey != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processInstanceBusinessKey", processInstanceBusinessKey));
        }

        if (processInstanceBusinessKeyIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processInstanceBusinessKeyIn", processInstanceBusinessKeyIn));
        }

        if (processInstanceBusinessKeyLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processInstanceBusinessKeyLike", processInstanceBusinessKeyLike));
        }

        if (executionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("executionId", executionId));
        }

        if (processDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionId", processDefinitionId));
        }

        if (processDefinitionKey != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
        }

        if (processDefinitionName != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionName", processDefinitionName));
        }

        if (caseInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("caseInstanceId", caseInstanceId));
        }

        if (caseExecutionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("caseExecutionId", caseExecutionId));
        }

        if (caseDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("caseDefinitionId", caseDefinitionId));
        }

        if (caseDefinitionKey != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("caseDefinitionKey", caseDefinitionKey));
        }

        if (caseDefinitionName != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("caseDefinitionName", caseDefinitionName));
        }

        if (activityInstanceIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("activityInstanceIdIn", activityInstanceIdIn));
        }

        if (taskName != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskName", taskName));
        }

        if (taskNameLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskNameLike", taskNameLike));
        }

        if (taskDescription != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskDescription", taskDescription));
        }

        if (taskDescriptionLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskDescriptionLike", taskDescriptionLike));
        }

        if (taskDefinitionKey != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskDefinitionKey", taskDefinitionKey));
        }

        if (taskDefinitionKeyIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskDefinitionKeyIn", taskDefinitionKeyIn));
        }

        if (taskDeleteReason != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskDeleteReason", taskDeleteReason));
        }

        if (taskDeleteReasonLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskDeleteReasonLike", taskDeleteReasonLike));
        }

        if (taskAssignee != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskAssignee", taskAssignee));
        }

        if (taskAssigneeLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskAssigneeLike", taskAssigneeLike));
        }

        if (taskOwner != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskOwner", taskOwner));
        }

        if (taskOwnerLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskOwnerLike", taskOwnerLike));
        }

        if (taskPriority != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskPriority", taskPriority));
        }

        if (assigned != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("assigned", assigned));
        }

        if (unassigned != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("unassigned", unassigned));
        }

        if (finished != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("finished", finished));
        }

        if (unfinished != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("unfinished", unfinished));
        }

        if (processFinished != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processFinished", processFinished));
        }

        if (processUnfinished != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processUnfinished", processUnfinished));
        }

        if (taskDueDate != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskDueDate", taskDueDate));
        }

        if (taskDueDateBefore != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskDueDateBefore", taskDueDateBefore));
        }

        if (taskDueDateAfter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskDueDateAfter", taskDueDateAfter));
        }

        if (withoutTaskDueDate != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutTaskDueDate", withoutTaskDueDate));
        }

        if (taskFollowUpDate != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskFollowUpDate", taskFollowUpDate));
        }

        if (taskFollowUpDateBefore != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskFollowUpDateBefore", taskFollowUpDateBefore));
        }

        if (taskFollowUpDateAfter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskFollowUpDateAfter", taskFollowUpDateAfter));
        }

        if (startedBefore != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("startedBefore", startedBefore));
        }

        if (startedAfter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("startedAfter", startedAfter));
        }

        if (finishedBefore != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("finishedBefore", finishedBefore));
        }

        if (finishedAfter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("finishedAfter", finishedAfter));
        }

        if (tenantIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }

        if (withoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }

        if (taskVariables != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskVariables", taskVariables));
        }

        if (processVariables != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processVariables", processVariables));
        }

        if (variableNamesIgnoreCase != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variableNamesIgnoreCase", variableNamesIgnoreCase));
        }

        if (variableValuesIgnoreCase != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variableValuesIgnoreCase", variableValuesIgnoreCase));
        }

        if (taskInvolvedUser != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskInvolvedUser", taskInvolvedUser));
        }

        if (taskInvolvedGroup != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskInvolvedGroup", taskInvolvedGroup));
        }

        if (taskHadCandidateUser != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskHadCandidateUser", taskHadCandidateUser));
        }

        if (taskHadCandidateGroup != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskHadCandidateGroup", taskHadCandidateGroup));
        }

        if (withCandidateGroups != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withCandidateGroups", withCandidateGroups));
        }

        if (withoutCandidateGroups != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutCandidateGroups", withoutCandidateGroups));
        }

        if (sortBy != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortBy", sortBy));
        }

        if (sortOrder != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }

        if (firstResult != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("firstResult", firstResult));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("maxResults", maxResults));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getHistoricTaskInstancesValidateBeforeCall(String taskId, String taskParentTaskId, String processInstanceId, String rootProcessInstanceId, String processInstanceBusinessKey, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, String executionId, String processDefinitionId, String processDefinitionKey, String processDefinitionName, String caseInstanceId, String caseExecutionId, String caseDefinitionId, String caseDefinitionKey, String caseDefinitionName, String activityInstanceIdIn, String taskName, String taskNameLike, String taskDescription, String taskDescriptionLike, String taskDefinitionKey, String taskDefinitionKeyIn, String taskDeleteReason, String taskDeleteReasonLike, String taskAssignee, String taskAssigneeLike, String taskOwner, String taskOwnerLike, Integer taskPriority, Boolean assigned, Boolean unassigned, Boolean finished, Boolean unfinished, Boolean processFinished, Boolean processUnfinished, Date taskDueDate, Date taskDueDateBefore, Date taskDueDateAfter, Boolean withoutTaskDueDate, Date taskFollowUpDate, Date taskFollowUpDateBefore, Date taskFollowUpDateAfter, Date startedBefore, Date startedAfter, Date finishedBefore, Date finishedAfter, String tenantIdIn, Boolean withoutTenantId, String taskVariables, String processVariables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String taskInvolvedUser, String taskInvolvedGroup, String taskHadCandidateUser, String taskHadCandidateGroup, Boolean withCandidateGroups, Boolean withoutCandidateGroups, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getHistoricTaskInstancesCall(taskId, taskParentTaskId, processInstanceId, rootProcessInstanceId, processInstanceBusinessKey, processInstanceBusinessKeyIn, processInstanceBusinessKeyLike, executionId, processDefinitionId, processDefinitionKey, processDefinitionName, caseInstanceId, caseExecutionId, caseDefinitionId, caseDefinitionKey, caseDefinitionName, activityInstanceIdIn, taskName, taskNameLike, taskDescription, taskDescriptionLike, taskDefinitionKey, taskDefinitionKeyIn, taskDeleteReason, taskDeleteReasonLike, taskAssignee, taskAssigneeLike, taskOwner, taskOwnerLike, taskPriority, assigned, unassigned, finished, unfinished, processFinished, processUnfinished, taskDueDate, taskDueDateBefore, taskDueDateAfter, withoutTaskDueDate, taskFollowUpDate, taskFollowUpDateBefore, taskFollowUpDateAfter, startedBefore, startedAfter, finishedBefore, finishedAfter, tenantIdIn, withoutTenantId, taskVariables, processVariables, variableNamesIgnoreCase, variableValuesIgnoreCase, taskInvolvedUser, taskInvolvedGroup, taskHadCandidateUser, taskHadCandidateGroup, withCandidateGroups, withoutCandidateGroups, sortBy, sortOrder, firstResult, maxResults, _callback);
        return localVarCall;

    }

    /**
     * Get Tasks (Historic)
     * Queries for historic tasks that fulfill the given parameters. The size of the result set can be retrieved by using the [Get Task Count](https://docs.camunda.org/manual/7.22/reference/rest/history/task/get-task-query-count/) method.
     * @param taskId Filter by task id. (optional)
     * @param taskParentTaskId Filter by parent task id. (optional)
     * @param processInstanceId Filter by process instance id. (optional)
     * @param rootProcessInstanceId Filter by root process instance id. (optional)
     * @param processInstanceBusinessKey Filter by process instance business key. (optional)
     * @param processInstanceBusinessKeyIn Filter by process instances with one of the give business keys. The keys need to be in a comma-separated list. (optional)
     * @param processInstanceBusinessKeyLike Filter by  process instance business key that has the parameter value as a substring. (optional)
     * @param executionId Filter by the id of the execution that executed the task. (optional)
     * @param processDefinitionId Filter by process definition id. (optional)
     * @param processDefinitionKey Restrict to tasks that belong to a process definition with the given key. (optional)
     * @param processDefinitionName Restrict to tasks that belong to a process definition with the given name. (optional)
     * @param caseInstanceId Filter by case instance id. (optional)
     * @param caseExecutionId Filter by the id of the case execution that executed the task. (optional)
     * @param caseDefinitionId Filter by case definition id. (optional)
     * @param caseDefinitionKey Restrict to tasks that belong to a case definition with the given key. (optional)
     * @param caseDefinitionName Restrict to tasks that belong to a case definition with the given name. (optional)
     * @param activityInstanceIdIn Only include tasks which belong to one of the passed comma-separated activity instance ids. (optional)
     * @param taskName Restrict to tasks that have the given name. (optional)
     * @param taskNameLike Restrict to tasks that have a name with the given parameter value as substring. (optional)
     * @param taskDescription Restrict to tasks that have the given description. (optional)
     * @param taskDescriptionLike Restrict to tasks that have a description that has the parameter value as a substring. (optional)
     * @param taskDefinitionKey Restrict to tasks that have the given key. (optional)
     * @param taskDefinitionKeyIn Restrict to tasks that have one of the passed comma-separated task definition keys. (optional)
     * @param taskDeleteReason Restrict to tasks that have the given delete reason. (optional)
     * @param taskDeleteReasonLike Restrict to tasks that have a delete reason that has the parameter value as a substring. (optional)
     * @param taskAssignee Restrict to tasks that the given user is assigned to. (optional)
     * @param taskAssigneeLike Restrict to tasks that are assigned to users with the parameter value as a substring. (optional)
     * @param taskOwner Restrict to tasks that the given user owns. (optional)
     * @param taskOwnerLike Restrict to tasks that are owned by users with the parameter value as a substring. (optional)
     * @param taskPriority Restrict to tasks that have the given priority. (optional)
     * @param assigned If set to &#x60;true&#x60;, restricts the query to all tasks that are assigned. (optional)
     * @param unassigned If set to &#x60;true&#x60;, restricts the query to all tasks that are unassigned. (optional)
     * @param finished Only include finished tasks. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param unfinished Only include unfinished tasks. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param processFinished Only include tasks of finished processes. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param processUnfinished Only include tasks of unfinished processes. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param taskDueDate Restrict to tasks that are due on the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param taskDueDateBefore Restrict to tasks that are due before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param taskDueDateAfter Restrict to tasks that are due after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param withoutTaskDueDate Only include tasks which have no due date. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param taskFollowUpDate Restrict to tasks that have a followUp date on the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param taskFollowUpDateBefore Restrict to tasks that have a followUp date before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param taskFollowUpDateAfter Restrict to tasks that have a followUp date after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedBefore Restrict to tasks that were started before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedAfter Restrict to tasks that were started after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param finishedBefore Restrict to tasks that were finished before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param finishedAfter Restrict to tasks that were finished after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A task instance must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include historic task instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param taskVariables Only include tasks that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value. **Note:** Values are always treated as &#x60;String&#x60; objects on server side.   Valid operator values are: * &#x60;eq&#x60; - equal to; * &#x60;neq&#x60; - not equal to; * &#x60;gt&#x60; - greater than; * &#x60;gteq&#x60; - greater than or equal to; * &#x60;lt&#x60; - lower than; * &#x60;lteq&#x60; - lower than or equal to; * &#x60;like&#x60;.  &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
     * @param processVariables Only include tasks that belong to process instances that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value. **Note:** Values are always treated as &#x60;String&#x60; objects on server side.   Valid operator values are: * &#x60;eq&#x60; - equal to; * &#x60;neq&#x60; - not equal to; * &#x60;gt&#x60; - greater than; * &#x60;gteq&#x60; - greater than or equal to; * &#x60;lt&#x60; - lower than; * &#x60;lteq&#x60; - lower than or equal to; * &#x60;like&#x60;; * &#x60;notLike&#x60;.  &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
     * @param variableNamesIgnoreCase Match the variable name provided in &#x60;taskVariables&#x60; and &#x60;processVariables&#x60; case- insensitively. If set to &#x60;true&#x60; **variableName** and **variablename** are treated as equal. (optional)
     * @param variableValuesIgnoreCase Match the variable value provided in &#x60;taskVariables&#x60; and &#x60;processVariables&#x60; case- insensitively. If set to &#x60;true&#x60; **variableValue** and **variablevalue** are treated as equal. (optional)
     * @param taskInvolvedUser Restrict to tasks with a historic identity link to the given user. (optional)
     * @param taskInvolvedGroup Restrict to tasks with a historic identity link to the given group. (optional)
     * @param taskHadCandidateUser Restrict to tasks with a historic identity link to the given candidate user. (optional)
     * @param taskHadCandidateGroup Restrict to tasks with a historic identity link to the given candidate group. (optional)
     * @param withCandidateGroups Only include tasks which have a candidate group. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param withoutCandidateGroups Only include tasks which have no candidate group. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @return List&lt;HistoricTaskInstanceDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public List<HistoricTaskInstanceDto> getHistoricTaskInstances(String taskId, String taskParentTaskId, String processInstanceId, String rootProcessInstanceId, String processInstanceBusinessKey, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, String executionId, String processDefinitionId, String processDefinitionKey, String processDefinitionName, String caseInstanceId, String caseExecutionId, String caseDefinitionId, String caseDefinitionKey, String caseDefinitionName, String activityInstanceIdIn, String taskName, String taskNameLike, String taskDescription, String taskDescriptionLike, String taskDefinitionKey, String taskDefinitionKeyIn, String taskDeleteReason, String taskDeleteReasonLike, String taskAssignee, String taskAssigneeLike, String taskOwner, String taskOwnerLike, Integer taskPriority, Boolean assigned, Boolean unassigned, Boolean finished, Boolean unfinished, Boolean processFinished, Boolean processUnfinished, Date taskDueDate, Date taskDueDateBefore, Date taskDueDateAfter, Boolean withoutTaskDueDate, Date taskFollowUpDate, Date taskFollowUpDateBefore, Date taskFollowUpDateAfter, Date startedBefore, Date startedAfter, Date finishedBefore, Date finishedAfter, String tenantIdIn, Boolean withoutTenantId, String taskVariables, String processVariables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String taskInvolvedUser, String taskInvolvedGroup, String taskHadCandidateUser, String taskHadCandidateGroup, Boolean withCandidateGroups, Boolean withoutCandidateGroups, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        ApiResponse<List<HistoricTaskInstanceDto>> localVarResp = getHistoricTaskInstancesWithHttpInfo(taskId, taskParentTaskId, processInstanceId, rootProcessInstanceId, processInstanceBusinessKey, processInstanceBusinessKeyIn, processInstanceBusinessKeyLike, executionId, processDefinitionId, processDefinitionKey, processDefinitionName, caseInstanceId, caseExecutionId, caseDefinitionId, caseDefinitionKey, caseDefinitionName, activityInstanceIdIn, taskName, taskNameLike, taskDescription, taskDescriptionLike, taskDefinitionKey, taskDefinitionKeyIn, taskDeleteReason, taskDeleteReasonLike, taskAssignee, taskAssigneeLike, taskOwner, taskOwnerLike, taskPriority, assigned, unassigned, finished, unfinished, processFinished, processUnfinished, taskDueDate, taskDueDateBefore, taskDueDateAfter, withoutTaskDueDate, taskFollowUpDate, taskFollowUpDateBefore, taskFollowUpDateAfter, startedBefore, startedAfter, finishedBefore, finishedAfter, tenantIdIn, withoutTenantId, taskVariables, processVariables, variableNamesIgnoreCase, variableValuesIgnoreCase, taskInvolvedUser, taskInvolvedGroup, taskHadCandidateUser, taskHadCandidateGroup, withCandidateGroups, withoutCandidateGroups, sortBy, sortOrder, firstResult, maxResults);
        return localVarResp.getData();
    }

    /**
     * Get Tasks (Historic)
     * Queries for historic tasks that fulfill the given parameters. The size of the result set can be retrieved by using the [Get Task Count](https://docs.camunda.org/manual/7.22/reference/rest/history/task/get-task-query-count/) method.
     * @param taskId Filter by task id. (optional)
     * @param taskParentTaskId Filter by parent task id. (optional)
     * @param processInstanceId Filter by process instance id. (optional)
     * @param rootProcessInstanceId Filter by root process instance id. (optional)
     * @param processInstanceBusinessKey Filter by process instance business key. (optional)
     * @param processInstanceBusinessKeyIn Filter by process instances with one of the give business keys. The keys need to be in a comma-separated list. (optional)
     * @param processInstanceBusinessKeyLike Filter by  process instance business key that has the parameter value as a substring. (optional)
     * @param executionId Filter by the id of the execution that executed the task. (optional)
     * @param processDefinitionId Filter by process definition id. (optional)
     * @param processDefinitionKey Restrict to tasks that belong to a process definition with the given key. (optional)
     * @param processDefinitionName Restrict to tasks that belong to a process definition with the given name. (optional)
     * @param caseInstanceId Filter by case instance id. (optional)
     * @param caseExecutionId Filter by the id of the case execution that executed the task. (optional)
     * @param caseDefinitionId Filter by case definition id. (optional)
     * @param caseDefinitionKey Restrict to tasks that belong to a case definition with the given key. (optional)
     * @param caseDefinitionName Restrict to tasks that belong to a case definition with the given name. (optional)
     * @param activityInstanceIdIn Only include tasks which belong to one of the passed comma-separated activity instance ids. (optional)
     * @param taskName Restrict to tasks that have the given name. (optional)
     * @param taskNameLike Restrict to tasks that have a name with the given parameter value as substring. (optional)
     * @param taskDescription Restrict to tasks that have the given description. (optional)
     * @param taskDescriptionLike Restrict to tasks that have a description that has the parameter value as a substring. (optional)
     * @param taskDefinitionKey Restrict to tasks that have the given key. (optional)
     * @param taskDefinitionKeyIn Restrict to tasks that have one of the passed comma-separated task definition keys. (optional)
     * @param taskDeleteReason Restrict to tasks that have the given delete reason. (optional)
     * @param taskDeleteReasonLike Restrict to tasks that have a delete reason that has the parameter value as a substring. (optional)
     * @param taskAssignee Restrict to tasks that the given user is assigned to. (optional)
     * @param taskAssigneeLike Restrict to tasks that are assigned to users with the parameter value as a substring. (optional)
     * @param taskOwner Restrict to tasks that the given user owns. (optional)
     * @param taskOwnerLike Restrict to tasks that are owned by users with the parameter value as a substring. (optional)
     * @param taskPriority Restrict to tasks that have the given priority. (optional)
     * @param assigned If set to &#x60;true&#x60;, restricts the query to all tasks that are assigned. (optional)
     * @param unassigned If set to &#x60;true&#x60;, restricts the query to all tasks that are unassigned. (optional)
     * @param finished Only include finished tasks. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param unfinished Only include unfinished tasks. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param processFinished Only include tasks of finished processes. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param processUnfinished Only include tasks of unfinished processes. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param taskDueDate Restrict to tasks that are due on the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param taskDueDateBefore Restrict to tasks that are due before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param taskDueDateAfter Restrict to tasks that are due after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param withoutTaskDueDate Only include tasks which have no due date. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param taskFollowUpDate Restrict to tasks that have a followUp date on the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param taskFollowUpDateBefore Restrict to tasks that have a followUp date before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param taskFollowUpDateAfter Restrict to tasks that have a followUp date after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedBefore Restrict to tasks that were started before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedAfter Restrict to tasks that were started after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param finishedBefore Restrict to tasks that were finished before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param finishedAfter Restrict to tasks that were finished after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A task instance must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include historic task instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param taskVariables Only include tasks that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value. **Note:** Values are always treated as &#x60;String&#x60; objects on server side.   Valid operator values are: * &#x60;eq&#x60; - equal to; * &#x60;neq&#x60; - not equal to; * &#x60;gt&#x60; - greater than; * &#x60;gteq&#x60; - greater than or equal to; * &#x60;lt&#x60; - lower than; * &#x60;lteq&#x60; - lower than or equal to; * &#x60;like&#x60;.  &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
     * @param processVariables Only include tasks that belong to process instances that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value. **Note:** Values are always treated as &#x60;String&#x60; objects on server side.   Valid operator values are: * &#x60;eq&#x60; - equal to; * &#x60;neq&#x60; - not equal to; * &#x60;gt&#x60; - greater than; * &#x60;gteq&#x60; - greater than or equal to; * &#x60;lt&#x60; - lower than; * &#x60;lteq&#x60; - lower than or equal to; * &#x60;like&#x60;; * &#x60;notLike&#x60;.  &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
     * @param variableNamesIgnoreCase Match the variable name provided in &#x60;taskVariables&#x60; and &#x60;processVariables&#x60; case- insensitively. If set to &#x60;true&#x60; **variableName** and **variablename** are treated as equal. (optional)
     * @param variableValuesIgnoreCase Match the variable value provided in &#x60;taskVariables&#x60; and &#x60;processVariables&#x60; case- insensitively. If set to &#x60;true&#x60; **variableValue** and **variablevalue** are treated as equal. (optional)
     * @param taskInvolvedUser Restrict to tasks with a historic identity link to the given user. (optional)
     * @param taskInvolvedGroup Restrict to tasks with a historic identity link to the given group. (optional)
     * @param taskHadCandidateUser Restrict to tasks with a historic identity link to the given candidate user. (optional)
     * @param taskHadCandidateGroup Restrict to tasks with a historic identity link to the given candidate group. (optional)
     * @param withCandidateGroups Only include tasks which have a candidate group. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param withoutCandidateGroups Only include tasks which have no candidate group. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @return ApiResponse&lt;List&lt;HistoricTaskInstanceDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<HistoricTaskInstanceDto>> getHistoricTaskInstancesWithHttpInfo(String taskId, String taskParentTaskId, String processInstanceId, String rootProcessInstanceId, String processInstanceBusinessKey, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, String executionId, String processDefinitionId, String processDefinitionKey, String processDefinitionName, String caseInstanceId, String caseExecutionId, String caseDefinitionId, String caseDefinitionKey, String caseDefinitionName, String activityInstanceIdIn, String taskName, String taskNameLike, String taskDescription, String taskDescriptionLike, String taskDefinitionKey, String taskDefinitionKeyIn, String taskDeleteReason, String taskDeleteReasonLike, String taskAssignee, String taskAssigneeLike, String taskOwner, String taskOwnerLike, Integer taskPriority, Boolean assigned, Boolean unassigned, Boolean finished, Boolean unfinished, Boolean processFinished, Boolean processUnfinished, Date taskDueDate, Date taskDueDateBefore, Date taskDueDateAfter, Boolean withoutTaskDueDate, Date taskFollowUpDate, Date taskFollowUpDateBefore, Date taskFollowUpDateAfter, Date startedBefore, Date startedAfter, Date finishedBefore, Date finishedAfter, String tenantIdIn, Boolean withoutTenantId, String taskVariables, String processVariables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String taskInvolvedUser, String taskInvolvedGroup, String taskHadCandidateUser, String taskHadCandidateGroup, Boolean withCandidateGroups, Boolean withoutCandidateGroups, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        okhttp3.Call localVarCall = getHistoricTaskInstancesValidateBeforeCall(taskId, taskParentTaskId, processInstanceId, rootProcessInstanceId, processInstanceBusinessKey, processInstanceBusinessKeyIn, processInstanceBusinessKeyLike, executionId, processDefinitionId, processDefinitionKey, processDefinitionName, caseInstanceId, caseExecutionId, caseDefinitionId, caseDefinitionKey, caseDefinitionName, activityInstanceIdIn, taskName, taskNameLike, taskDescription, taskDescriptionLike, taskDefinitionKey, taskDefinitionKeyIn, taskDeleteReason, taskDeleteReasonLike, taskAssignee, taskAssigneeLike, taskOwner, taskOwnerLike, taskPriority, assigned, unassigned, finished, unfinished, processFinished, processUnfinished, taskDueDate, taskDueDateBefore, taskDueDateAfter, withoutTaskDueDate, taskFollowUpDate, taskFollowUpDateBefore, taskFollowUpDateAfter, startedBefore, startedAfter, finishedBefore, finishedAfter, tenantIdIn, withoutTenantId, taskVariables, processVariables, variableNamesIgnoreCase, variableValuesIgnoreCase, taskInvolvedUser, taskInvolvedGroup, taskHadCandidateUser, taskHadCandidateGroup, withCandidateGroups, withoutCandidateGroups, sortBy, sortOrder, firstResult, maxResults, null);
        Type localVarReturnType = new TypeToken<List<HistoricTaskInstanceDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Tasks (Historic) (asynchronously)
     * Queries for historic tasks that fulfill the given parameters. The size of the result set can be retrieved by using the [Get Task Count](https://docs.camunda.org/manual/7.22/reference/rest/history/task/get-task-query-count/) method.
     * @param taskId Filter by task id. (optional)
     * @param taskParentTaskId Filter by parent task id. (optional)
     * @param processInstanceId Filter by process instance id. (optional)
     * @param rootProcessInstanceId Filter by root process instance id. (optional)
     * @param processInstanceBusinessKey Filter by process instance business key. (optional)
     * @param processInstanceBusinessKeyIn Filter by process instances with one of the give business keys. The keys need to be in a comma-separated list. (optional)
     * @param processInstanceBusinessKeyLike Filter by  process instance business key that has the parameter value as a substring. (optional)
     * @param executionId Filter by the id of the execution that executed the task. (optional)
     * @param processDefinitionId Filter by process definition id. (optional)
     * @param processDefinitionKey Restrict to tasks that belong to a process definition with the given key. (optional)
     * @param processDefinitionName Restrict to tasks that belong to a process definition with the given name. (optional)
     * @param caseInstanceId Filter by case instance id. (optional)
     * @param caseExecutionId Filter by the id of the case execution that executed the task. (optional)
     * @param caseDefinitionId Filter by case definition id. (optional)
     * @param caseDefinitionKey Restrict to tasks that belong to a case definition with the given key. (optional)
     * @param caseDefinitionName Restrict to tasks that belong to a case definition with the given name. (optional)
     * @param activityInstanceIdIn Only include tasks which belong to one of the passed comma-separated activity instance ids. (optional)
     * @param taskName Restrict to tasks that have the given name. (optional)
     * @param taskNameLike Restrict to tasks that have a name with the given parameter value as substring. (optional)
     * @param taskDescription Restrict to tasks that have the given description. (optional)
     * @param taskDescriptionLike Restrict to tasks that have a description that has the parameter value as a substring. (optional)
     * @param taskDefinitionKey Restrict to tasks that have the given key. (optional)
     * @param taskDefinitionKeyIn Restrict to tasks that have one of the passed comma-separated task definition keys. (optional)
     * @param taskDeleteReason Restrict to tasks that have the given delete reason. (optional)
     * @param taskDeleteReasonLike Restrict to tasks that have a delete reason that has the parameter value as a substring. (optional)
     * @param taskAssignee Restrict to tasks that the given user is assigned to. (optional)
     * @param taskAssigneeLike Restrict to tasks that are assigned to users with the parameter value as a substring. (optional)
     * @param taskOwner Restrict to tasks that the given user owns. (optional)
     * @param taskOwnerLike Restrict to tasks that are owned by users with the parameter value as a substring. (optional)
     * @param taskPriority Restrict to tasks that have the given priority. (optional)
     * @param assigned If set to &#x60;true&#x60;, restricts the query to all tasks that are assigned. (optional)
     * @param unassigned If set to &#x60;true&#x60;, restricts the query to all tasks that are unassigned. (optional)
     * @param finished Only include finished tasks. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param unfinished Only include unfinished tasks. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param processFinished Only include tasks of finished processes. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param processUnfinished Only include tasks of unfinished processes. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param taskDueDate Restrict to tasks that are due on the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param taskDueDateBefore Restrict to tasks that are due before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param taskDueDateAfter Restrict to tasks that are due after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param withoutTaskDueDate Only include tasks which have no due date. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param taskFollowUpDate Restrict to tasks that have a followUp date on the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param taskFollowUpDateBefore Restrict to tasks that have a followUp date before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param taskFollowUpDateAfter Restrict to tasks that have a followUp date after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedBefore Restrict to tasks that were started before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedAfter Restrict to tasks that were started after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param finishedBefore Restrict to tasks that were finished before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param finishedAfter Restrict to tasks that were finished after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A task instance must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include historic task instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param taskVariables Only include tasks that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value. **Note:** Values are always treated as &#x60;String&#x60; objects on server side.   Valid operator values are: * &#x60;eq&#x60; - equal to; * &#x60;neq&#x60; - not equal to; * &#x60;gt&#x60; - greater than; * &#x60;gteq&#x60; - greater than or equal to; * &#x60;lt&#x60; - lower than; * &#x60;lteq&#x60; - lower than or equal to; * &#x60;like&#x60;.  &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
     * @param processVariables Only include tasks that belong to process instances that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value. **Note:** Values are always treated as &#x60;String&#x60; objects on server side.   Valid operator values are: * &#x60;eq&#x60; - equal to; * &#x60;neq&#x60; - not equal to; * &#x60;gt&#x60; - greater than; * &#x60;gteq&#x60; - greater than or equal to; * &#x60;lt&#x60; - lower than; * &#x60;lteq&#x60; - lower than or equal to; * &#x60;like&#x60;; * &#x60;notLike&#x60;.  &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
     * @param variableNamesIgnoreCase Match the variable name provided in &#x60;taskVariables&#x60; and &#x60;processVariables&#x60; case- insensitively. If set to &#x60;true&#x60; **variableName** and **variablename** are treated as equal. (optional)
     * @param variableValuesIgnoreCase Match the variable value provided in &#x60;taskVariables&#x60; and &#x60;processVariables&#x60; case- insensitively. If set to &#x60;true&#x60; **variableValue** and **variablevalue** are treated as equal. (optional)
     * @param taskInvolvedUser Restrict to tasks with a historic identity link to the given user. (optional)
     * @param taskInvolvedGroup Restrict to tasks with a historic identity link to the given group. (optional)
     * @param taskHadCandidateUser Restrict to tasks with a historic identity link to the given candidate user. (optional)
     * @param taskHadCandidateGroup Restrict to tasks with a historic identity link to the given candidate group. (optional)
     * @param withCandidateGroups Only include tasks which have a candidate group. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param withoutCandidateGroups Only include tasks which have no candidate group. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricTaskInstancesAsync(String taskId, String taskParentTaskId, String processInstanceId, String rootProcessInstanceId, String processInstanceBusinessKey, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, String executionId, String processDefinitionId, String processDefinitionKey, String processDefinitionName, String caseInstanceId, String caseExecutionId, String caseDefinitionId, String caseDefinitionKey, String caseDefinitionName, String activityInstanceIdIn, String taskName, String taskNameLike, String taskDescription, String taskDescriptionLike, String taskDefinitionKey, String taskDefinitionKeyIn, String taskDeleteReason, String taskDeleteReasonLike, String taskAssignee, String taskAssigneeLike, String taskOwner, String taskOwnerLike, Integer taskPriority, Boolean assigned, Boolean unassigned, Boolean finished, Boolean unfinished, Boolean processFinished, Boolean processUnfinished, Date taskDueDate, Date taskDueDateBefore, Date taskDueDateAfter, Boolean withoutTaskDueDate, Date taskFollowUpDate, Date taskFollowUpDateBefore, Date taskFollowUpDateAfter, Date startedBefore, Date startedAfter, Date finishedBefore, Date finishedAfter, String tenantIdIn, Boolean withoutTenantId, String taskVariables, String processVariables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String taskInvolvedUser, String taskInvolvedGroup, String taskHadCandidateUser, String taskHadCandidateGroup, Boolean withCandidateGroups, Boolean withoutCandidateGroups, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback<List<HistoricTaskInstanceDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getHistoricTaskInstancesValidateBeforeCall(taskId, taskParentTaskId, processInstanceId, rootProcessInstanceId, processInstanceBusinessKey, processInstanceBusinessKeyIn, processInstanceBusinessKeyLike, executionId, processDefinitionId, processDefinitionKey, processDefinitionName, caseInstanceId, caseExecutionId, caseDefinitionId, caseDefinitionKey, caseDefinitionName, activityInstanceIdIn, taskName, taskNameLike, taskDescription, taskDescriptionLike, taskDefinitionKey, taskDefinitionKeyIn, taskDeleteReason, taskDeleteReasonLike, taskAssignee, taskAssigneeLike, taskOwner, taskOwnerLike, taskPriority, assigned, unassigned, finished, unfinished, processFinished, processUnfinished, taskDueDate, taskDueDateBefore, taskDueDateAfter, withoutTaskDueDate, taskFollowUpDate, taskFollowUpDateBefore, taskFollowUpDateAfter, startedBefore, startedAfter, finishedBefore, finishedAfter, tenantIdIn, withoutTenantId, taskVariables, processVariables, variableNamesIgnoreCase, variableValuesIgnoreCase, taskInvolvedUser, taskInvolvedGroup, taskHadCandidateUser, taskHadCandidateGroup, withCandidateGroups, withoutCandidateGroups, sortBy, sortOrder, firstResult, maxResults, _callback);
        Type localVarReturnType = new TypeToken<List<HistoricTaskInstanceDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getHistoricTaskInstancesCount
     * @param taskId Filter by task id. (optional)
     * @param taskParentTaskId Filter by parent task id. (optional)
     * @param processInstanceId Filter by process instance id. (optional)
     * @param rootProcessInstanceId Filter by root process instance id. (optional)
     * @param processInstanceBusinessKey Filter by process instance business key. (optional)
     * @param processInstanceBusinessKeyIn Filter by process instances with one of the give business keys. The keys need to be in a comma-separated list. (optional)
     * @param processInstanceBusinessKeyLike Filter by  process instance business key that has the parameter value as a substring. (optional)
     * @param executionId Filter by the id of the execution that executed the task. (optional)
     * @param processDefinitionId Filter by process definition id. (optional)
     * @param processDefinitionKey Restrict to tasks that belong to a process definition with the given key. (optional)
     * @param processDefinitionName Restrict to tasks that belong to a process definition with the given name. (optional)
     * @param caseInstanceId Filter by case instance id. (optional)
     * @param caseExecutionId Filter by the id of the case execution that executed the task. (optional)
     * @param caseDefinitionId Filter by case definition id. (optional)
     * @param caseDefinitionKey Restrict to tasks that belong to a case definition with the given key. (optional)
     * @param caseDefinitionName Restrict to tasks that belong to a case definition with the given name. (optional)
     * @param activityInstanceIdIn Only include tasks which belong to one of the passed comma-separated activity instance ids. (optional)
     * @param taskName Restrict to tasks that have the given name. (optional)
     * @param taskNameLike Restrict to tasks that have a name with the given parameter value as substring. (optional)
     * @param taskDescription Restrict to tasks that have the given description. (optional)
     * @param taskDescriptionLike Restrict to tasks that have a description that has the parameter value as a substring. (optional)
     * @param taskDefinitionKey Restrict to tasks that have the given key. (optional)
     * @param taskDefinitionKeyIn Restrict to tasks that have one of the passed comma-separated task definition keys. (optional)
     * @param taskDeleteReason Restrict to tasks that have the given delete reason. (optional)
     * @param taskDeleteReasonLike Restrict to tasks that have a delete reason that has the parameter value as a substring. (optional)
     * @param taskAssignee Restrict to tasks that the given user is assigned to. (optional)
     * @param taskAssigneeLike Restrict to tasks that are assigned to users with the parameter value as a substring. (optional)
     * @param taskOwner Restrict to tasks that the given user owns. (optional)
     * @param taskOwnerLike Restrict to tasks that are owned by users with the parameter value as a substring. (optional)
     * @param taskPriority Restrict to tasks that have the given priority. (optional)
     * @param assigned If set to &#x60;true&#x60;, restricts the query to all tasks that are assigned. (optional)
     * @param unassigned If set to &#x60;true&#x60;, restricts the query to all tasks that are unassigned. (optional)
     * @param finished Only include finished tasks. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param unfinished Only include unfinished tasks. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param processFinished Only include tasks of finished processes. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param processUnfinished Only include tasks of unfinished processes. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param taskDueDate Restrict to tasks that are due on the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param taskDueDateBefore Restrict to tasks that are due before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param taskDueDateAfter Restrict to tasks that are due after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param withoutTaskDueDate Only include tasks which have no due date. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param taskFollowUpDate Restrict to tasks that have a followUp date on the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param taskFollowUpDateBefore Restrict to tasks that have a followUp date before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param taskFollowUpDateAfter Restrict to tasks that have a followUp date after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedBefore Restrict to tasks that were started before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedAfter Restrict to tasks that were started after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param finishedBefore Restrict to tasks that were finished before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param finishedAfter Restrict to tasks that were finished after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A task instance must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include historic task instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param taskVariables Only include tasks that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value. **Note:** Values are always treated as &#x60;String&#x60; objects on server side.   Valid operator values are: * &#x60;eq&#x60; - equal to; * &#x60;neq&#x60; - not equal to; * &#x60;gt&#x60; - greater than; * &#x60;gteq&#x60; - greater than or equal to; * &#x60;lt&#x60; - lower than; * &#x60;lteq&#x60; - lower than or equal to; * &#x60;like&#x60;.  &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
     * @param processVariables Only include tasks that belong to process instances that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value. **Note:** Values are always treated as &#x60;String&#x60; objects on server side.   Valid operator values are: * &#x60;eq&#x60; - equal to; * &#x60;neq&#x60; - not equal to; * &#x60;gt&#x60; - greater than; * &#x60;gteq&#x60; - greater than or equal to; * &#x60;lt&#x60; - lower than; * &#x60;lteq&#x60; - lower than or equal to; * &#x60;like&#x60;; * &#x60;notLike&#x60;.  &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
     * @param variableNamesIgnoreCase Match the variable name provided in &#x60;taskVariables&#x60; and &#x60;processVariables&#x60; case- insensitively. If set to &#x60;true&#x60; **variableName** and **variablename** are treated as equal. (optional)
     * @param variableValuesIgnoreCase Match the variable value provided in &#x60;taskVariables&#x60; and &#x60;processVariables&#x60; case- insensitively. If set to &#x60;true&#x60; **variableValue** and **variablevalue** are treated as equal. (optional)
     * @param taskInvolvedUser Restrict to tasks with a historic identity link to the given user. (optional)
     * @param taskInvolvedGroup Restrict to tasks with a historic identity link to the given group. (optional)
     * @param taskHadCandidateUser Restrict to tasks with a historic identity link to the given candidate user. (optional)
     * @param taskHadCandidateGroup Restrict to tasks with a historic identity link to the given candidate group. (optional)
     * @param withCandidateGroups Only include tasks which have a candidate group. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param withoutCandidateGroups Only include tasks which have no candidate group. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricTaskInstancesCountCall(String taskId, String taskParentTaskId, String processInstanceId, String rootProcessInstanceId, String processInstanceBusinessKey, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, String executionId, String processDefinitionId, String processDefinitionKey, String processDefinitionName, String caseInstanceId, String caseExecutionId, String caseDefinitionId, String caseDefinitionKey, String caseDefinitionName, String activityInstanceIdIn, String taskName, String taskNameLike, String taskDescription, String taskDescriptionLike, String taskDefinitionKey, String taskDefinitionKeyIn, String taskDeleteReason, String taskDeleteReasonLike, String taskAssignee, String taskAssigneeLike, String taskOwner, String taskOwnerLike, Integer taskPriority, Boolean assigned, Boolean unassigned, Boolean finished, Boolean unfinished, Boolean processFinished, Boolean processUnfinished, Date taskDueDate, Date taskDueDateBefore, Date taskDueDateAfter, Boolean withoutTaskDueDate, Date taskFollowUpDate, Date taskFollowUpDateBefore, Date taskFollowUpDateAfter, Date startedBefore, Date startedAfter, Date finishedBefore, Date finishedAfter, String tenantIdIn, Boolean withoutTenantId, String taskVariables, String processVariables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String taskInvolvedUser, String taskInvolvedGroup, String taskHadCandidateUser, String taskHadCandidateGroup, Boolean withCandidateGroups, Boolean withoutCandidateGroups, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/history/task/count";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (taskId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskId", taskId));
        }

        if (taskParentTaskId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskParentTaskId", taskParentTaskId));
        }

        if (processInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processInstanceId", processInstanceId));
        }

        if (rootProcessInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("rootProcessInstanceId", rootProcessInstanceId));
        }

        if (processInstanceBusinessKey != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processInstanceBusinessKey", processInstanceBusinessKey));
        }

        if (processInstanceBusinessKeyIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processInstanceBusinessKeyIn", processInstanceBusinessKeyIn));
        }

        if (processInstanceBusinessKeyLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processInstanceBusinessKeyLike", processInstanceBusinessKeyLike));
        }

        if (executionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("executionId", executionId));
        }

        if (processDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionId", processDefinitionId));
        }

        if (processDefinitionKey != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
        }

        if (processDefinitionName != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionName", processDefinitionName));
        }

        if (caseInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("caseInstanceId", caseInstanceId));
        }

        if (caseExecutionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("caseExecutionId", caseExecutionId));
        }

        if (caseDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("caseDefinitionId", caseDefinitionId));
        }

        if (caseDefinitionKey != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("caseDefinitionKey", caseDefinitionKey));
        }

        if (caseDefinitionName != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("caseDefinitionName", caseDefinitionName));
        }

        if (activityInstanceIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("activityInstanceIdIn", activityInstanceIdIn));
        }

        if (taskName != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskName", taskName));
        }

        if (taskNameLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskNameLike", taskNameLike));
        }

        if (taskDescription != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskDescription", taskDescription));
        }

        if (taskDescriptionLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskDescriptionLike", taskDescriptionLike));
        }

        if (taskDefinitionKey != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskDefinitionKey", taskDefinitionKey));
        }

        if (taskDefinitionKeyIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskDefinitionKeyIn", taskDefinitionKeyIn));
        }

        if (taskDeleteReason != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskDeleteReason", taskDeleteReason));
        }

        if (taskDeleteReasonLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskDeleteReasonLike", taskDeleteReasonLike));
        }

        if (taskAssignee != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskAssignee", taskAssignee));
        }

        if (taskAssigneeLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskAssigneeLike", taskAssigneeLike));
        }

        if (taskOwner != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskOwner", taskOwner));
        }

        if (taskOwnerLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskOwnerLike", taskOwnerLike));
        }

        if (taskPriority != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskPriority", taskPriority));
        }

        if (assigned != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("assigned", assigned));
        }

        if (unassigned != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("unassigned", unassigned));
        }

        if (finished != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("finished", finished));
        }

        if (unfinished != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("unfinished", unfinished));
        }

        if (processFinished != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processFinished", processFinished));
        }

        if (processUnfinished != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processUnfinished", processUnfinished));
        }

        if (taskDueDate != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskDueDate", taskDueDate));
        }

        if (taskDueDateBefore != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskDueDateBefore", taskDueDateBefore));
        }

        if (taskDueDateAfter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskDueDateAfter", taskDueDateAfter));
        }

        if (withoutTaskDueDate != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutTaskDueDate", withoutTaskDueDate));
        }

        if (taskFollowUpDate != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskFollowUpDate", taskFollowUpDate));
        }

        if (taskFollowUpDateBefore != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskFollowUpDateBefore", taskFollowUpDateBefore));
        }

        if (taskFollowUpDateAfter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskFollowUpDateAfter", taskFollowUpDateAfter));
        }

        if (startedBefore != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("startedBefore", startedBefore));
        }

        if (startedAfter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("startedAfter", startedAfter));
        }

        if (finishedBefore != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("finishedBefore", finishedBefore));
        }

        if (finishedAfter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("finishedAfter", finishedAfter));
        }

        if (tenantIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }

        if (withoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }

        if (taskVariables != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskVariables", taskVariables));
        }

        if (processVariables != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processVariables", processVariables));
        }

        if (variableNamesIgnoreCase != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variableNamesIgnoreCase", variableNamesIgnoreCase));
        }

        if (variableValuesIgnoreCase != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variableValuesIgnoreCase", variableValuesIgnoreCase));
        }

        if (taskInvolvedUser != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskInvolvedUser", taskInvolvedUser));
        }

        if (taskInvolvedGroup != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskInvolvedGroup", taskInvolvedGroup));
        }

        if (taskHadCandidateUser != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskHadCandidateUser", taskHadCandidateUser));
        }

        if (taskHadCandidateGroup != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskHadCandidateGroup", taskHadCandidateGroup));
        }

        if (withCandidateGroups != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withCandidateGroups", withCandidateGroups));
        }

        if (withoutCandidateGroups != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutCandidateGroups", withoutCandidateGroups));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getHistoricTaskInstancesCountValidateBeforeCall(String taskId, String taskParentTaskId, String processInstanceId, String rootProcessInstanceId, String processInstanceBusinessKey, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, String executionId, String processDefinitionId, String processDefinitionKey, String processDefinitionName, String caseInstanceId, String caseExecutionId, String caseDefinitionId, String caseDefinitionKey, String caseDefinitionName, String activityInstanceIdIn, String taskName, String taskNameLike, String taskDescription, String taskDescriptionLike, String taskDefinitionKey, String taskDefinitionKeyIn, String taskDeleteReason, String taskDeleteReasonLike, String taskAssignee, String taskAssigneeLike, String taskOwner, String taskOwnerLike, Integer taskPriority, Boolean assigned, Boolean unassigned, Boolean finished, Boolean unfinished, Boolean processFinished, Boolean processUnfinished, Date taskDueDate, Date taskDueDateBefore, Date taskDueDateAfter, Boolean withoutTaskDueDate, Date taskFollowUpDate, Date taskFollowUpDateBefore, Date taskFollowUpDateAfter, Date startedBefore, Date startedAfter, Date finishedBefore, Date finishedAfter, String tenantIdIn, Boolean withoutTenantId, String taskVariables, String processVariables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String taskInvolvedUser, String taskInvolvedGroup, String taskHadCandidateUser, String taskHadCandidateGroup, Boolean withCandidateGroups, Boolean withoutCandidateGroups, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getHistoricTaskInstancesCountCall(taskId, taskParentTaskId, processInstanceId, rootProcessInstanceId, processInstanceBusinessKey, processInstanceBusinessKeyIn, processInstanceBusinessKeyLike, executionId, processDefinitionId, processDefinitionKey, processDefinitionName, caseInstanceId, caseExecutionId, caseDefinitionId, caseDefinitionKey, caseDefinitionName, activityInstanceIdIn, taskName, taskNameLike, taskDescription, taskDescriptionLike, taskDefinitionKey, taskDefinitionKeyIn, taskDeleteReason, taskDeleteReasonLike, taskAssignee, taskAssigneeLike, taskOwner, taskOwnerLike, taskPriority, assigned, unassigned, finished, unfinished, processFinished, processUnfinished, taskDueDate, taskDueDateBefore, taskDueDateAfter, withoutTaskDueDate, taskFollowUpDate, taskFollowUpDateBefore, taskFollowUpDateAfter, startedBefore, startedAfter, finishedBefore, finishedAfter, tenantIdIn, withoutTenantId, taskVariables, processVariables, variableNamesIgnoreCase, variableValuesIgnoreCase, taskInvolvedUser, taskInvolvedGroup, taskHadCandidateUser, taskHadCandidateGroup, withCandidateGroups, withoutCandidateGroups, _callback);
        return localVarCall;

    }

    /**
     * Get Task Count
     * Queries for the number of historic tasks that fulfill the given parameters. Takes the same parameters as the [Get Tasks (Historic)](https://docs.camunda.org/manual/7.22/reference/rest/history/task/get-task-query/) method.
     * @param taskId Filter by task id. (optional)
     * @param taskParentTaskId Filter by parent task id. (optional)
     * @param processInstanceId Filter by process instance id. (optional)
     * @param rootProcessInstanceId Filter by root process instance id. (optional)
     * @param processInstanceBusinessKey Filter by process instance business key. (optional)
     * @param processInstanceBusinessKeyIn Filter by process instances with one of the give business keys. The keys need to be in a comma-separated list. (optional)
     * @param processInstanceBusinessKeyLike Filter by  process instance business key that has the parameter value as a substring. (optional)
     * @param executionId Filter by the id of the execution that executed the task. (optional)
     * @param processDefinitionId Filter by process definition id. (optional)
     * @param processDefinitionKey Restrict to tasks that belong to a process definition with the given key. (optional)
     * @param processDefinitionName Restrict to tasks that belong to a process definition with the given name. (optional)
     * @param caseInstanceId Filter by case instance id. (optional)
     * @param caseExecutionId Filter by the id of the case execution that executed the task. (optional)
     * @param caseDefinitionId Filter by case definition id. (optional)
     * @param caseDefinitionKey Restrict to tasks that belong to a case definition with the given key. (optional)
     * @param caseDefinitionName Restrict to tasks that belong to a case definition with the given name. (optional)
     * @param activityInstanceIdIn Only include tasks which belong to one of the passed comma-separated activity instance ids. (optional)
     * @param taskName Restrict to tasks that have the given name. (optional)
     * @param taskNameLike Restrict to tasks that have a name with the given parameter value as substring. (optional)
     * @param taskDescription Restrict to tasks that have the given description. (optional)
     * @param taskDescriptionLike Restrict to tasks that have a description that has the parameter value as a substring. (optional)
     * @param taskDefinitionKey Restrict to tasks that have the given key. (optional)
     * @param taskDefinitionKeyIn Restrict to tasks that have one of the passed comma-separated task definition keys. (optional)
     * @param taskDeleteReason Restrict to tasks that have the given delete reason. (optional)
     * @param taskDeleteReasonLike Restrict to tasks that have a delete reason that has the parameter value as a substring. (optional)
     * @param taskAssignee Restrict to tasks that the given user is assigned to. (optional)
     * @param taskAssigneeLike Restrict to tasks that are assigned to users with the parameter value as a substring. (optional)
     * @param taskOwner Restrict to tasks that the given user owns. (optional)
     * @param taskOwnerLike Restrict to tasks that are owned by users with the parameter value as a substring. (optional)
     * @param taskPriority Restrict to tasks that have the given priority. (optional)
     * @param assigned If set to &#x60;true&#x60;, restricts the query to all tasks that are assigned. (optional)
     * @param unassigned If set to &#x60;true&#x60;, restricts the query to all tasks that are unassigned. (optional)
     * @param finished Only include finished tasks. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param unfinished Only include unfinished tasks. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param processFinished Only include tasks of finished processes. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param processUnfinished Only include tasks of unfinished processes. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param taskDueDate Restrict to tasks that are due on the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param taskDueDateBefore Restrict to tasks that are due before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param taskDueDateAfter Restrict to tasks that are due after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param withoutTaskDueDate Only include tasks which have no due date. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param taskFollowUpDate Restrict to tasks that have a followUp date on the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param taskFollowUpDateBefore Restrict to tasks that have a followUp date before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param taskFollowUpDateAfter Restrict to tasks that have a followUp date after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedBefore Restrict to tasks that were started before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedAfter Restrict to tasks that were started after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param finishedBefore Restrict to tasks that were finished before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param finishedAfter Restrict to tasks that were finished after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A task instance must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include historic task instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param taskVariables Only include tasks that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value. **Note:** Values are always treated as &#x60;String&#x60; objects on server side.   Valid operator values are: * &#x60;eq&#x60; - equal to; * &#x60;neq&#x60; - not equal to; * &#x60;gt&#x60; - greater than; * &#x60;gteq&#x60; - greater than or equal to; * &#x60;lt&#x60; - lower than; * &#x60;lteq&#x60; - lower than or equal to; * &#x60;like&#x60;.  &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
     * @param processVariables Only include tasks that belong to process instances that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value. **Note:** Values are always treated as &#x60;String&#x60; objects on server side.   Valid operator values are: * &#x60;eq&#x60; - equal to; * &#x60;neq&#x60; - not equal to; * &#x60;gt&#x60; - greater than; * &#x60;gteq&#x60; - greater than or equal to; * &#x60;lt&#x60; - lower than; * &#x60;lteq&#x60; - lower than or equal to; * &#x60;like&#x60;; * &#x60;notLike&#x60;.  &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
     * @param variableNamesIgnoreCase Match the variable name provided in &#x60;taskVariables&#x60; and &#x60;processVariables&#x60; case- insensitively. If set to &#x60;true&#x60; **variableName** and **variablename** are treated as equal. (optional)
     * @param variableValuesIgnoreCase Match the variable value provided in &#x60;taskVariables&#x60; and &#x60;processVariables&#x60; case- insensitively. If set to &#x60;true&#x60; **variableValue** and **variablevalue** are treated as equal. (optional)
     * @param taskInvolvedUser Restrict to tasks with a historic identity link to the given user. (optional)
     * @param taskInvolvedGroup Restrict to tasks with a historic identity link to the given group. (optional)
     * @param taskHadCandidateUser Restrict to tasks with a historic identity link to the given candidate user. (optional)
     * @param taskHadCandidateGroup Restrict to tasks with a historic identity link to the given candidate group. (optional)
     * @param withCandidateGroups Only include tasks which have a candidate group. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param withoutCandidateGroups Only include tasks which have no candidate group. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @return CountResultDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public CountResultDto getHistoricTaskInstancesCount(String taskId, String taskParentTaskId, String processInstanceId, String rootProcessInstanceId, String processInstanceBusinessKey, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, String executionId, String processDefinitionId, String processDefinitionKey, String processDefinitionName, String caseInstanceId, String caseExecutionId, String caseDefinitionId, String caseDefinitionKey, String caseDefinitionName, String activityInstanceIdIn, String taskName, String taskNameLike, String taskDescription, String taskDescriptionLike, String taskDefinitionKey, String taskDefinitionKeyIn, String taskDeleteReason, String taskDeleteReasonLike, String taskAssignee, String taskAssigneeLike, String taskOwner, String taskOwnerLike, Integer taskPriority, Boolean assigned, Boolean unassigned, Boolean finished, Boolean unfinished, Boolean processFinished, Boolean processUnfinished, Date taskDueDate, Date taskDueDateBefore, Date taskDueDateAfter, Boolean withoutTaskDueDate, Date taskFollowUpDate, Date taskFollowUpDateBefore, Date taskFollowUpDateAfter, Date startedBefore, Date startedAfter, Date finishedBefore, Date finishedAfter, String tenantIdIn, Boolean withoutTenantId, String taskVariables, String processVariables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String taskInvolvedUser, String taskInvolvedGroup, String taskHadCandidateUser, String taskHadCandidateGroup, Boolean withCandidateGroups, Boolean withoutCandidateGroups) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = getHistoricTaskInstancesCountWithHttpInfo(taskId, taskParentTaskId, processInstanceId, rootProcessInstanceId, processInstanceBusinessKey, processInstanceBusinessKeyIn, processInstanceBusinessKeyLike, executionId, processDefinitionId, processDefinitionKey, processDefinitionName, caseInstanceId, caseExecutionId, caseDefinitionId, caseDefinitionKey, caseDefinitionName, activityInstanceIdIn, taskName, taskNameLike, taskDescription, taskDescriptionLike, taskDefinitionKey, taskDefinitionKeyIn, taskDeleteReason, taskDeleteReasonLike, taskAssignee, taskAssigneeLike, taskOwner, taskOwnerLike, taskPriority, assigned, unassigned, finished, unfinished, processFinished, processUnfinished, taskDueDate, taskDueDateBefore, taskDueDateAfter, withoutTaskDueDate, taskFollowUpDate, taskFollowUpDateBefore, taskFollowUpDateAfter, startedBefore, startedAfter, finishedBefore, finishedAfter, tenantIdIn, withoutTenantId, taskVariables, processVariables, variableNamesIgnoreCase, variableValuesIgnoreCase, taskInvolvedUser, taskInvolvedGroup, taskHadCandidateUser, taskHadCandidateGroup, withCandidateGroups, withoutCandidateGroups);
        return localVarResp.getData();
    }

    /**
     * Get Task Count
     * Queries for the number of historic tasks that fulfill the given parameters. Takes the same parameters as the [Get Tasks (Historic)](https://docs.camunda.org/manual/7.22/reference/rest/history/task/get-task-query/) method.
     * @param taskId Filter by task id. (optional)
     * @param taskParentTaskId Filter by parent task id. (optional)
     * @param processInstanceId Filter by process instance id. (optional)
     * @param rootProcessInstanceId Filter by root process instance id. (optional)
     * @param processInstanceBusinessKey Filter by process instance business key. (optional)
     * @param processInstanceBusinessKeyIn Filter by process instances with one of the give business keys. The keys need to be in a comma-separated list. (optional)
     * @param processInstanceBusinessKeyLike Filter by  process instance business key that has the parameter value as a substring. (optional)
     * @param executionId Filter by the id of the execution that executed the task. (optional)
     * @param processDefinitionId Filter by process definition id. (optional)
     * @param processDefinitionKey Restrict to tasks that belong to a process definition with the given key. (optional)
     * @param processDefinitionName Restrict to tasks that belong to a process definition with the given name. (optional)
     * @param caseInstanceId Filter by case instance id. (optional)
     * @param caseExecutionId Filter by the id of the case execution that executed the task. (optional)
     * @param caseDefinitionId Filter by case definition id. (optional)
     * @param caseDefinitionKey Restrict to tasks that belong to a case definition with the given key. (optional)
     * @param caseDefinitionName Restrict to tasks that belong to a case definition with the given name. (optional)
     * @param activityInstanceIdIn Only include tasks which belong to one of the passed comma-separated activity instance ids. (optional)
     * @param taskName Restrict to tasks that have the given name. (optional)
     * @param taskNameLike Restrict to tasks that have a name with the given parameter value as substring. (optional)
     * @param taskDescription Restrict to tasks that have the given description. (optional)
     * @param taskDescriptionLike Restrict to tasks that have a description that has the parameter value as a substring. (optional)
     * @param taskDefinitionKey Restrict to tasks that have the given key. (optional)
     * @param taskDefinitionKeyIn Restrict to tasks that have one of the passed comma-separated task definition keys. (optional)
     * @param taskDeleteReason Restrict to tasks that have the given delete reason. (optional)
     * @param taskDeleteReasonLike Restrict to tasks that have a delete reason that has the parameter value as a substring. (optional)
     * @param taskAssignee Restrict to tasks that the given user is assigned to. (optional)
     * @param taskAssigneeLike Restrict to tasks that are assigned to users with the parameter value as a substring. (optional)
     * @param taskOwner Restrict to tasks that the given user owns. (optional)
     * @param taskOwnerLike Restrict to tasks that are owned by users with the parameter value as a substring. (optional)
     * @param taskPriority Restrict to tasks that have the given priority. (optional)
     * @param assigned If set to &#x60;true&#x60;, restricts the query to all tasks that are assigned. (optional)
     * @param unassigned If set to &#x60;true&#x60;, restricts the query to all tasks that are unassigned. (optional)
     * @param finished Only include finished tasks. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param unfinished Only include unfinished tasks. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param processFinished Only include tasks of finished processes. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param processUnfinished Only include tasks of unfinished processes. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param taskDueDate Restrict to tasks that are due on the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param taskDueDateBefore Restrict to tasks that are due before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param taskDueDateAfter Restrict to tasks that are due after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param withoutTaskDueDate Only include tasks which have no due date. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param taskFollowUpDate Restrict to tasks that have a followUp date on the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param taskFollowUpDateBefore Restrict to tasks that have a followUp date before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param taskFollowUpDateAfter Restrict to tasks that have a followUp date after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedBefore Restrict to tasks that were started before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedAfter Restrict to tasks that were started after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param finishedBefore Restrict to tasks that were finished before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param finishedAfter Restrict to tasks that were finished after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A task instance must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include historic task instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param taskVariables Only include tasks that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value. **Note:** Values are always treated as &#x60;String&#x60; objects on server side.   Valid operator values are: * &#x60;eq&#x60; - equal to; * &#x60;neq&#x60; - not equal to; * &#x60;gt&#x60; - greater than; * &#x60;gteq&#x60; - greater than or equal to; * &#x60;lt&#x60; - lower than; * &#x60;lteq&#x60; - lower than or equal to; * &#x60;like&#x60;.  &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
     * @param processVariables Only include tasks that belong to process instances that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value. **Note:** Values are always treated as &#x60;String&#x60; objects on server side.   Valid operator values are: * &#x60;eq&#x60; - equal to; * &#x60;neq&#x60; - not equal to; * &#x60;gt&#x60; - greater than; * &#x60;gteq&#x60; - greater than or equal to; * &#x60;lt&#x60; - lower than; * &#x60;lteq&#x60; - lower than or equal to; * &#x60;like&#x60;; * &#x60;notLike&#x60;.  &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
     * @param variableNamesIgnoreCase Match the variable name provided in &#x60;taskVariables&#x60; and &#x60;processVariables&#x60; case- insensitively. If set to &#x60;true&#x60; **variableName** and **variablename** are treated as equal. (optional)
     * @param variableValuesIgnoreCase Match the variable value provided in &#x60;taskVariables&#x60; and &#x60;processVariables&#x60; case- insensitively. If set to &#x60;true&#x60; **variableValue** and **variablevalue** are treated as equal. (optional)
     * @param taskInvolvedUser Restrict to tasks with a historic identity link to the given user. (optional)
     * @param taskInvolvedGroup Restrict to tasks with a historic identity link to the given group. (optional)
     * @param taskHadCandidateUser Restrict to tasks with a historic identity link to the given candidate user. (optional)
     * @param taskHadCandidateGroup Restrict to tasks with a historic identity link to the given candidate group. (optional)
     * @param withCandidateGroups Only include tasks which have a candidate group. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param withoutCandidateGroups Only include tasks which have no candidate group. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @return ApiResponse&lt;CountResultDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CountResultDto> getHistoricTaskInstancesCountWithHttpInfo(String taskId, String taskParentTaskId, String processInstanceId, String rootProcessInstanceId, String processInstanceBusinessKey, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, String executionId, String processDefinitionId, String processDefinitionKey, String processDefinitionName, String caseInstanceId, String caseExecutionId, String caseDefinitionId, String caseDefinitionKey, String caseDefinitionName, String activityInstanceIdIn, String taskName, String taskNameLike, String taskDescription, String taskDescriptionLike, String taskDefinitionKey, String taskDefinitionKeyIn, String taskDeleteReason, String taskDeleteReasonLike, String taskAssignee, String taskAssigneeLike, String taskOwner, String taskOwnerLike, Integer taskPriority, Boolean assigned, Boolean unassigned, Boolean finished, Boolean unfinished, Boolean processFinished, Boolean processUnfinished, Date taskDueDate, Date taskDueDateBefore, Date taskDueDateAfter, Boolean withoutTaskDueDate, Date taskFollowUpDate, Date taskFollowUpDateBefore, Date taskFollowUpDateAfter, Date startedBefore, Date startedAfter, Date finishedBefore, Date finishedAfter, String tenantIdIn, Boolean withoutTenantId, String taskVariables, String processVariables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String taskInvolvedUser, String taskInvolvedGroup, String taskHadCandidateUser, String taskHadCandidateGroup, Boolean withCandidateGroups, Boolean withoutCandidateGroups) throws ApiException {
        okhttp3.Call localVarCall = getHistoricTaskInstancesCountValidateBeforeCall(taskId, taskParentTaskId, processInstanceId, rootProcessInstanceId, processInstanceBusinessKey, processInstanceBusinessKeyIn, processInstanceBusinessKeyLike, executionId, processDefinitionId, processDefinitionKey, processDefinitionName, caseInstanceId, caseExecutionId, caseDefinitionId, caseDefinitionKey, caseDefinitionName, activityInstanceIdIn, taskName, taskNameLike, taskDescription, taskDescriptionLike, taskDefinitionKey, taskDefinitionKeyIn, taskDeleteReason, taskDeleteReasonLike, taskAssignee, taskAssigneeLike, taskOwner, taskOwnerLike, taskPriority, assigned, unassigned, finished, unfinished, processFinished, processUnfinished, taskDueDate, taskDueDateBefore, taskDueDateAfter, withoutTaskDueDate, taskFollowUpDate, taskFollowUpDateBefore, taskFollowUpDateAfter, startedBefore, startedAfter, finishedBefore, finishedAfter, tenantIdIn, withoutTenantId, taskVariables, processVariables, variableNamesIgnoreCase, variableValuesIgnoreCase, taskInvolvedUser, taskInvolvedGroup, taskHadCandidateUser, taskHadCandidateGroup, withCandidateGroups, withoutCandidateGroups, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Task Count (asynchronously)
     * Queries for the number of historic tasks that fulfill the given parameters. Takes the same parameters as the [Get Tasks (Historic)](https://docs.camunda.org/manual/7.22/reference/rest/history/task/get-task-query/) method.
     * @param taskId Filter by task id. (optional)
     * @param taskParentTaskId Filter by parent task id. (optional)
     * @param processInstanceId Filter by process instance id. (optional)
     * @param rootProcessInstanceId Filter by root process instance id. (optional)
     * @param processInstanceBusinessKey Filter by process instance business key. (optional)
     * @param processInstanceBusinessKeyIn Filter by process instances with one of the give business keys. The keys need to be in a comma-separated list. (optional)
     * @param processInstanceBusinessKeyLike Filter by  process instance business key that has the parameter value as a substring. (optional)
     * @param executionId Filter by the id of the execution that executed the task. (optional)
     * @param processDefinitionId Filter by process definition id. (optional)
     * @param processDefinitionKey Restrict to tasks that belong to a process definition with the given key. (optional)
     * @param processDefinitionName Restrict to tasks that belong to a process definition with the given name. (optional)
     * @param caseInstanceId Filter by case instance id. (optional)
     * @param caseExecutionId Filter by the id of the case execution that executed the task. (optional)
     * @param caseDefinitionId Filter by case definition id. (optional)
     * @param caseDefinitionKey Restrict to tasks that belong to a case definition with the given key. (optional)
     * @param caseDefinitionName Restrict to tasks that belong to a case definition with the given name. (optional)
     * @param activityInstanceIdIn Only include tasks which belong to one of the passed comma-separated activity instance ids. (optional)
     * @param taskName Restrict to tasks that have the given name. (optional)
     * @param taskNameLike Restrict to tasks that have a name with the given parameter value as substring. (optional)
     * @param taskDescription Restrict to tasks that have the given description. (optional)
     * @param taskDescriptionLike Restrict to tasks that have a description that has the parameter value as a substring. (optional)
     * @param taskDefinitionKey Restrict to tasks that have the given key. (optional)
     * @param taskDefinitionKeyIn Restrict to tasks that have one of the passed comma-separated task definition keys. (optional)
     * @param taskDeleteReason Restrict to tasks that have the given delete reason. (optional)
     * @param taskDeleteReasonLike Restrict to tasks that have a delete reason that has the parameter value as a substring. (optional)
     * @param taskAssignee Restrict to tasks that the given user is assigned to. (optional)
     * @param taskAssigneeLike Restrict to tasks that are assigned to users with the parameter value as a substring. (optional)
     * @param taskOwner Restrict to tasks that the given user owns. (optional)
     * @param taskOwnerLike Restrict to tasks that are owned by users with the parameter value as a substring. (optional)
     * @param taskPriority Restrict to tasks that have the given priority. (optional)
     * @param assigned If set to &#x60;true&#x60;, restricts the query to all tasks that are assigned. (optional)
     * @param unassigned If set to &#x60;true&#x60;, restricts the query to all tasks that are unassigned. (optional)
     * @param finished Only include finished tasks. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param unfinished Only include unfinished tasks. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param processFinished Only include tasks of finished processes. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param processUnfinished Only include tasks of unfinished processes. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param taskDueDate Restrict to tasks that are due on the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param taskDueDateBefore Restrict to tasks that are due before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param taskDueDateAfter Restrict to tasks that are due after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param withoutTaskDueDate Only include tasks which have no due date. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param taskFollowUpDate Restrict to tasks that have a followUp date on the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param taskFollowUpDateBefore Restrict to tasks that have a followUp date before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param taskFollowUpDateAfter Restrict to tasks that have a followUp date after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedBefore Restrict to tasks that were started before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedAfter Restrict to tasks that were started after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param finishedBefore Restrict to tasks that were finished before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param finishedAfter Restrict to tasks that were finished after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A task instance must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include historic task instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param taskVariables Only include tasks that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value. **Note:** Values are always treated as &#x60;String&#x60; objects on server side.   Valid operator values are: * &#x60;eq&#x60; - equal to; * &#x60;neq&#x60; - not equal to; * &#x60;gt&#x60; - greater than; * &#x60;gteq&#x60; - greater than or equal to; * &#x60;lt&#x60; - lower than; * &#x60;lteq&#x60; - lower than or equal to; * &#x60;like&#x60;.  &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
     * @param processVariables Only include tasks that belong to process instances that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value. **Note:** Values are always treated as &#x60;String&#x60; objects on server side.   Valid operator values are: * &#x60;eq&#x60; - equal to; * &#x60;neq&#x60; - not equal to; * &#x60;gt&#x60; - greater than; * &#x60;gteq&#x60; - greater than or equal to; * &#x60;lt&#x60; - lower than; * &#x60;lteq&#x60; - lower than or equal to; * &#x60;like&#x60;; * &#x60;notLike&#x60;.  &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
     * @param variableNamesIgnoreCase Match the variable name provided in &#x60;taskVariables&#x60; and &#x60;processVariables&#x60; case- insensitively. If set to &#x60;true&#x60; **variableName** and **variablename** are treated as equal. (optional)
     * @param variableValuesIgnoreCase Match the variable value provided in &#x60;taskVariables&#x60; and &#x60;processVariables&#x60; case- insensitively. If set to &#x60;true&#x60; **variableValue** and **variablevalue** are treated as equal. (optional)
     * @param taskInvolvedUser Restrict to tasks with a historic identity link to the given user. (optional)
     * @param taskInvolvedGroup Restrict to tasks with a historic identity link to the given group. (optional)
     * @param taskHadCandidateUser Restrict to tasks with a historic identity link to the given candidate user. (optional)
     * @param taskHadCandidateGroup Restrict to tasks with a historic identity link to the given candidate group. (optional)
     * @param withCandidateGroups Only include tasks which have a candidate group. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param withoutCandidateGroups Only include tasks which have no candidate group. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricTaskInstancesCountAsync(String taskId, String taskParentTaskId, String processInstanceId, String rootProcessInstanceId, String processInstanceBusinessKey, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, String executionId, String processDefinitionId, String processDefinitionKey, String processDefinitionName, String caseInstanceId, String caseExecutionId, String caseDefinitionId, String caseDefinitionKey, String caseDefinitionName, String activityInstanceIdIn, String taskName, String taskNameLike, String taskDescription, String taskDescriptionLike, String taskDefinitionKey, String taskDefinitionKeyIn, String taskDeleteReason, String taskDeleteReasonLike, String taskAssignee, String taskAssigneeLike, String taskOwner, String taskOwnerLike, Integer taskPriority, Boolean assigned, Boolean unassigned, Boolean finished, Boolean unfinished, Boolean processFinished, Boolean processUnfinished, Date taskDueDate, Date taskDueDateBefore, Date taskDueDateAfter, Boolean withoutTaskDueDate, Date taskFollowUpDate, Date taskFollowUpDateBefore, Date taskFollowUpDateAfter, Date startedBefore, Date startedAfter, Date finishedBefore, Date finishedAfter, String tenantIdIn, Boolean withoutTenantId, String taskVariables, String processVariables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String taskInvolvedUser, String taskInvolvedGroup, String taskHadCandidateUser, String taskHadCandidateGroup, Boolean withCandidateGroups, Boolean withoutCandidateGroups, final ApiCallback<CountResultDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getHistoricTaskInstancesCountValidateBeforeCall(taskId, taskParentTaskId, processInstanceId, rootProcessInstanceId, processInstanceBusinessKey, processInstanceBusinessKeyIn, processInstanceBusinessKeyLike, executionId, processDefinitionId, processDefinitionKey, processDefinitionName, caseInstanceId, caseExecutionId, caseDefinitionId, caseDefinitionKey, caseDefinitionName, activityInstanceIdIn, taskName, taskNameLike, taskDescription, taskDescriptionLike, taskDefinitionKey, taskDefinitionKeyIn, taskDeleteReason, taskDeleteReasonLike, taskAssignee, taskAssigneeLike, taskOwner, taskOwnerLike, taskPriority, assigned, unassigned, finished, unfinished, processFinished, processUnfinished, taskDueDate, taskDueDateBefore, taskDueDateAfter, withoutTaskDueDate, taskFollowUpDate, taskFollowUpDateBefore, taskFollowUpDateAfter, startedBefore, startedAfter, finishedBefore, finishedAfter, tenantIdIn, withoutTenantId, taskVariables, processVariables, variableNamesIgnoreCase, variableValuesIgnoreCase, taskInvolvedUser, taskInvolvedGroup, taskHadCandidateUser, taskHadCandidateGroup, withCandidateGroups, withoutCandidateGroups, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for queryHistoricTaskInstances
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param historicTaskInstanceQueryDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryHistoricTaskInstancesCall(Integer firstResult, Integer maxResults, HistoricTaskInstanceQueryDto historicTaskInstanceQueryDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = historicTaskInstanceQueryDto;

        // create path and map variables
        String localVarPath = "/history/task";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (firstResult != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("firstResult", firstResult));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("maxResults", maxResults));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call queryHistoricTaskInstancesValidateBeforeCall(Integer firstResult, Integer maxResults, HistoricTaskInstanceQueryDto historicTaskInstanceQueryDto, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = queryHistoricTaskInstancesCall(firstResult, maxResults, historicTaskInstanceQueryDto, _callback);
        return localVarCall;

    }

    /**
     * Get Tasks (Historic) (POST)
     * Queries for historic tasks that fulfill the given parameters. This method is slightly more powerful than the [Get Tasks (Historic)](https://docs.camunda.org/manual/7.22/reference/rest/history/task/get-task-query/) method because it allows filtering by multiple process or task variables of types &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;. The size of the result set can be retrieved by using the [Get Task Count (POST)](https://docs.camunda.org/manual/7.22/reference/rest/history/task/post-task-query-count/) method.
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param historicTaskInstanceQueryDto  (optional)
     * @return List&lt;HistoricTaskInstanceDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public List<HistoricTaskInstanceDto> queryHistoricTaskInstances(Integer firstResult, Integer maxResults, HistoricTaskInstanceQueryDto historicTaskInstanceQueryDto) throws ApiException {
        ApiResponse<List<HistoricTaskInstanceDto>> localVarResp = queryHistoricTaskInstancesWithHttpInfo(firstResult, maxResults, historicTaskInstanceQueryDto);
        return localVarResp.getData();
    }

    /**
     * Get Tasks (Historic) (POST)
     * Queries for historic tasks that fulfill the given parameters. This method is slightly more powerful than the [Get Tasks (Historic)](https://docs.camunda.org/manual/7.22/reference/rest/history/task/get-task-query/) method because it allows filtering by multiple process or task variables of types &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;. The size of the result set can be retrieved by using the [Get Task Count (POST)](https://docs.camunda.org/manual/7.22/reference/rest/history/task/post-task-query-count/) method.
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param historicTaskInstanceQueryDto  (optional)
     * @return ApiResponse&lt;List&lt;HistoricTaskInstanceDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<HistoricTaskInstanceDto>> queryHistoricTaskInstancesWithHttpInfo(Integer firstResult, Integer maxResults, HistoricTaskInstanceQueryDto historicTaskInstanceQueryDto) throws ApiException {
        okhttp3.Call localVarCall = queryHistoricTaskInstancesValidateBeforeCall(firstResult, maxResults, historicTaskInstanceQueryDto, null);
        Type localVarReturnType = new TypeToken<List<HistoricTaskInstanceDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Tasks (Historic) (POST) (asynchronously)
     * Queries for historic tasks that fulfill the given parameters. This method is slightly more powerful than the [Get Tasks (Historic)](https://docs.camunda.org/manual/7.22/reference/rest/history/task/get-task-query/) method because it allows filtering by multiple process or task variables of types &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;. The size of the result set can be retrieved by using the [Get Task Count (POST)](https://docs.camunda.org/manual/7.22/reference/rest/history/task/post-task-query-count/) method.
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param historicTaskInstanceQueryDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryHistoricTaskInstancesAsync(Integer firstResult, Integer maxResults, HistoricTaskInstanceQueryDto historicTaskInstanceQueryDto, final ApiCallback<List<HistoricTaskInstanceDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = queryHistoricTaskInstancesValidateBeforeCall(firstResult, maxResults, historicTaskInstanceQueryDto, _callback);
        Type localVarReturnType = new TypeToken<List<HistoricTaskInstanceDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for queryHistoricTaskInstancesCount
     * @param historicTaskInstanceQueryDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryHistoricTaskInstancesCountCall(HistoricTaskInstanceQueryDto historicTaskInstanceQueryDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = historicTaskInstanceQueryDto;

        // create path and map variables
        String localVarPath = "/history/task/count";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call queryHistoricTaskInstancesCountValidateBeforeCall(HistoricTaskInstanceQueryDto historicTaskInstanceQueryDto, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = queryHistoricTaskInstancesCountCall(historicTaskInstanceQueryDto, _callback);
        return localVarCall;

    }

    /**
     * Get Task Count (POST)
     * Queries for the number of historic tasks that fulfill the given parameters. Takes the same parameters as the [Get Tasks (Historic)](https://docs.camunda.org/manual/7.22/reference/rest/history/task/get-task-query/) method. Corresponds to the size of the result set of the [Get Tasks (Historic) (POST)](https://docs.camunda.org/manual/7.22/reference/rest/history/task/post-task-query/) method and takes the same parameters.
     * @param historicTaskInstanceQueryDto  (optional)
     * @return CountResultDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public CountResultDto queryHistoricTaskInstancesCount(HistoricTaskInstanceQueryDto historicTaskInstanceQueryDto) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = queryHistoricTaskInstancesCountWithHttpInfo(historicTaskInstanceQueryDto);
        return localVarResp.getData();
    }

    /**
     * Get Task Count (POST)
     * Queries for the number of historic tasks that fulfill the given parameters. Takes the same parameters as the [Get Tasks (Historic)](https://docs.camunda.org/manual/7.22/reference/rest/history/task/get-task-query/) method. Corresponds to the size of the result set of the [Get Tasks (Historic) (POST)](https://docs.camunda.org/manual/7.22/reference/rest/history/task/post-task-query/) method and takes the same parameters.
     * @param historicTaskInstanceQueryDto  (optional)
     * @return ApiResponse&lt;CountResultDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CountResultDto> queryHistoricTaskInstancesCountWithHttpInfo(HistoricTaskInstanceQueryDto historicTaskInstanceQueryDto) throws ApiException {
        okhttp3.Call localVarCall = queryHistoricTaskInstancesCountValidateBeforeCall(historicTaskInstanceQueryDto, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Task Count (POST) (asynchronously)
     * Queries for the number of historic tasks that fulfill the given parameters. Takes the same parameters as the [Get Tasks (Historic)](https://docs.camunda.org/manual/7.22/reference/rest/history/task/get-task-query/) method. Corresponds to the size of the result set of the [Get Tasks (Historic) (POST)](https://docs.camunda.org/manual/7.22/reference/rest/history/task/post-task-query/) method and takes the same parameters.
     * @param historicTaskInstanceQueryDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryHistoricTaskInstancesCountAsync(HistoricTaskInstanceQueryDto historicTaskInstanceQueryDto, final ApiCallback<CountResultDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = queryHistoricTaskInstancesCountValidateBeforeCall(historicTaskInstanceQueryDto, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
