/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.openapi.generator.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.ValidationMessage;
import java.io.File;
import java.util.Set;
import java.util.stream.Collectors;

public class SchemaValidator {
    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            throw new RuntimeException("Must provide two arguments: <json schema> <file to validate>");
        }
        String jsonSchemaPath = args[0];
        String inputFile = args[1];
        ObjectMapper mapper = new ObjectMapper();
        JsonNode schemaNode = mapper.readTree(new File(jsonSchemaPath));
        JsonNode inputNode = mapper.readTree(new File(inputFile));
        JsonSchemaFactory factory = JsonSchemaFactory.getInstance();
        JsonSchema schema = factory.getSchema(schemaNode);
        Set errors = schema.validate(inputNode);
        if (errors.size() > 0) {
            String messages = errors.stream().map(ValidationMessage::getMessage).collect(Collectors.joining("\n"));
            throw new RuntimeException("Schema validation errors\n" + messages);
        }
    }
}

