/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.lorenz.merge;

import java.util.Objects;
import org.cadixdev.lorenz.MappingSet;

public class MergeContext {
    private final MappingSet left;
    private final MappingSet right;
    private MappingSet leftReversed;
    private MappingSet rightReversed;

    public MergeContext(MappingSet left, MappingSet right) {
        this.left = Objects.requireNonNull(left, "Left MappingSet may not be null");
        this.right = Objects.requireNonNull(right, "Right MappingSet may not be null");
    }

    public MappingSet getLeft() {
        return this.left;
    }

    public MappingSet getRight() {
        return this.right;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MappingSet getLeftReversed() {
        MappingSet ctx = this.leftReversed;
        if (ctx != null) {
            return ctx;
        }
        MappingSet mappingSet = this.left;
        synchronized (mappingSet) {
            ctx = this.leftReversed;
            if (ctx != null) {
                return ctx;
            }
            ctx = this.leftReversed = this.left.reverse();
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MappingSet getRightReversed() {
        MappingSet ctx = this.rightReversed;
        if (ctx != null) {
            return ctx;
        }
        MappingSet mappingSet = this.right;
        synchronized (mappingSet) {
            ctx = this.rightReversed;
            if (ctx != null) {
                return ctx;
            }
            ctx = this.rightReversed = this.right.reverse();
        }
        return ctx;
    }
}

