/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.bombe.analysis;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.cadixdev.bombe.analysis.InheritanceType;
import org.cadixdev.bombe.analysis.LazyInheritanceClassInfo;
import org.cadixdev.bombe.type.signature.FieldSignature;
import org.cadixdev.bombe.type.signature.MethodSignature;

public interface InheritanceProvider {
    public Optional<ClassInfo> provide(String var1);

    default public Optional<ClassInfo> provide(String klass, Object context) {
        return this.provide(klass);
    }

    public static interface ClassInfo {
        public String getName();

        default public String getPackage() {
            String name = this.getName();
            int classIndex = name.lastIndexOf(47);
            return classIndex >= 0 ? name.substring(0, classIndex) : "";
        }

        public boolean isInterface();

        public String getSuperName();

        public List<String> getInterfaces();

        public Map<FieldSignature, InheritanceType> getFields();

        public Map<String, InheritanceType> getFieldsByName();

        public Map<MethodSignature, InheritanceType> getMethods();

        default public Set<ClassInfo> provideParents(InheritanceProvider provider) {
            HashSet<ClassInfo> result = new HashSet<ClassInfo>();
            this.provideParents(provider, result);
            return Collections.unmodifiableSet(result);
        }

        default public void provideParents(InheritanceProvider provider, Collection<ClassInfo> parents) {
            provider.provide(this.getSuperName()).ifPresent(p -> {
                parents.add((ClassInfo)p);
                p.provideParents(provider, parents);
            });
            for (String iface : this.getInterfaces()) {
                provider.provide(iface).ifPresent(p -> {
                    parents.add((ClassInfo)p);
                    p.provideParents(provider, parents);
                });
            }
        }

        default public boolean hasParent(String klass, InheritanceProvider provider) {
            return this.provideParents(provider).stream().map(ClassInfo::getName).anyMatch(Predicate.isEqual(klass));
        }

        default public boolean hasParent(ClassInfo info, InheritanceProvider provider) {
            return this.provideParents(provider).contains(info);
        }

        default public InheritanceType getField(FieldSignature field) {
            if (!field.getType().isPresent()) {
                return this.getFieldsByName().getOrDefault(field.getName(), InheritanceType.NONE);
            }
            return this.getFields().getOrDefault(field, InheritanceType.NONE);
        }

        default public InheritanceType getMethod(MethodSignature method) {
            return this.getMethods().getOrDefault(method, InheritanceType.NONE);
        }

        default public boolean canInherit(ClassInfo child, FieldSignature field) {
            return this.getField(field).canInherit(this, child);
        }

        default public boolean canInherit(ClassInfo child, MethodSignature method) {
            return this.getMethod(method).canInherit(this, child);
        }

        default public boolean overrides(MethodSignature method, ClassInfo parent) {
            InheritanceType own = this.getMethods().getOrDefault(method, InheritanceType.NONE);
            if (own == InheritanceType.NONE) {
                return false;
            }
            InheritanceType parentType = parent.getMethods().getOrDefault(method, InheritanceType.NONE);
            return own.compareTo(parentType) >= 0 && parentType.canInherit(parent, this);
        }

        default public ClassInfo lazy() {
            return new LazyInheritanceClassInfo(this);
        }

        public static class Impl
        extends Abstract
        implements ClassInfo {
            protected final String name;
            protected final boolean isInterface;
            protected final String superName;
            protected final List<String> interfaces;
            protected final Map<FieldSignature, InheritanceType> fields;
            protected final Map<String, InheritanceType> fieldsByName;
            protected final Map<MethodSignature, InheritanceType> methods;
            protected Set<ClassInfo> parents;

            public Impl(String name, boolean isInterface, String superName, List<String> interfaces, Map<FieldSignature, InheritanceType> fields, Map<String, InheritanceType> fieldsByName, Map<MethodSignature, InheritanceType> methods) {
                this.name = name;
                this.isInterface = isInterface;
                this.superName = superName != null ? superName : "";
                this.interfaces = Collections.unmodifiableList(interfaces);
                this.fields = Collections.unmodifiableMap(fields);
                this.fieldsByName = Collections.unmodifiableMap(fieldsByName);
                this.methods = Collections.unmodifiableMap(methods);
            }

            @Override
            public String getName() {
                return this.name;
            }

            @Override
            public boolean isInterface() {
                return this.isInterface;
            }

            @Override
            public String getSuperName() {
                return this.superName;
            }

            @Override
            public List<String> getInterfaces() {
                return this.interfaces;
            }

            @Override
            public Map<FieldSignature, InheritanceType> getFields() {
                return this.fields;
            }

            @Override
            public Map<String, InheritanceType> getFieldsByName() {
                return this.fieldsByName;
            }

            @Override
            public Map<MethodSignature, InheritanceType> getMethods() {
                return this.methods;
            }

            @Override
            public Set<ClassInfo> provideParents(InheritanceProvider provider) {
                if (this.parents == null) {
                    this.parents = new HashSet<ClassInfo>();
                    ClassInfo.super.provideParents(provider, this.parents);
                }
                return this.parents;
            }

            @Override
            public void provideParents(InheritanceProvider provider, Collection<ClassInfo> parents) {
                parents.addAll(this.provideParents(provider));
            }

            @Override
            public ClassInfo lazy() {
                return this;
            }
        }

        public static abstract class Abstract
        implements ClassInfo {
            public final boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof InheritanceProvider)) {
                    return false;
                }
                ClassInfo that = (ClassInfo)o;
                return Objects.equals(this.getName(), that.getName());
            }

            public final int hashCode() {
                return this.getName().hashCode();
            }

            public String toString() {
                return "ClassInfo{name='" + this.getName() + '\'' + ", interface=" + this.isInterface() + ", superName='" + this.getSuperName() + '\'' + ", interfaces=" + this.getInterfaces() + ", fields=" + this.getFields() + ", methods=" + this.getMethods() + '}';
            }
        }
    }
}

