/*
 * Decompiled with CFR 0.152.
 */
package org.butterfaces.component.renderkit.html_basic.text;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UINamingContainer;
import javax.faces.component.html.HtmlInputTextarea;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.butterfaces.component.base.renderer.HtmlBasicInputRenderer;
import org.butterfaces.component.html.HtmlCheckBox;
import org.butterfaces.component.html.HtmlInputComponent;
import org.butterfaces.component.html.HtmlTooltip;
import org.butterfaces.component.html.InputComponentFacet;
import org.butterfaces.component.html.text.part.HtmlAutoComplete;
import org.butterfaces.component.partrenderer.InnerComponentWrapperPartRenderer;
import org.butterfaces.component.partrenderer.LabelPartRenderer;
import org.butterfaces.component.partrenderer.OuterComponentWrapperPartRenderer;
import org.butterfaces.component.partrenderer.ReadonlyPartRenderer;
import org.butterfaces.component.partrenderer.TooltipValidationRenderer;
import org.butterfaces.util.StringJoiner;

public abstract class AbstractHtmlTagRenderer<T extends HtmlInputComponent>
extends HtmlBasicInputRenderer {
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.encodeBegin(context, component, "");
    }

    public void encodeBegin(FacesContext context, UIComponent component, String additionalStyleClass) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        super.encodeBegin(context, component);
        HtmlInputComponent htmlComponent = (HtmlInputComponent)component;
        ResponseWriter writer = context.getResponseWriter();
        new OuterComponentWrapperPartRenderer().renderComponentBegin(component, writer, additionalStyleClass);
        this.appendEncodeBegin(htmlComponent, writer);
        new LabelPartRenderer().renderLabel(component, writer, this.createInputClientId(context, component));
        this.encodeBeginInnerWrapper(component, writer);
        this.encodeReadonly(htmlComponent, writer);
    }

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        HtmlInputComponent htmlComponent = (HtmlInputComponent)component;
        ResponseWriter writer = context.getResponseWriter();
        if (!htmlComponent.isReadonly()) {
            this.encodeEndContent(context, component, htmlComponent, writer);
        }
        this.encodeInnerEnd(component, writer);
        this.encodeEndInnerWrapper(component, writer);
        this.renderTooltipIfNecessary(context, component);
        this.encodeEnd(htmlComponent, writer);
        new OuterComponentWrapperPartRenderer().renderComponentEnd(writer);
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected String getHtmlTagName() {
        return "input";
    }

    protected void renderTooltipIfNecessary(FacesContext context, UIComponent component) throws IOException {
        for (UIComponent uiComponent : component.getChildren()) {
            if (!(uiComponent instanceof HtmlTooltip)) continue;
            uiComponent.encodeAll(context);
            if (!uiComponent.isRendered()) continue;
            break;
        }
        new TooltipValidationRenderer().renderTooltipIfNecessary(context, component);
    }

    protected void appendEncodeBegin(T component, ResponseWriter writer) throws IOException {
    }

    protected void encodeEndContent(FacesContext context, UIComponent component, HtmlInputComponent htmlComponent, ResponseWriter writer) throws IOException {
        UIComponent inputGroupAddonLeftFacet = component.getFacet("input-group-addon-left");
        UIComponent inputGroupAddonRightFacet = component.getFacet("input-group-addon-right");
        UIComponent inputGroupBtnLeftFacet = component.getFacet("input-group-btn-left");
        UIComponent inputGroupBtnRightFacet = component.getFacet("input-group-btn-right");
        if (htmlComponent.getSupportedFacets().contains((Object)InputComponentFacet.BOOTSTRAP_INPUT_GROUP_LEFT_ADDON) && inputGroupAddonLeftFacet != null) {
            writer.startElement("div", component);
            writer.writeAttribute("class", (Object)"input-group-prepend", null);
            writer.startElement("span", component);
            writer.writeAttribute("class", (Object)"input-group-text", null);
            inputGroupAddonLeftFacet.encodeAll(context);
            writer.endElement("span");
            writer.endElement("div");
        } else if (htmlComponent.getSupportedFacets().contains((Object)InputComponentFacet.BOOTSTRAP_INPUT_GROUP_LEFT_BTN) && inputGroupBtnLeftFacet != null) {
            writer.startElement("div", component);
            writer.writeAttribute("class", (Object)"input-group-prepend", null);
            inputGroupBtnLeftFacet.encodeAll(context);
            writer.endElement("div");
        }
        super.encodeEnd(context, component);
        this.postEncodeInput(context, component);
        if (htmlComponent.getSupportedFacets().contains((Object)InputComponentFacet.BOOTSTRAP_INPUT_GROUP_LEFT_ADDON) && inputGroupAddonRightFacet != null) {
            writer.startElement("div", component);
            writer.writeAttribute("class", (Object)"input-group-append", null);
            writer.startElement("span", component);
            writer.writeAttribute("class", (Object)"input-group-text", null);
            inputGroupAddonRightFacet.encodeAll(context);
            writer.endElement("span");
            writer.endElement("div");
        } else if (htmlComponent.getSupportedFacets().contains((Object)InputComponentFacet.BOOTSTRAP_INPUT_GROUP_LEFT_BTN) && inputGroupBtnRightFacet != null) {
            writer.startElement("div", component);
            writer.writeAttribute("class", (Object)"input-group-append", null);
            inputGroupBtnRightFacet.encodeAll(context);
            writer.endElement("div");
        }
    }

    protected void postEncodeInput(FacesContext context, UIComponent component) throws IOException {
    }

    protected boolean encodeReadonly() {
        return true;
    }

    protected void encodeReadonly(T htmlComponent, ResponseWriter writer) throws IOException {
        if (this.encodeReadonly()) {
            new ReadonlyPartRenderer().renderReadonly((HtmlInputComponent)htmlComponent, writer);
        }
    }

    protected void encodeEndInnerWrapper(UIComponent component, ResponseWriter writer) throws IOException {
        new InnerComponentWrapperPartRenderer().renderInnerWrapperEnd(component, writer);
    }

    protected void encodeBeginInnerWrapper(UIComponent component, ResponseWriter writer) throws IOException {
        new InnerComponentWrapperPartRenderer().renderInnerWrapperBegin(component, writer);
    }

    protected void encodeInnerEnd(UIComponent component, ResponseWriter writer) throws IOException {
    }

    protected void encodeEnd(T component, ResponseWriter writer) throws IOException {
    }

    protected void encodeSuperEnd(FacesContext context, UIComponent component) throws IOException {
        super.encodeEnd(context, component);
    }

    @Override
    protected void getEndTextToRender(FacesContext context, UIComponent component, String currentValue) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (component instanceof UIInput) {
            writer.startElement(this.getHtmlTagName(), component);
            writer.writeAttribute("id", (Object)this.createInputClientId(context, component), "clientId");
            writer.writeAttribute("name", (Object)component.getClientId(context), "clientId");
            if (!(component instanceof HtmlInputTextarea) && !(component instanceof HtmlCheckBox) && currentValue != null) {
                writer.writeAttribute("value", (Object)currentValue, "value");
            }
            this.renderBooleanValue(component, writer, "disabled");
            this.renderBooleanValue(component, writer, "ismap");
            this.renderBooleanValue(component, writer, "readonly");
            this.renderStringValue(component, writer, "autocomplete", "off");
            this.renderStringValue(component, writer, "placeholder");
            this.renderBooleanValue(component, writer, "autoFocus");
            this.renderBooleanValue(component, writer, "pattern");
            this.renderStringValue(component, writer, "min");
            this.renderStringValue(component, writer, "max");
            this.renderStringValue(component, writer, "alt");
            this.renderStringValue(component, writer, "dir");
            this.renderStringValue(component, writer, "lang");
            this.renderStringValue(component, writer, "maxlength");
            this.renderStringValue(component, writer, "role");
            this.renderStringValue(component, writer, "size");
            this.renderStringValue(component, writer, "style");
            this.renderStringValue(component, writer, "tabindex");
            this.renderStringValue(component, writer, "title");
            this.renderEventValue(component, writer, "onblur", "blur");
            this.renderEventValue(component, writer, "onclick", "click");
            this.renderEventValue(component, writer, "ondblclick", "dblclick");
            this.renderEventValue(component, writer, "onfocus", "focus");
            this.renderEventValue(component, writer, "onkeydown", "keydown");
            this.renderEventValue(component, writer, "onkeypress", "keypress");
            this.renderEventValue(component, writer, "onkeyup", "keyup");
            this.renderEventValue(component, writer, "onmousedown", "mousedown");
            this.renderEventValue(component, writer, "onmousemove", "mousemove");
            this.renderEventValue(component, writer, "onmouseout", "mouseout");
            this.renderEventValue(component, writer, "onmouseover", "mouseover");
            this.renderEventValue(component, writer, "onmouseup", "mouseup");
            this.renderEventValue(component, writer, "onselect", "select");
            this.renderEventValue(component, writer, "onchange", "change");
            this.renderInputStyleClass((HtmlInputComponent)component, writer);
            this.encodeTagType(component, writer);
            this.encodeAdditionalTagAttributes(component, writer, currentValue);
            this.renderAdditionalInputAttributes(context, component, writer);
            if (component instanceof HtmlInputTextarea && currentValue != null) {
                writer.writeText((Object)currentValue, null);
            }
            writer.endElement(this.getHtmlTagName());
        }
    }

    protected String createInputClientId(FacesContext context, UIComponent component) {
        char separatorChar = UINamingContainer.getSeparatorChar((FacesContext)FacesContext.getCurrentInstance());
        return component.getClientId(context) + separatorChar + "inner";
    }

    protected void encodeTagType(UIComponent component, ResponseWriter writer) throws IOException {
        this.renderStringValue(component, writer, "type");
    }

    protected void encodeAdditionalTagAttributes(UIComponent component, ResponseWriter writer, String currentValue) throws IOException {
    }

    protected void renderInputStyleClass(HtmlInputComponent component, ResponseWriter writer) throws IOException {
        String validationMarkerClass = !component.isValid() ? "butter-component-invalid is-invalid" : null;
        String styleClass = StringJoiner.on(" ").join("butter-input-component").join("form-control").join(validationMarkerClass).toString();
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
    }

    protected void renderAdditionalInputAttributes(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
    }

    @Override
    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        if (component.getChildCount() > 0) {
            for (UIComponent child : component.getChildren()) {
                if (child instanceof HtmlTooltip || child instanceof HtmlAutoComplete) continue;
                this.encodeRecursive(context, child);
            }
        }
    }
}

