/*
 * Decompiled with CFR 0.152.
 */
package org.butterfaces.component.renderkit.html_basic;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;
import org.butterfaces.component.base.renderer.HtmlBasicRenderer;
import org.butterfaces.component.html.HtmlModalPanel;
import org.butterfaces.util.StringUtils;

@FacesRenderer(componentFamily="org.butterfaces.component.family", rendererType="org.butterfaces.component.renderkit.html_basic.ModalPanelRenderer")
public class ModalPanelRenderer
extends HtmlBasicRenderer {
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        HtmlModalPanel modalPanel = (HtmlModalPanel)component;
        writer.startElement("div", component);
        this.writeIdAttribute(context, writer, component);
        if (StringUtils.isNotEmpty(modalPanel.getStyleClass())) {
            writer.writeAttribute("class", (Object)("butter-modal modal fade " + modalPanel.getStyleClass()), null);
        } else {
            writer.writeAttribute("class", (Object)"butter-modal modal fade", null);
        }
        if (StringUtils.isNotEmpty(modalPanel.getStyle())) {
            writer.writeAttribute("style", (Object)modalPanel.getStyle(), null);
        }
        writer.writeAttribute("tabindex", (Object)"-1", null);
        writer.writeAttribute("role", (Object)"dialog", null);
        writer.writeAttribute("aria-hidden", (Object)"true", null);
        writer.writeAttribute("data-modal-id", (Object)component.getId(), null);
        writer.startElement("div", component);
        writer.writeAttribute("class", (Object)"modal-dialog", null);
        writer.startElement("div", component);
        writer.writeAttribute("class", (Object)"modal-content", null);
        this.writerHeader(modalPanel, context);
        writer.startElement("div", component);
        writer.writeAttribute("class", (Object)"modal-body", null);
    }

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        HtmlModalPanel modalPanel = (HtmlModalPanel)component;
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("div");
        this.writeFooter(modalPanel, context);
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        if (StringUtils.isNotEmpty(modalPanel.getOnShow()) || StringUtils.isNotEmpty(modalPanel.getOnShown()) || StringUtils.isNotEmpty(modalPanel.getOnHide()) || StringUtils.isNotEmpty(modalPanel.getOnHidden())) {
            writer.startElement("script", component);
            this.encodePopoverEvent(modalPanel.getOnShow(), "show.bs.modal", component, writer);
            this.encodePopoverEvent(modalPanel.getOnShown(), "shown.bs.modal", component, writer);
            this.encodePopoverEvent(modalPanel.getOnHide(), "hide.bs.modal", component, writer);
            this.encodePopoverEvent(modalPanel.getOnHidden(), "hidden.bs.modal", component, writer);
            writer.endElement("script");
        }
    }

    private void encodePopoverEvent(String function, String event, UIComponent component, ResponseWriter writer) throws IOException {
        if (StringUtils.isNotEmpty(function)) {
            writer.writeText((Object)"jQuery(document).ready(function() {\n", null);
            writer.writeText((Object)("    jQuery('.butter-modal[data-modal-id=\"" + component.getId() + "\"]').on('" + event + "', function () {\n"), component, null);
            writer.writeText((Object)("        " + function + ";\n"), component, null);
            writer.writeText((Object)"    });\n", component, null);
            writer.writeText((Object)"});\n", component, null);
        }
    }

    private void writerHeader(HtmlModalPanel component, FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIComponent header = this.getFacet((UIComponent)component, "header");
        if (header != null || StringUtils.isNotEmpty(component.getTitle())) {
            writer.startElement("div", (UIComponent)component);
            writer.writeAttribute("class", (Object)"modal-header", null);
            if (header != null) {
                header.encodeAll(context);
            } else {
                writer.startElement("h4", (UIComponent)component);
                writer.writeAttribute("class", (Object)"modal-title", null);
                writer.writeText((Object)component.getTitle(), (UIComponent)component, null);
                writer.endElement("h4");
            }
            writer.endElement("div");
        }
    }

    private void writeFooter(HtmlModalPanel component, FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", (UIComponent)component);
        writer.writeAttribute("class", (Object)"modal-footer butter-modal-footer", null);
        UIComponent footer = this.getFacet((UIComponent)component, "footer");
        if (footer != null) {
            footer.encodeAll(context);
        } else {
            writer.startElement("span", (UIComponent)component);
            writer.writeAttribute("class", (Object)"btn btn-danger pull-left", null);
            writer.writeAttribute("onClick", (Object)("butter.modal.close('" + component.getId() + "');"), null);
            if (StringUtils.isNotEmpty(component.getCancelButtonText())) {
                writer.writeText((Object)component.getCancelButtonText(), (UIComponent)component, null);
            } else {
                writer.writeText((Object)"Close", (UIComponent)component, null);
            }
            writer.endElement("span");
            UIComponent additionalFooter = this.getFacet((UIComponent)component, "additional-footer");
            if (additionalFooter != null) {
                writer.startElement("span", (UIComponent)component);
                writer.writeAttribute("class", (Object)"pull-right butter-modal-additional-footer", null);
                additionalFooter.encodeAll(context);
                writer.endElement("span");
            }
        }
        writer.endElement("div");
    }
}

