/*
 * Decompiled with CFR 0.152.
 */
package org.butterfaces.component.partrenderer;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.butterfaces.component.html.HtmlInputComponent;
import org.butterfaces.component.html.HtmlTooltip;
import org.butterfaces.component.html.feature.HideLabel;
import org.butterfaces.component.html.feature.Label;
import org.butterfaces.component.html.feature.Readonly;
import org.butterfaces.component.html.feature.Required;
import org.butterfaces.util.StringUtils;

public class LabelPartRenderer {
    public void renderLabel(UIComponent component, ResponseWriter responseWriter) throws IOException {
        this.renderLabel(component, responseWriter, component.getClientId());
    }

    public void renderLabel(UIComponent component, ResponseWriter responseWriter, String clientId) throws IOException {
        boolean readonly = component instanceof Readonly && ((Readonly)component).isReadonly();
        boolean required = component instanceof Required && ((Required)component).isRequired();
        String label = component instanceof Label ? ((Label)component).getLabel() : "";
        this.writeLabelIfNecessary(component, readonly, required, label, responseWriter, clientId);
    }

    private void writeLabelIfNecessary(UIComponent component, boolean readonly, boolean required, String label, ResponseWriter writer, String forClientId) throws IOException {
        boolean hideLabel = component instanceof HideLabel && ((HideLabel)component).isHideLabel();
        char separatorChar = UINamingContainer.getSeparatorChar((FacesContext)FacesContext.getCurrentInstance());
        if (!hideLabel) {
            writer.startElement("label", component);
            writer.writeAttribute("id", (Object)(forClientId + separatorChar + "label"), null);
            if (!readonly) {
                writer.writeAttribute("for", (Object)forClientId, null);
            }
            writer.writeAttribute("class", (Object)StringUtils.concatWithSpace("butter-component-label d-flex mt-2", this.shouldRenderTooltip(component) ? "butter-component-label-tooltip" : ""), null);
            if (!StringUtils.isEmpty(label)) {
                writer.startElement("abbr", component);
                writer.startElement("span", component);
                writer.writeText((Object)label, null);
                writer.endElement("span");
                this.writeRequiredSpanIfNecessary(forClientId, readonly, required, writer);
                writer.endElement("abbr");
            }
            writer.endElement("label");
        }
    }

    private boolean shouldRenderTooltip(UIComponent component) {
        if (component instanceof HtmlInputComponent && !((HtmlInputComponent)component).isValid()) {
            return true;
        }
        for (UIComponent uiComponent : component.getChildren()) {
            if (!(uiComponent instanceof HtmlTooltip) || !uiComponent.isRendered()) continue;
            return true;
        }
        return false;
    }

    private void writeRequiredSpanIfNecessary(String clientId, boolean readonly, boolean required, ResponseWriter writer) throws IOException {
        if (required && !readonly) {
            char separatorChar = UINamingContainer.getSeparatorChar((FacesContext)FacesContext.getCurrentInstance());
            writer.startElement("span", null);
            writer.writeAttribute("id", (Object)(clientId + separatorChar + "requiredLabel"), null);
            writer.writeAttribute("class", (Object)"butter-component-required", null);
            writer.endElement("span");
        }
    }
}

