/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.confluence.xmlrpc.model;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class MapObject {
    private static final SimpleDateFormat[] formats = new SimpleDateFormat[]{new SimpleDateFormat("EEE MMM d HH:mm:ss z yyyy", Locale.US), new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.US), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S", Locale.US), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SZ", Locale.US), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S", Locale.US), new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ", Locale.US), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US), new SimpleDateFormat("yyyy-MM-dd HH:mmZ", Locale.US), new SimpleDateFormat("yyyy-MM-dd HH:mm", Locale.US), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SZ", Locale.US), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.S", Locale.US), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.US), new SimpleDateFormat("yyyy-MM-dd'T'HH:mmZ", Locale.US), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm", Locale.US), new SimpleDateFormat("yyyy-MM-dd", Locale.US), new SimpleDateFormat("yyyyMMdd", Locale.US)};
    protected final Map<String, Object> fields;

    protected MapObject() {
        this(new HashMap<String, Object>());
    }

    protected MapObject(Map<String, Object> data) {
        this.fields = new HashMap<String, Object>(data);
    }

    protected String getString(String key) {
        Object o = this.fields.get(key);
        if (o instanceof String) {
            return (String)o;
        }
        if (o == null) {
            return null;
        }
        if (o instanceof Date) {
            return this.fromDate((Date)o);
        }
        return o.toString();
    }

    protected void setString(String key, String value) {
        this.fields.put(key, value);
    }

    protected void setInt(String key, int value) {
        this.fields.put(key, value);
    }

    protected int getInt(String key) {
        Object o = this.fields.get(key);
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        if (o instanceof String) {
            this.setLong(key, Integer.valueOf((String)o).intValue());
            return this.getInt(key);
        }
        if (o == null) {
            return 0;
        }
        throw new IllegalStateException("Field '" + key + "' is of unknown type: " + o.getClass().getName());
    }

    protected void setLong(String key, long value) {
        this.fields.put(key, value);
    }

    protected long getLong(String key) {
        Object o = this.fields.get(key);
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        if (o instanceof String) {
            this.setLong(key, Long.valueOf((String)o));
            return this.getLong(key);
        }
        if (o == null) {
            return 0L;
        }
        throw new IllegalStateException("Field '" + key + "' is of unknown type: " + o.getClass().getName());
    }

    protected void setBoolean(String key, boolean value) {
        this.fields.put(key, value);
    }

    protected void setBoolean(String key, String value) {
        boolean b = value.equalsIgnoreCase("true") || value.equals("1") || value.equalsIgnoreCase("yes");
        this.setBoolean(key, b);
    }

    protected boolean getBoolean(String key) {
        Object o = this.fields.get(key);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String) {
            this.setBoolean(key, (String)o);
            return this.getBoolean(key);
        }
        if (o == null) {
            return false;
        }
        throw new IllegalStateException("Field '" + key + "' is of unknown type: " + o.getClass().getName());
    }

    protected void setDate(String key, Date value) {
        this.fields.put(key, value);
    }

    protected void setDate(String key, String value) {
        this.fields.put(key, this.toDate(value));
    }

    protected Date getDate(String key) {
        Object o = this.fields.get(key);
        if (o instanceof Date) {
            return (Date)o;
        }
        if (o instanceof String) {
            this.setDate(key, (String)o);
            return this.getDate(key);
        }
        if (o == null) {
            return null;
        }
        throw new IllegalStateException("Field '" + key + "' is of unknown type: " + o.getClass().getName());
    }

    private String fromDate(Date value) {
        return formats[0].format(value);
    }

    private Date toDate(String value) {
        if (value == null || value.equals("")) {
            return new Date();
        }
        Throwable notParsable = null;
        for (int i = 0; i < formats.length; ++i) {
            try {
                return formats[i].parse(value);
            }
            catch (ParseException e) {
                notParsable = e;
                continue;
            }
        }
        notParsable.printStackTrace();
        return new Date();
    }

    private void checkXmlRpcTypes(Object object) {
        boolean checkPassed = false;
        if (object.getClass().isArray()) {
            Object[] objects = (Object[])object;
            for (int i = 0; i < objects.length; ++i) {
                this.checkXmlRpcTypes(objects[i]);
            }
            checkPassed = true;
        } else if (object instanceof List) {
            List list = (List)object;
            for (int i = 0; i < list.size(); ++i) {
                this.checkXmlRpcTypes(list.get(i));
            }
            checkPassed = true;
        } else if (object instanceof Map) {
            Map map = (Map)object;
            for (Object key : map.keySet()) {
                Object value = map.get(key);
                this.checkXmlRpcTypes(value);
            }
            checkPassed = true;
        } else if (object instanceof String) {
            checkPassed = true;
        } else if (object instanceof Date) {
            checkPassed = true;
        } else if (object instanceof Integer) {
            checkPassed = true;
        } else if (object instanceof Boolean) {
            checkPassed = true;
        }
        if (!checkPassed) {
            throw new IllegalStateException("Object '" + object.toString() + "' has a not supported type " + object.getClass().getName());
        }
    }

    protected void setList(String key, List<?> value) {
        this.checkXmlRpcTypes(value);
        this.fields.put(key, value);
    }

    protected List<?> getList(String key) {
        Object objects = this.fields.get(key);
        if (objects == null) {
            return null;
        }
        if (objects instanceof List) {
            return (List)objects;
        }
        if (objects.getClass().isArray()) {
            ArrayList<Object> result = new ArrayList<Object>();
            Object[] array = (Object[])objects;
            for (int i = 0; i < array.length; ++i) {
                result.add(array[i]);
            }
            return result;
        }
        throw new IllegalStateException("Field '" + key + "' is of unknown type: " + objects.getClass().getName());
    }

    protected void setMap(String key, Map<String, Object> value) {
        this.checkXmlRpcTypes(value);
        this.fields.put(key, value);
    }

    protected Map<String, Object> getMap(String key) {
        Object object = this.fields.get(key);
        if (object == null) {
            return null;
        }
        if (object instanceof Map) {
            return (Map)object;
        }
        throw new IllegalStateException("Field '" + key + "' is of unknown type: " + object.getClass().getName());
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>(this.fields.size());
        for (String key : this.fields.keySet()) {
            map.put(key, this.getString(key));
        }
        return map;
    }

    public Map<String, Object> toRawMap() {
        return new HashMap<String, Object>(this.fields);
    }

    public String toString() {
        return this.toMap().toString();
    }
}

