/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.mojo;

import biz.source_code.miniTemplator.MiniTemplator;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.bsc.AsyncFunctionDefinition;
import org.bsc.confluence.ConfluenceService;
import org.bsc.confluence.DeployStateManager;
import org.bsc.confluence.model.Site;
import org.bsc.confluence.model.SiteFactory;
import org.bsc.confluence.model.SitePrinter;
import org.bsc.confluence.model.SiteProcessor;
import org.bsc.markdown.MarkdownProcessor;
import org.bsc.mojo.AbstractBaseConfluenceSiteMojo;
import org.bsc.mojo.DeployStateSupport;
import org.bsc.mojo.configuration.DeployStateInfo;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class AbstractConfluenceDeployMojo
extends AbstractBaseConfluenceSiteMojo
implements SiteFactory.Folder,
DeployStateSupport {
    @Parameter(defaultValue="${basedir}/src/site/confluence/template.wiki")
    protected File templateWiki;
    @Parameter(property="confluence.removeSnapshots", required=false, defaultValue="false")
    protected boolean removeSnapshots = false;
    @Parameter(property="confluence.childrenTitlesPrefixed", required=false, defaultValue="true")
    protected boolean childrenTitlesPrefixed = true;
    @Parameter
    List<String> labels;
    @Parameter(property="wikiFilesExt", required=false, defaultValue=".wiki")
    private String wikiFilesExt;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter
    protected DeployStateInfo deployState = new DeployStateInfo(false);
    @Parameter(defaultValue="true")
    private boolean processProperties = true;
    private DeployStateManager _deployStateManager = null;

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    protected final Charset getCharset() {
        if (this.encoding == null) {
            this.getLog().debug((CharSequence)"encoding is null! default charset will be used");
            return Charset.defaultCharset();
        }
        try {
            Charset result = Charset.forName(this.encoding);
            return result;
        }
        catch (UnsupportedCharsetException e) {
            this.getLog().warn((CharSequence)String.format("encoding [%s] is not valid! default charset will be used", this.encoding));
            return Charset.defaultCharset();
        }
    }

    public String getFileExt() {
        return this.wikiFilesExt.charAt(0) == '.' ? this.wikiFilesExt : ".".concat(this.wikiFilesExt);
    }

    @Override
    public MavenProject getProject() {
        return this.project;
    }

    public boolean isRemoveSnapshots() {
        return this.removeSnapshots;
    }

    public boolean isSnapshot() {
        String version = this.project.getVersion();
        return version != null && version.endsWith("-SNAPSHOT");
    }

    public boolean isChildrenTitlesPrefixed() {
        return this.childrenTitlesPrefixed;
    }

    public List<String> getLabels() {
        if (this.labels == null) {
            return Collections.emptyList();
        }
        return this.labels;
    }

    @Override
    public final DeployStateInfo getDeployState() {
        return this.deployState;
    }

    public final Optional<DeployStateManager> getDeployStateManager() {
        return Optional.ofNullable(this._deployStateManager);
    }

    private void initTemplateProperties(Site site) {
        this.processProperties(site);
        this.getProperties().put("pageTitle", this.getPageTitle());
        this.getProperties().put("home.title", this.getPageTitle());
        this.getProperties().put("page.title", this.getPageTitle());
        this.getProperties().put("artifactId", this.project.getArtifactId());
        this.getProperties().put("version", this.project.getVersion());
        this.getProperties().put("groupId", this.project.getGroupId());
        this.getProperties().put("name", this.project.getName());
        this.getProperties().put("description", this.project.getDescription());
        Properties projectProps = this.project.getProperties();
        if (projectProps != null) {
            for (Map.Entry<Object, Object> e : projectProps.entrySet()) {
                this.getProperties().put(String.valueOf(e.getKey()), String.valueOf(e.getValue()));
            }
        }
    }

    @Override
    public void execute(ConfluenceService confluenceService) throws Exception {
        MarkdownProcessor.shared.init();
        this._deployStateManager = this.initDeployStateManager().orElse(null);
    }

    protected <S extends Site.Source> String getPrintableStringForResource(S source) {
        URI uri = source.getUri();
        try {
            Path p = Paths.get(uri);
            return this.getProject().getBasedir().toPath().relativize(p).toString();
        }
        catch (Exception e) {
            return uri.toString();
        }
    }

    private <T extends Site.Page> CompletableFuture<ConfluenceService.Storage> getPageContent(ConfluenceService.Model.Page pageToUpdate, Site site, URI source, T child, String pageTitleToApply) {
        String pagePrefixToApply = this.isChildrenTitlesPrefixed() ? this.getPageTitle() : null;
        return SiteProcessor.processPageUri((Site)site, child, (ConfluenceService.Model.Page)pageToUpdate, (URI)source, (String)pagePrefixToApply).thenCompose(content -> {
            CompletableFuture<ConfluenceService.Storage> result = new CompletableFuture<ConfluenceService.Storage>();
            try {
                MiniTemplator t = new MiniTemplator.Builder().setSkipUndefinedVars(true).setCharset(this.getCharset()).build(content.getInputStream(this.getCharset()));
                if (!child.isIgnoreVariables().booleanValue()) {
                    this.addStdProperties(t);
                    t.setVariableOpt("childTitle", pageTitleToApply);
                    t.setVariableOpt("page.title", pageTitleToApply);
                }
                result.complete(ConfluenceService.Storage.of((String)t.generateOutput(), (ConfluenceService.Storage.Representation)content.getType()));
            }
            catch (Exception ex) {
                result.completeExceptionally(ex);
            }
            return result;
        });
    }

    protected CompletableFuture<ConfluenceService.Model.Page> saveAttributesToDeployStateManager(Site.Page sitePage, ConfluenceService.Model.Page confluencePage) {
        return this.getDeployStateManager().map(dsm -> {
            DeployStateManager.Data attributes = DeployStateManager.Data.create().setAttributeString("id", confluencePage.getId().toString()).setAttributeInt("version", Integer.valueOf(confluencePage.getVersion()));
            dsm.setAttributes(sitePage.getUri(), attributes);
            return CompletableFuture.completedFuture(confluencePage);
        }).orElse(CompletableFuture.completedFuture(confluencePage));
    }

    protected CompletableFuture<ConfluenceService.Model.Page> updatePageIfNeeded(Site.Page sitePage, ConfluenceService.Model.Page confluencePage, Supplier<CompletableFuture<ConfluenceService.Model.Page>> performUpdate) {
        return this.canProceedToUpdatePage(sitePage, confluencePage, () -> ((CompletableFuture)performUpdate.get()).thenApply(p -> {
            this.getLog().info((CharSequence)String.format("page [%s] updated!", this.getPrintableStringForResource(sitePage)));
            return p;
        }), () -> CompletableFuture.completedFuture(confluencePage).thenApply(p -> {
            this.getLog().info((CharSequence)String.format("page [%s] not updated! (deploy skipped)", this.getPrintableStringForResource(sitePage)));
            return p;
        }));
    }

    protected <T extends Site.Page> ConfluenceService.Model.Page generateChild(ConfluenceService confluence, Site site, T child, ConfluenceService.Model.Page parentPage) {
        String pageTitleToApply;
        String homeTitle = site.getHome().getName();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)(String.format("generateChild", parentPage.getSpace()) + "\n\t" + String.format("spacekey=[%s]", homeTitle) + "\n\t" + String.format("home=[%s]", homeTitle) + "\n\t" + String.format("parent=[%s]", parentPage.getTitle()) + "\n\t" + String.format("page=[%s]", child.getName()) + "\n\t" + String.format("%s", this.getPrintableStringForResource((Site.Source)child))));
        }
        String string = pageTitleToApply = this.isChildrenTitlesPrefixed() ? String.format("%s - %s", homeTitle, child.getName()) : child.getName();
        if (!this.isSnapshot() && this.isRemoveSnapshots()) {
            String snapshot = pageTitleToApply.concat("-SNAPSHOT");
            ((CompletableFuture)confluence.removePage(parentPage, snapshot).thenAccept(deleted -> this.getLog().info((CharSequence)String.format("Page [%s] removed!", snapshot)))).join();
        }
        URI uri = child.getUri();
        AsyncFunctionDefinition.AsyncProcessPageFunc updatePageFunction = p -> this.updatePageIfNeeded(child, (ConfluenceService.Model.Page)p, () -> ((CompletableFuture)this.getPageContent((ConfluenceService.Model.Page)p, site, uri, child, pageTitleToApply).thenCompose(storage -> confluence.storePage(p, storage))).thenCompose(page -> this.saveAttributesToDeployStateManager(child, (ConfluenceService.Model.Page)page)));
        AsyncFunctionDefinition.AsyncPageSupplier createPageFunction = () -> ((CompletableFuture)this.getPageContent(null, site, uri, child, pageTitleToApply).thenCompose(storage -> confluence.createPage(parentPage, pageTitleToApply, storage))).thenCompose(page -> this.saveAttributesToDeployStateManager(child, (ConfluenceService.Model.Page)page));
        AsyncFunctionDefinition.AsyncPageFunc createOrUpdate = optPage -> optPage.map(page -> (CompletableFuture)updatePageFunction.apply(page)).orElseGet(() -> (CompletableFuture)createPageFunction.get());
        AsyncFunctionDefinition.AsyncSupplier getPage = () -> {
            Optional attributes = this.getDeployStateManager().flatMap(dsm -> dsm.getAttributes(child.getUri()));
            return attributes.flatMap(attrs -> attrs.getAttributeString("id").map(id -> confluence.newPage(ConfluenceService.Model.ID.of((String)id), parentPage.getSpace(), pageTitleToApply, attrs.getAttributeInt("version").orElse(0).intValue())).map(p -> CompletableFuture.completedFuture(Optional.of(p)))).orElse(confluence.getPage(parentPage.getSpace(), pageTitleToApply));
        };
        return (ConfluenceService.Model.Page)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)getPage.get()).thenCompose((Function)createOrUpdate)).thenCompose(p -> confluence.addLabelsByName(p.getId(), child.getComputedLabels()).thenApply(v -> p))).thenApply(p -> {
            child.setName(pageTitleToApply);
            return p;
        })).join();
    }

    private void processProperties(Site site) {
        if (!this.processProperties) {
            return;
        }
        for (Map.Entry<String, String> e : this.getProperties().entrySet()) {
            try {
                String v = e.getValue();
                if (v == null) {
                    this.getLog().warn((CharSequence)String.format("property [%s] has null value!", e.getKey()));
                    continue;
                }
                URI uri = new URI(v);
                if (uri.getScheme() == null) continue;
                ((CompletableFuture)((CompletableFuture)this.processUriContent(site, (Site.Page)site.getHome(), uri, this.getCharset()).thenAccept(content -> this.getProperties().put((String)e.getKey(), (String)content))).exceptionally(ex -> {
                    this.getLog().warn((CharSequence)String.format("error processing value of property [%s] - %s", e.getKey(), ex.getMessage()));
                    return null;
                })).join();
            }
            catch (URISyntaxException ex2) {
                this.getLog().debug((CharSequence)String.format("property [%s] is not a valid uri", e.getKey()));
            }
        }
    }

    private <U> CompletableFuture<U> canProceedToUpdatePage(Site.Page sitePage, ConfluenceService.Model.Page confluencePage, Supplier<CompletableFuture<U>> yes, Supplier<CompletableFuture<U>> no) {
        DeployStateManager.Data attributes = DeployStateManager.Data.create().setAttributeString("id", confluencePage.getId().toString()).setAttributeInt("version", Integer.valueOf(confluencePage.getVersion()));
        return this.getDeployStateManager().map(dsm -> dsm.isUpdated(sitePage.getUri(), attributes, yes, no)).orElseGet(() -> (CompletableFuture)yes.get());
    }

    private <U> CompletableFuture<U> canProceedToUpdateAttachment(Site.Attachment siteAttachment, ConfluenceService.Model.Attachment confluenceAttachment, Supplier<CompletableFuture<U>> yes, Supplier<CompletableFuture<U>> no) {
        return this.getDeployStateManager().map(dsm -> dsm.isUpdated(siteAttachment.getUri(), null, yes, no)).orElseGet(() -> (CompletableFuture)yes.get());
    }

    private CompletableFuture<String> processUriContent(Site site, Site.Page child, URI uri, Charset charset) {
        String pagePrefixToApply = this.isChildrenTitlesPrefixed() ? this.getPageTitle() : null;
        return SiteProcessor.processUriContent((Site)site, (Site.Page)child, (URI)uri, (String)pagePrefixToApply).thenApply(pageContent -> pageContent.getContent(charset));
    }

    private void setPageUriFormFile(Site.Page page, File source) {
        if (page == null) {
            throw new IllegalArgumentException("page is null!");
        }
        if (source != null && source.exists() && source.isFile() && source.canRead()) {
            page.setUri(source.toURI());
        } else {
            try {
                URL sourceUrl = this.getClass().getClassLoader().getResource("defaultTemplate.confluence");
                page.setUri(sourceUrl.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    private DirectoryStream<Path> newDirectoryStream(Path attachmentPath, Site.Attachment attachment) throws IOException {
        if (StringUtils.isNotBlank((String)attachment.getName())) {
            return Files.newDirectoryStream(attachmentPath, attachment.getName());
        }
        DirectoryStream.Filter<Path> filter = entry -> !Files.isDirectory(entry, new LinkOption[0]) && !Files.isHidden(entry) && !Files.isSymbolicLink(entry) && Files.isReadable(entry);
        return Files.newDirectoryStream(attachmentPath, filter);
    }

    private void generateAttachments(ConfluenceService confluence, Site site, Site.Page page, ConfluenceService.Model.Page confluencePage) {
        this.getLog().debug((CharSequence)String.format("generateAttachments pageId [%s] title [%s]", confluencePage.getId(), confluencePage.getTitle()));
        for (Site.Attachment attachment : page.getAttachments()) {
            Path attachmentPath = Paths.get(attachment.getUri());
            try {
                if (!Files.isDirectory(attachmentPath, new LinkOption[0])) {
                    ConfluenceService.Model.Attachment result = this.generateAttachment(confluence, site, confluencePage, attachment).get();
                    this.getLog().debug((CharSequence)String.format("generated attachment: %s", result.toString()));
                    continue;
                }
                try {
                    DirectoryStream<Path> dirStream = this.newDirectoryStream(attachmentPath, attachment);
                    Throwable throwable = null;
                    try {
                        for (Path p : dirStream) {
                            Site.Attachment fileAttachment = new Site.Attachment();
                            fileAttachment.setName(p.getFileName().toString());
                            fileAttachment.setUri(p.toUri());
                            fileAttachment.setComment(attachment.getComment());
                            fileAttachment.setVersion(attachment.getVersion());
                            if (StringUtils.isNotEmpty((String)attachment.getContentType())) {
                                fileAttachment.setContentType(attachment.getContentType());
                            }
                            ConfluenceService.Model.Attachment result = this.generateAttachment(confluence, site, confluencePage, fileAttachment).get();
                            this.getLog().debug((CharSequence)String.format("generated attachment: %s", result.toString()));
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (dirStream == null) continue;
                        if (throwable != null) {
                            try {
                                dirStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        dirStream.close();
                    }
                }
                catch (IOException ex) {
                    this.getLog().warn((CharSequence)String.format("error reading directory [%s]", attachmentPath), (Throwable)ex);
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                this.getLog().warn((CharSequence)String.format("error generating remote attachment from [%s]", attachment.getName()), (Throwable)ex);
            }
        }
    }

    private CompletableFuture<ConfluenceService.Model.Attachment> updateAttachmentData(ConfluenceService confluence, Site site, URI uri, ConfluenceService.Model.Page confluencePage, ConfluenceService.Model.Attachment attachment) {
        return (CompletableFuture)SiteProcessor.processUri((URI)uri, (err, is) -> {
            if (err.isPresent()) {
                CompletableFuture result = new CompletableFuture();
                result.completeExceptionally((Throwable)err.get());
                return result;
            }
            if (!is.isPresent()) {
                this.getLog().warn((CharSequence)String.format("getting problem to read local attacchment file at [%s]", uri));
                return CompletableFuture.completedFuture(attachment);
            }
            return confluence.addAttachment(confluencePage, attachment, (InputStream)is.get());
        });
    }

    protected CompletableFuture<ConfluenceService.Model.Attachment> updateAttachmentIfNeeded(Site.Attachment siteAttachment, ConfluenceService.Model.Attachment confluenceAttachment, Supplier<CompletableFuture<ConfluenceService.Model.Attachment>> performUpdate) {
        return this.canProceedToUpdateAttachment(siteAttachment, confluenceAttachment, () -> ((CompletableFuture)performUpdate.get()).thenApply(p -> {
            this.getLog().info((CharSequence)String.format("attachment [%s] updated!", this.getPrintableStringForResource(siteAttachment)));
            return p;
        }), () -> CompletableFuture.completedFuture(confluenceAttachment).thenApply(p -> {
            this.getLog().info((CharSequence)String.format("attachment [%s] not updated! (deploy skipped)", this.getPrintableStringForResource(siteAttachment)));
            return p;
        }));
    }

    private CompletableFuture<ConfluenceService.Model.Attachment> generateAttachment(ConfluenceService confluence, Site site, ConfluenceService.Model.Page confluencePage, Site.Attachment attachment) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("generateAttachment" + "\n\t" + String.format("pageId:[%s]", confluencePage.getId()) + "\n\t" + String.format("title:[%s]", confluencePage.getTitle()) + "\n\t" + String.format("file:[%s]", this.getPrintableStringForResource(attachment))));
        }
        URI uri = attachment.getUri();
        ConfluenceService.Model.Attachment defaultAttachment = confluence.newAttachment();
        defaultAttachment.setFileName(attachment.getName());
        defaultAttachment.setContentType(attachment.getContentType());
        defaultAttachment.setComment(attachment.getComment());
        return this.updateAttachmentIfNeeded(attachment, defaultAttachment, () -> ((CompletableFuture)((CompletableFuture)confluence.getAttachment(confluencePage.getId(), attachment.getName(), attachment.getVersion()).exceptionally(e -> {
            this.getLog().debug((CharSequence)String.format("Error getting attachment [%s] from confluence: [%s]", attachment.getName(), e.getMessage()));
            return Optional.empty();
        })).thenCompose(optAttachment -> optAttachment.map(result -> {
            result.setContentType(attachment.getContentType());
            result.setComment(attachment.getComment());
            return CompletableFuture.completedFuture(result);
        }).orElseGet(() -> CompletableFuture.completedFuture(defaultAttachment)))).thenCompose(finalAttachment -> this.updateAttachmentData(confluence, site, uri, confluencePage, (ConfluenceService.Model.Attachment)finalAttachment)));
    }

    protected void generateChildren(ConfluenceService confluence, Site site, Site.Page parentPage, ConfluenceService.Model.Page confluenceParentPage, Map<String, ConfluenceService.Model.Page> varsToParentPageMap) {
        this.getLog().debug((CharSequence)String.format("generateChildren # [%d]", parentPage.getChildren().size()));
        this.generateAttachments(confluence, site, parentPage, confluenceParentPage);
        for (Site.Page child : parentPage.getChildren()) {
            ConfluenceService.Model.Page confluencePage = this.generateChild(confluence, site, child, confluenceParentPage);
            for (Site.Page.Generated generated : child.getGenerateds()) {
                varsToParentPageMap.put(generated.getRef(), confluencePage);
            }
            if (confluencePage == null) continue;
            this.generateChildren(confluence, site, child, confluencePage, varsToParentPageMap);
        }
    }

    protected boolean navigateAttachments(File folder, Site.Page page) {
        if (folder.exists() && folder.isDirectory()) {
            File[] files = folder.listFiles();
            if (files != null && files.length > 0) {
                for (File f : files) {
                    if (f.isDirectory() || f.isHidden()) continue;
                    Site.Attachment a = new Site.Attachment();
                    a.setName(f.getName());
                    a.setUri(f.toURI());
                    page.getAttachments().add(a);
                }
            }
            return true;
        }
        return false;
    }

    protected void navigateChild(int level, File folder, Site.Page parentChild) {
        if (folder.exists() && folder.isDirectory()) {
            folder.listFiles(file -> {
                if (file.isHidden() || file.getName().charAt(0) == '.') {
                    return false;
                }
                if (file.isDirectory()) {
                    if (this.navigateAttachments(file, parentChild)) {
                        return false;
                    }
                    Site.Page child = new Site.Page();
                    child.setName(file.getName());
                    this.setPageUriFormFile(child, new File(file, this.templateWiki.getName()));
                    parentChild.getChildren().add(child);
                    this.navigateChild(level + 1, file, child);
                    return true;
                }
                String fileName = file.getName();
                if (!file.isFile() || !file.canRead() || !fileName.endsWith(this.getFileExt()) || fileName.equals(this.templateWiki.getName())) {
                    return false;
                }
                Site.Page child = new Site.Page();
                int extensionLen = this.getFileExt().length();
                child.setName(fileName.substring(0, fileName.length() - extensionLen));
                this.setPageUriFormFile(child, file);
                parentChild.getChildren().add(child);
                return false;
            });
        }
    }

    public final Site createSiteFromFolder() {
        final Site result = new Site();
        result.getLabels().addAll(this.getLabels());
        Site.Home home = new Site.Home();
        home.setName(this.getPageTitle());
        this.setPageUriFormFile((Site.Page)home, this.templateWiki);
        result.setHome(home);
        this.navigateAttachments(this.getAttachmentFolder(), (Site.Page)home);
        if (this.getChildrenFolder().exists() && this.getChildrenFolder().isDirectory()) {
            this.getChildrenFolder().listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file.isHidden() || file.getName().charAt(0) == '.') {
                        return false;
                    }
                    if (file.isDirectory()) {
                        Site.Page parentChild = new Site.Page();
                        parentChild.setName(file.getName());
                        AbstractConfluenceDeployMojo.this.setPageUriFormFile(parentChild, new File(file, AbstractConfluenceDeployMojo.this.templateWiki.getName()));
                        result.getHome().getChildren().add(parentChild);
                        AbstractConfluenceDeployMojo.this.navigateChild(1, file, parentChild);
                        return false;
                    }
                    String fileName = file.getName();
                    if (!file.isFile() || !file.canRead() || !fileName.endsWith(AbstractConfluenceDeployMojo.this.getFileExt()) || fileName.equals(AbstractConfluenceDeployMojo.this.templateWiki.getName())) {
                        return false;
                    }
                    Site.Page child = new Site.Page();
                    int extensionLen = AbstractConfluenceDeployMojo.this.getFileExt().length();
                    child.setName(fileName.substring(0, fileName.length() - extensionLen));
                    AbstractConfluenceDeployMojo.this.setPageUriFormFile(child, file);
                    result.getHome().getChildren().add(child);
                    return false;
                }
            });
        }
        return result;
    }

    protected Site loadSite() {
        Site site = this.createSiteFromModel(this.getSiteModelVariables());
        if (site != null) {
            site.setBasedir(this.getSiteDescriptor().toPath());
            if (site.getHome().getName() != null) {
                this.setPageTitle(site.getHome().getName());
            } else {
                site.getHome().setName(this.getPageTitle());
            }
            List<String> _labels = this.getLabels();
            if (!_labels.isEmpty()) {
                site.getLabels().addAll(_labels);
            }
        } else {
            site = this.createSiteFromFolder();
            try {
                Path p = this.templateWiki.toPath();
                site.setBasedir(p);
            }
            catch (Exception e) {
                site.setBasedir(this.getSiteDescriptor().toPath());
            }
        }
        SitePrinter.print((Site)site, (PrintStream)System.out);
        site.setDefaultFileExt(this.getFileExt());
        this.initTemplateProperties(site);
        return site;
    }
}

