/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.mojo;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.stream.Collectors;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.bsc.AsyncFunctionDefinition;
import org.bsc.confluence.ConfluenceProxy;
import org.bsc.confluence.ConfluenceService;
import org.bsc.confluence.ConfluenceServiceFactory;
import org.bsc.confluence.model.Site;
import org.bsc.mojo.configuration.ScrollVersionsInfo;
import org.bsc.ssl.SSLCertificateInfo;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.sonatype.plexus.components.sec.dispatcher.DefaultSecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class AbstractBaseConfluenceMojo
extends AbstractMojo
implements AsyncFunctionDefinition {
    @Parameter(defaultValue="false")
    protected boolean skip = false;
    @Parameter
    private Map<String, String> properties;
    @Parameter(property="confluence.endPoint", defaultValue="http://localhost:8080/rpc/xmlrpc")
    private String endPoint;
    @Parameter(property="confluence.spaceKey", required=false)
    private String spaceKey;
    @Parameter(property="confluence.parentPage", defaultValue="Home")
    private String parentPageTitle;
    @Parameter(property="confluence.parentPageId")
    private String parentPageId;
    @Parameter(property="confluence.userName", required=false)
    private String username;
    @Parameter(property="confluence.password", required=false)
    private String password;
    @Parameter(property="confluence.httpHeaders", required=false)
    private Map<String, String> httpHeaders = new HashMap<String, String>();
    @Parameter(readonly=true, property="settings")
    protected Settings mavenSettings;
    @Parameter(property="confluence.serverId")
    private String serverId;
    @Component(role=SecDispatcher.class, hint="default")
    private SecDispatcher securityDispatcher;
    @Parameter
    protected SSLCertificateInfo sslCertificate = new SSLCertificateInfo();
    @Parameter(property="confluence.failOnError", defaultValue="true")
    private boolean failOnError = true;
    @Parameter(name="scrollVersions")
    private ScrollVersionsInfo scrollVersions = new ScrollVersionsInfo();
    @Parameter(property="confluence.timeout.connect.secs", defaultValue="10")
    private long connectTimeoutInSeconds = 10L;
    @Parameter(property="confluence.timeout.write.secs", defaultValue="10")
    private long writeTimeoutInSeconds = 10L;
    @Parameter(property="confluence.timeout.read.secs", defaultValue="10")
    private long readTimeoutInSeconds = 10L;

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public final String getEndPoint() {
        return this.endPoint;
    }

    public final String getSpaceKey() {
        return this.spaceKey;
    }

    public final String getUsername() {
        return this.username;
    }

    public final String getPassword() {
        return this.password;
    }

    public final Map<String, String> getHttpHeaders() {
        return this.httpHeaders;
    }

    public final Map<String, String> getProperties() {
        if (null == this.properties) {
            this.properties = new HashMap<String, String>(5);
        }
        return this.properties;
    }

    protected CompletableFuture<ConfluenceService.Model.Page> loadParentPage(ConfluenceService confluence, Optional<Site> site) {
        return CompletableFuture.supplyAsync(() -> {
            String _spaceKey = site.flatMap(s -> s.optSpaceKey()).orElse(this.spaceKey);
            String _parentPageId = site.flatMap(s -> s.getHome().optParentPageId()).orElse(this.parentPageId);
            String _parentPageTitle = site.flatMap(s -> s.getHome().optParentPageTitle()).orElse(this.parentPageTitle);
            Optional result = Optional.empty();
            if (_parentPageId != null && !(result = (Optional)confluence.getPage(ConfluenceService.Model.ID.of((String)_parentPageId)).join()).isPresent()) {
                this.getLog().warn((CharSequence)String.format("parentPageId [%s] not found! Try with parentPageTitle [%s] in space [%s]", _parentPageId, _parentPageTitle, this.spaceKey));
            }
            if (!result.isPresent()) {
                if (_spaceKey == null) {
                    throw new IllegalStateException("spaceKey is not set!");
                }
                result = (Optional)confluence.getPage(_spaceKey, _parentPageTitle).join();
            }
            if (result.isPresent()) {
                this.getProperties().put("parentPageTitle", ((ConfluenceService.Model.Page)result.get()).getTitle());
            } else {
                this.throwRTE("cannot get page with parentPageTitle [%s] in space [%s]!", this.parentPageTitle, this.spaceKey);
            }
            return (ConfluenceService.Model.Page)result.get();
        });
    }

    private void loadUserInfoFromSettings() throws MojoExecutionException {
        if ((this.getUsername() == null || this.getPassword() == null) && this.mavenSettings != null) {
            if (this.serverId == null) {
                throw new MojoExecutionException("'serverId' must be set! (username and/or password are not provided)");
            }
            Server server = this.mavenSettings.getServer(this.serverId);
            if (server == null) {
                throw new MojoExecutionException(String.format("server with id [%s] not found in settings!", this.serverId));
            }
            if (this.getUsername() == null && server.getUsername() != null) {
                this.username = server.getUsername();
            }
            if (this.getPassword() == null && server.getPassword() != null) {
                try {
                    if (this.securityDispatcher instanceof DefaultSecDispatcher) {
                        ((DefaultSecDispatcher)this.securityDispatcher).setConfigurationFile("~/.m2/settings-security.xml");
                    }
                    this.password = this.securityDispatcher.decrypt(server.getPassword());
                }
                catch (SecDispatcherException e) {
                    throw new MojoExecutionException(e.getMessage());
                }
            }
            if (this.getHttpHeaders().isEmpty() && server.getConfiguration() != null) {
                this.httpHeaders = Arrays.stream(((Xpp3Dom)server.getConfiguration()).getChild("httpHeaders").getChildren()).filter(child -> child.getName().equals("property") && child.getChild("name") != null && child.getChild("value") != null).collect(Collectors.toMap(property -> property.getChild("name").getValue(), property -> property.getChild("value").getValue()));
            }
        }
    }

    protected RuntimeException RTE(String message, Object ... args) {
        Object[] arguments = args;
        String m = String.format(message, arguments);
        if (arguments.length > 0 && arguments[arguments.length - 1] instanceof Throwable) {
            return new RuntimeException(m, (Throwable)arguments[arguments.length - 1]);
        }
        return new RuntimeException(m);
    }

    protected <T> T throwRTE(String message, Object ... args) {
        throw this.RTE(message, args);
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.getLog().isDebugEnabled()) {
            System.setProperty("org.apache.commons.logging.simplelog.defaultlog", "debug");
            Arrays.stream(LogManager.getLogManager().getLogger("").getHandlers()).forEach(h -> h.setLevel(Level.FINE));
        }
        if (this.skip) {
            this.getLog().info((CharSequence)"plugin execution skipped");
            return;
        }
        this.loadUserInfoFromSettings();
        Optional<ConfluenceProxy> proxyInfo = Optional.ofNullable(this.mavenSettings.getActiveProxy()).map(activeProxy -> ConfluenceProxy.of((String)activeProxy.getHost(), (int)activeProxy.getPort(), (String)activeProxy.getUsername(), (String)activeProxy.getPassword(), (String)activeProxy.getNonProxyHosts()));
        ConfluenceService.Credentials credentials = new ConfluenceService.Credentials(this.getUsername(), this.getPassword(), this.getHttpHeaders());
        ConfluenceService.setConnectTimeouts((long)this.connectTimeoutInSeconds, (TimeUnit)TimeUnit.SECONDS);
        ConfluenceService.setReadTimeouts((long)this.readTimeoutInSeconds, (TimeUnit)TimeUnit.SECONDS);
        ConfluenceService.setWriteTimeouts((long)this.writeTimeoutInSeconds, (TimeUnit)TimeUnit.SECONDS);
        try (ConfluenceService confluence = ConfluenceServiceFactory.createInstance(this.getEndPoint(), credentials, proxyInfo.orElse(null), this.sslCertificate, this.scrollVersions);){
            this.execute(confluence);
        }
        catch (Exception e) {
            String msg = "error generating report";
            Throwable cause = e.getCause();
            if (this.isFailOnError()) {
                throw new MojoExecutionException("error generating report", cause != null ? cause : e);
            }
            this.getLog().error((CharSequence)"error generating report", cause != null ? cause : e);
        }
    }

    public abstract void execute(ConfluenceService var1) throws Exception;
}

